/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ParseContext;

public class ExplainWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Path resFile;
    private ArrayList<Task<? extends Serializable>> rootTasks;
    private Task<? extends Serializable> fetchTask;
    private HashSet<ReadEntity> inputs;
    private ParseContext pCtx;
    private ExplainConfiguration config;
    boolean appendTaskType;
    String cboInfo;
    private transient BaseSemanticAnalyzer analyzer;

    public ExplainWork() {
    }

    public ExplainWork(Path resFile, ParseContext pCtx, List<Task<? extends Serializable>> rootTasks, Task<? extends Serializable> fetchTask, BaseSemanticAnalyzer analyzer, ExplainConfiguration config, String cboInfo) {
        this.resFile = resFile;
        this.rootTasks = new ArrayList<Task<? extends Serializable>>(rootTasks);
        this.fetchTask = fetchTask;
        this.analyzer = analyzer;
        if (analyzer != null) {
            this.inputs = analyzer.getInputs();
        }
        this.pCtx = pCtx;
        this.cboInfo = cboInfo;
        this.config = config;
    }

    public Path getResFile() {
        return this.resFile;
    }

    public void setResFile(Path resFile) {
        this.resFile = resFile;
    }

    public ArrayList<Task<? extends Serializable>> getRootTasks() {
        return this.rootTasks;
    }

    public void setRootTasks(ArrayList<Task<? extends Serializable>> rootTasks) {
        this.rootTasks = rootTasks;
    }

    public Task<? extends Serializable> getFetchTask() {
        return this.fetchTask;
    }

    public void setFetchTask(Task<? extends Serializable> fetchTask) {
        this.fetchTask = fetchTask;
    }

    public HashSet<ReadEntity> getInputs() {
        return this.inputs;
    }

    public void setInputs(HashSet<ReadEntity> inputs) {
        this.inputs = inputs;
    }

    public boolean getExtended() {
        return this.config.isExtended();
    }

    public boolean getDependency() {
        return this.config.isDependency();
    }

    public boolean isFormatted() {
        return this.config.isFormatted();
    }

    public boolean isVectorization() {
        return this.config.isVectorization();
    }

    public boolean isVectorizationOnly() {
        return this.config.isVectorizationOnly();
    }

    public ExplainConfiguration.VectorizationDetailLevel isVectorizationDetailLevel() {
        return this.config.getVectorizationDetailLevel();
    }

    public ParseContext getParseContext() {
        return this.pCtx;
    }

    public void setParseContext(ParseContext pCtx) {
        this.pCtx = pCtx;
    }

    public boolean isLogical() {
        return this.config.isLogical();
    }

    public boolean isAppendTaskType() {
        return this.appendTaskType;
    }

    public void setAppendTaskType(boolean appendTaskType) {
        this.appendTaskType = appendTaskType;
    }

    public boolean isAuthorize() {
        return this.config.isAuthorize();
    }

    public BaseSemanticAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public boolean isUserLevelExplain() {
        return this.config.isUserLevelExplain();
    }

    public String getCboInfo() {
        return this.cboInfo;
    }

    public void setCboInfo(String cboInfo) {
        this.cboInfo = cboInfo;
    }

    public ExplainConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(ExplainConfiguration config) {
        this.config = config;
    }
}

