/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongToStringUnaryUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class CastDateToString
extends LongToStringUnaryUDF {
    private static final long serialVersionUID = 1L;
    protected transient Date dt = new Date(0L);
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public CastDateToString() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public CastDateToString(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected void assign(BytesColumnVector outV, int i, byte[] bytes, int length) {
        outV.setVal(i, bytes, 0, length);
    }

    @Override
    protected void func(BytesColumnVector outV, long[] vector, int i) {
        this.dt.setTime(DateWritableV2.daysToMillis((int)vector[i]));
        byte[] temp = this.formatter.format(this.dt).getBytes();
        this.assign(outV, i, temp, temp.length);
    }
}

