/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive.conversion;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.flink.table.functions.hive.conversion.HiveObjectConversion;
import org.apache.flink.table.functions.hive.conversion.IdentityConversion;
import org.apache.flink.table.functions.hive.conversion.WritableHiveObjectConversion;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.VoidObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

@Internal
public class HiveInspectors {
    public static ObjectInspector[] toInspectors(HiveShim hiveShim, Object[] args, DataType[] argTypes) {
        assert (args.length == argTypes.length);
        ObjectInspector[] argumentInspectors = new ObjectInspector[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            Object constant = args[i];
            if (constant == null) {
                argumentInspectors[i] = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(HiveTypeUtil.toHiveTypeInfo(argTypes[i], false));
                continue;
            }
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)HiveTypeUtil.toHiveTypeInfo(argTypes[i], false);
            constant = HiveInspectors.getConversion(HiveInspectors.getObjectInspector(primitiveTypeInfo), argTypes[i].getLogicalType(), hiveShim).toHiveObject(constant);
            argumentInspectors[i] = HiveInspectors.getObjectInspectorForPrimitiveConstant(primitiveTypeInfo, constant, hiveShim);
        }
        return argumentInspectors;
    }

    public static HiveObjectConversion getConversion(ObjectInspector inspector, LogicalType dataType, HiveShim hiveShim) {
        if (inspector instanceof PrimitiveObjectInspector) {
            HiveObjectConversion conversion;
            if (inspector instanceof BooleanObjectInspector || inspector instanceof StringObjectInspector || inspector instanceof ByteObjectInspector || inspector instanceof ShortObjectInspector || inspector instanceof IntObjectInspector || inspector instanceof LongObjectInspector || inspector instanceof FloatObjectInspector || inspector instanceof DoubleObjectInspector || inspector instanceof BinaryObjectInspector) {
                conversion = IdentityConversion.INSTANCE;
            } else if (inspector instanceof DateObjectInspector) {
                conversion = hiveShim::toHiveDate;
            } else if (inspector instanceof TimestampObjectInspector) {
                conversion = hiveShim::toHiveTimestamp;
            } else if (inspector instanceof HiveCharObjectInspector) {
                conversion = o -> o == null ? null : new HiveChar((String)o, ((CharType)dataType).getLength());
            } else if (inspector instanceof HiveVarcharObjectInspector) {
                conversion = o -> o == null ? null : new HiveVarchar((String)o, ((VarCharType)dataType).getLength());
            } else if (inspector instanceof HiveDecimalObjectInspector) {
                conversion = o -> o == null ? null : HiveDecimal.create((BigDecimal)o);
            } else {
                throw new FlinkHiveUDFException("Unsupported primitive object inspector " + inspector.getClass().getName());
            }
            if (((PrimitiveObjectInspector)inspector).preferWritable()) {
                conversion = new WritableHiveObjectConversion(conversion, hiveShim);
            }
            return conversion;
        }
        if (inspector instanceof ListObjectInspector) {
            HiveObjectConversion eleConvert = HiveInspectors.getConversion(((ListObjectInspector)inspector).getListElementObjectInspector(), ((ArrayType)dataType).getElementType(), hiveShim);
            return o -> {
                if (o == null) {
                    return null;
                }
                Object[] array = (Object[])o;
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object ele : array) {
                    result.add(eleConvert.toHiveObject(ele));
                }
                return result;
            };
        }
        if (inspector instanceof MapObjectInspector) {
            MapObjectInspector mapInspector = (MapObjectInspector)inspector;
            MapType kvType = (MapType)dataType;
            HiveObjectConversion keyConversion = HiveInspectors.getConversion(mapInspector.getMapKeyObjectInspector(), kvType.getKeyType(), hiveShim);
            HiveObjectConversion valueConversion = HiveInspectors.getConversion(mapInspector.getMapValueObjectInspector(), kvType.getValueType(), hiveShim);
            return o -> {
                if (o == null) {
                    return null;
                }
                Map map = (Map)o;
                HashMap<Object, Object> result = new HashMap<Object, Object>(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    result.put(keyConversion.toHiveObject(entry.getKey()), valueConversion.toHiveObject(entry.getValue()));
                }
                return result;
            };
        }
        if (inspector instanceof StructObjectInspector) {
            StructObjectInspector structInspector = (StructObjectInspector)inspector;
            List<? extends StructField> structFields = structInspector.getAllStructFieldRefs();
            List rowFields = ((RowType)dataType).getFields();
            HiveObjectConversion[] conversions = new HiveObjectConversion[structFields.size()];
            for (int i = 0; i < structFields.size(); ++i) {
                conversions[i] = HiveInspectors.getConversion(structFields.get(i).getFieldObjectInspector(), ((RowType.RowField)rowFields.get(i)).getType(), hiveShim);
            }
            return o -> {
                if (o == null) {
                    return null;
                }
                Row row = (Row)o;
                ArrayList<Object> result = new ArrayList<Object>(row.getArity());
                for (int i = 0; i < row.getArity(); ++i) {
                    result.add(conversions[i].toHiveObject(row.getField(i)));
                }
                return result;
            };
        }
        throw new FlinkHiveUDFException(String.format("Flink doesn't support convert object conversion for %s yet", inspector));
    }

    public static Object toFlinkObject(ObjectInspector inspector, Object data, HiveShim hiveShim) {
        if (data == null || inspector instanceof VoidObjectInspector) {
            return null;
        }
        if (inspector instanceof PrimitiveObjectInspector) {
            if (inspector instanceof BooleanObjectInspector || inspector instanceof StringObjectInspector || inspector instanceof ByteObjectInspector || inspector instanceof ShortObjectInspector || inspector instanceof IntObjectInspector || inspector instanceof LongObjectInspector || inspector instanceof FloatObjectInspector || inspector instanceof DoubleObjectInspector || inspector instanceof BinaryObjectInspector) {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
                return poi.getPrimitiveJavaObject(data);
            }
            if (inspector instanceof DateObjectInspector) {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
                return hiveShim.toFlinkDate(poi.getPrimitiveJavaObject(data));
            }
            if (inspector instanceof TimestampObjectInspector) {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
                return hiveShim.toFlinkTimestamp(poi.getPrimitiveJavaObject(data));
            }
            if (inspector instanceof HiveCharObjectInspector) {
                HiveCharObjectInspector oi = (HiveCharObjectInspector)inspector;
                return oi.getPrimitiveJavaObject(data).getValue();
            }
            if (inspector instanceof HiveVarcharObjectInspector) {
                HiveVarcharObjectInspector oi = (HiveVarcharObjectInspector)inspector;
                return oi.getPrimitiveJavaObject(data).getValue();
            }
            if (inspector instanceof HiveDecimalObjectInspector) {
                HiveDecimalObjectInspector oi = (HiveDecimalObjectInspector)inspector;
                return oi.getPrimitiveJavaObject(data).bigDecimalValue();
            }
        }
        if (inspector instanceof ListObjectInspector) {
            ListObjectInspector listInspector = (ListObjectInspector)inspector;
            List<?> list = listInspector.getList(data);
            ObjectInspector elementInspector = listInspector.getListElementObjectInspector();
            Object[] result = (Object[])Array.newInstance(HiveTypeUtil.toFlinkType(elementInspector).getConversionClass(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                result[i] = HiveInspectors.toFlinkObject(elementInspector, list.get(i), hiveShim);
            }
            return result;
        }
        if (inspector instanceof MapObjectInspector) {
            MapObjectInspector mapInspector = (MapObjectInspector)inspector;
            Map<?, ?> map = mapInspector.getMap(data);
            HashMap<Object, Object> result = new HashMap<Object, Object>(map.size());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                result.put(HiveInspectors.toFlinkObject(mapInspector.getMapKeyObjectInspector(), entry.getKey(), hiveShim), HiveInspectors.toFlinkObject(mapInspector.getMapValueObjectInspector(), entry.getValue(), hiveShim));
            }
            return result;
        }
        if (inspector instanceof StructObjectInspector) {
            StructObjectInspector structInspector = (StructObjectInspector)inspector;
            List<? extends StructField> fields = structInspector.getAllStructFieldRefs();
            Row row = new Row(fields.size());
            if (!data.getClass().isArray() && !(data instanceof List) && inspector instanceof StandardStructObjectInspector) {
                data = new Object[]{data};
            }
            for (int i = 0; i < row.getArity(); ++i) {
                row.setField(i, HiveInspectors.toFlinkObject(fields.get(i).getFieldObjectInspector(), structInspector.getStructFieldData(data, fields.get(i)), hiveShim));
            }
            return row;
        }
        throw new FlinkHiveUDFException(String.format("Unwrap does not support ObjectInspector '%s' yet", inspector));
    }

    public static ObjectInspector getObjectInspector(DataType flinkType) {
        return HiveInspectors.getObjectInspector(HiveTypeUtil.toHiveTypeInfo(flinkType, true));
    }

    private static ObjectInspector getObjectInspectorForPrimitiveConstant(PrimitiveTypeInfo primitiveTypeInfo, @Nonnull Object value, HiveShim hiveShim) {
        value = hiveShim.hivePrimitiveToWritable(value);
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                String className = WritableConstantBooleanObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case BYTE: {
                String className = WritableConstantByteObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case SHORT: {
                String className = WritableConstantShortObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case INT: {
                String className = WritableConstantIntObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case LONG: {
                String className = WritableConstantLongObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case FLOAT: {
                String className = WritableConstantFloatObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case DOUBLE: {
                String className = WritableConstantDoubleObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case STRING: {
                String className = WritableConstantStringObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case CHAR: {
                try {
                    Constructor constructor = WritableConstantHiveCharObjectInspector.class.getDeclaredConstructor(CharTypeInfo.class, value.getClass());
                    constructor.setAccessible(true);
                    return (ObjectInspector)constructor.newInstance(primitiveTypeInfo, value);
                }
                catch (Exception e) {
                    throw new FlinkHiveUDFException("Failed to create writable constant object inspector", e);
                }
            }
            case VARCHAR: {
                try {
                    Constructor constructor = WritableConstantHiveVarcharObjectInspector.class.getDeclaredConstructor(VarcharTypeInfo.class, value.getClass());
                    constructor.setAccessible(true);
                    return (ObjectInspector)constructor.newInstance(primitiveTypeInfo, value);
                }
                catch (Exception e) {
                    throw new FlinkHiveUDFException("Failed to create writable constant object inspector", e);
                }
            }
            case DATE: {
                String className = WritableConstantDateObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case TIMESTAMP: {
                String className = WritableConstantTimestampObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case DECIMAL: {
                try {
                    Constructor constructor = WritableConstantHiveDecimalObjectInspector.class.getDeclaredConstructor(DecimalTypeInfo.class, value.getClass());
                    constructor.setAccessible(true);
                    return (ObjectInspector)constructor.newInstance(primitiveTypeInfo, value);
                }
                catch (Exception e) {
                    throw new FlinkHiveUDFException("Failed to create writable constant object inspector", e);
                }
            }
            case BINARY: {
                String className = WritableConstantBinaryObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value);
            }
            case UNKNOWN: 
            case VOID: {
                String className = WritableConstantStringObjectInspector.class.getName();
                return HiveReflectionUtils.createConstantObjectInspector(className, value.toString());
            }
        }
        throw new FlinkHiveUDFException(String.format("Cannot find ConstantObjectInspector for %s", primitiveTypeInfo));
    }

    private static ObjectInspector getObjectInspector(TypeInfo type) {
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveType = (PrimitiveTypeInfo)type;
                return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(primitiveType);
            }
            case LIST: {
                ListTypeInfo listType = (ListTypeInfo)type;
                return ObjectInspectorFactory.getStandardListObjectInspector(HiveInspectors.getObjectInspector(listType.getListElementTypeInfo()));
            }
            case MAP: {
                MapTypeInfo mapType = (MapTypeInfo)type;
                return ObjectInspectorFactory.getStandardMapObjectInspector(HiveInspectors.getObjectInspector(mapType.getMapKeyTypeInfo()), HiveInspectors.getObjectInspector(mapType.getMapValueTypeInfo()));
            }
            case STRUCT: {
                StructTypeInfo structType = (StructTypeInfo)type;
                ArrayList<TypeInfo> fieldTypes = structType.getAllStructFieldTypeInfos();
                ArrayList<ObjectInspector> fieldInspectors = new ArrayList<ObjectInspector>();
                for (TypeInfo fieldType : fieldTypes) {
                    fieldInspectors.add(HiveInspectors.getObjectInspector(fieldType));
                }
                return ObjectInspectorFactory.getStandardStructObjectInspector(structType.getAllStructFieldNames(), fieldInspectors);
            }
        }
        throw new CatalogException("Unsupported Hive type category " + (Object)((Object)type.getCategory()));
    }
}

