/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.hive.shaded.parquet.glob.GlobExpander;
import org.apache.flink.hive.shaded.parquet.glob.WildcardPath;

public final class Strings {
    private Strings() {
    }

    public static String join(Iterable<String> s, String on) {
        return Strings.join(s.iterator(), on);
    }

    public static String join(Iterator<String> iter, String on) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(on);
        }
        return sb.toString();
    }

    public static String join(String[] s, String on) {
        return Strings.join(Arrays.asList(s), on);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static List<String> expandGlob(String globPattern) {
        return GlobExpander.expand(globPattern);
    }

    public static List<WildcardPath> expandGlobToWildCardPaths(String globPattern, char delim) {
        ArrayList<WildcardPath> ret = new ArrayList<WildcardPath>();
        for (String expandedGlob : Strings.expandGlob(globPattern)) {
            ret.add(new WildcardPath(globPattern, expandedGlob, delim));
        }
        return ret;
    }
}

