/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.connectors.hive.read.HiveTableInputSplit;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.source.TimestampedInputSplit;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.InstantiationUtil;

@TypeInfo(value=SplitTypeInfoFactory.class)
public class TimestampedHiveInputSplit
extends HiveTableInputSplit
implements TimestampedInputSplit {
    private static final long serialVersionUID = 1L;
    private final long modificationTime;
    private Serializable splitState;

    public TimestampedHiveInputSplit(long modificationTime, HiveTableInputSplit split) {
        super(split.getSplitNumber(), split.getHadoopInputSplit(), split.getJobConf(), split.getHiveTablePartition());
        this.modificationTime = modificationTime;
    }

    public void setSplitState(Serializable state) {
        this.splitState = state;
    }

    public Serializable getSplitState() {
        return this.splitState;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public int compareTo(TimestampedInputSplit o) {
        TimestampedHiveInputSplit split = (TimestampedHiveInputSplit)o;
        int modTimeComp = Long.compare(this.modificationTime, split.modificationTime);
        if ((long)modTimeComp != 0L) {
            return modTimeComp;
        }
        int sdComp = this.hiveTablePartition.getStorageDescriptor().compareTo(split.hiveTablePartition.getStorageDescriptor());
        return sdComp != 0 ? sdComp : this.getSplitNumber() - o.getSplitNumber();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimestampedHiveInputSplit that = (TimestampedHiveInputSplit)((Object)o);
        return this.modificationTime == that.modificationTime;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modificationTime);
    }

    @Override
    public String toString() {
        return "TimestampedHiveInputSplit{modificationTime=" + this.modificationTime + ", splitState=" + this.splitState + ", hiveTablePartition=" + this.hiveTablePartition + '}';
    }

    private static class SplitTypeSerializer
    extends TypeSerializerSingleton<TimestampedHiveInputSplit> {
        private static final SplitTypeSerializer INSTANCE = new SplitTypeSerializer();
        private static final long serialVersionUID = 1L;

        private SplitTypeSerializer() {
        }

        public boolean isImmutableType() {
            return false;
        }

        public TimestampedHiveInputSplit createInstance() {
            return null;
        }

        public TimestampedHiveInputSplit copy(TimestampedHiveInputSplit from) {
            try {
                return (TimestampedHiveInputSplit)((Object)InstantiationUtil.clone((Serializable)((Object)from), (ClassLoader)Thread.currentThread().getContextClassLoader()));
            }
            catch (IOException | ClassNotFoundException e) {
                throw new FlinkRuntimeException("Could not copy element via serialization: " + (Object)((Object)from), (Throwable)e);
            }
        }

        public TimestampedHiveInputSplit copy(TimestampedHiveInputSplit from, TimestampedHiveInputSplit reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(TimestampedHiveInputSplit record, DataOutputView target) throws IOException {
            try (DataOutputViewStream outViewWrapper = new DataOutputViewStream(target);){
                InstantiationUtil.serializeObject((OutputStream)outViewWrapper, (Object)((Object)record));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TimestampedHiveInputSplit deserialize(DataInputView source) throws IOException {
            try (DataInputViewStream inViewWrapper = new DataInputViewStream(source);){
                TimestampedHiveInputSplit timestampedHiveInputSplit = (TimestampedHiveInputSplit)((Object)InstantiationUtil.deserializeObject((InputStream)inViewWrapper, (ClassLoader)Thread.currentThread().getContextClassLoader()));
                return timestampedHiveInputSplit;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Could not deserialize object.", e);
            }
        }

        public TimestampedHiveInputSplit deserialize(TimestampedHiveInputSplit reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            TimestampedHiveInputSplit tmp = this.deserialize(source);
            this.serialize(tmp, target);
        }

        public TypeSerializerSnapshot<TimestampedHiveInputSplit> snapshotConfiguration() {
            return new SplitSerializerSnapshot();
        }

        public static final class SplitSerializerSnapshot
        extends SimpleTypeSerializerSnapshot<TimestampedHiveInputSplit> {
            public SplitSerializerSnapshot() {
                super(() -> new SplitTypeSerializer());
            }
        }
    }

    public static class SplitTypeInfoFactory
    extends TypeInfoFactory<TimestampedHiveInputSplit>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public TypeInformation<TimestampedHiveInputSplit> createTypeInfo(Type t, Map genericParameters) {
            return new BasicTypeInfo<TimestampedHiveInputSplit>(TimestampedHiveInputSplit.class, new Class[0], (TypeSerializer)SplitTypeSerializer.INSTANCE, null){};
        }
    }
}

