/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.schema;

import org.apache.hive.shaded.parquet.schema.GroupType;
import org.apache.hive.shaded.parquet.schema.InvalidSchemaException;
import org.apache.hive.shaded.parquet.schema.MessageType;
import org.apache.hive.shaded.parquet.schema.PrimitiveType;
import org.apache.hive.shaded.parquet.schema.Type;
import org.apache.hive.shaded.parquet.schema.TypeVisitor;

public class TypeUtil {
    public static void checkValidWriteSchema(GroupType schema) {
        schema.accept(new TypeVisitor(){

            @Override
            public void visit(GroupType groupType) {
                if (groupType.getFieldCount() <= 0) {
                    throw new InvalidSchemaException("Cannot write a schema with an empty group: " + groupType);
                }
                for (Type type : groupType.getFields()) {
                    type.accept(this);
                }
            }

            @Override
            public void visit(MessageType messageType) {
                this.visit((GroupType)messageType);
            }

            @Override
            public void visit(PrimitiveType primitiveType) {
            }
        });
    }
}

