/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.hadoop.example;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hive.shaded.parquet.column.ParquetProperties;
import org.apache.hive.shaded.parquet.example.data.Group;
import org.apache.hive.shaded.parquet.hadoop.ParquetWriter;
import org.apache.hive.shaded.parquet.hadoop.api.WriteSupport;
import org.apache.hive.shaded.parquet.hadoop.example.GroupWriteSupport;
import org.apache.hive.shaded.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.hive.shaded.parquet.schema.MessageType;

public class ExampleParquetWriter
extends ParquetWriter<Group> {
    public static Builder builder(Path file) {
        return new Builder(file);
    }

    ExampleParquetWriter(Path file, WriteSupport<Group> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, boolean enableDictionary, boolean enableValidation, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        super(file, writeSupport, compressionCodecName, blockSize, pageSize, pageSize, enableDictionary, enableValidation, writerVersion, conf);
    }

    public static class Builder
    extends ParquetWriter.Builder<Group, Builder> {
        private MessageType type = null;
        private Map<String, String> extraMetaData = new HashMap<String, String>();

        private Builder(Path file) {
            super(file);
        }

        public Builder withType(MessageType type) {
            this.type = type;
            return this;
        }

        public Builder withExtraMetaData(Map<String, String> extraMetaData) {
            this.extraMetaData = extraMetaData;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected WriteSupport<Group> getWriteSupport(Configuration conf) {
            return new GroupWriteSupport(this.type, this.extraMetaData);
        }
    }
}

