/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.format;

import org.apache.hive.shaded.parquet.format.BsonType;
import org.apache.hive.shaded.parquet.format.DateType;
import org.apache.hive.shaded.parquet.format.DecimalType;
import org.apache.hive.shaded.parquet.format.EnumType;
import org.apache.hive.shaded.parquet.format.IntType;
import org.apache.hive.shaded.parquet.format.JsonType;
import org.apache.hive.shaded.parquet.format.ListType;
import org.apache.hive.shaded.parquet.format.LogicalType;
import org.apache.hive.shaded.parquet.format.MapType;
import org.apache.hive.shaded.parquet.format.MicroSeconds;
import org.apache.hive.shaded.parquet.format.MilliSeconds;
import org.apache.hive.shaded.parquet.format.NullType;
import org.apache.hive.shaded.parquet.format.StringType;
import org.apache.hive.shaded.parquet.format.TimeType;
import org.apache.hive.shaded.parquet.format.TimeUnit;
import org.apache.hive.shaded.parquet.format.TimestampType;

public class LogicalTypes {
    public static final LogicalType UTF8 = LogicalType.STRING(new StringType());
    public static final LogicalType MAP = LogicalType.MAP(new MapType());
    public static final LogicalType LIST = LogicalType.LIST(new ListType());
    public static final LogicalType ENUM = LogicalType.ENUM(new EnumType());
    public static final LogicalType DATE = LogicalType.DATE(new DateType());
    public static final LogicalType TIME_MILLIS = LogicalType.TIME(new TimeType(true, TimeUnits.MILLIS));
    public static final LogicalType TIME_MICROS = LogicalType.TIME(new TimeType(true, TimeUnits.MICROS));
    public static final LogicalType TIMESTAMP_MILLIS = LogicalType.TIMESTAMP(new TimestampType(true, TimeUnits.MILLIS));
    public static final LogicalType TIMESTAMP_MICROS = LogicalType.TIMESTAMP(new TimestampType(true, TimeUnits.MICROS));
    public static final LogicalType INT_8 = LogicalType.INTEGER(new IntType(8, true));
    public static final LogicalType INT_16 = LogicalType.INTEGER(new IntType(16, true));
    public static final LogicalType INT_32 = LogicalType.INTEGER(new IntType(32, true));
    public static final LogicalType INT_64 = LogicalType.INTEGER(new IntType(64, true));
    public static final LogicalType UINT_8 = LogicalType.INTEGER(new IntType(8, false));
    public static final LogicalType UINT_16 = LogicalType.INTEGER(new IntType(16, false));
    public static final LogicalType UINT_32 = LogicalType.INTEGER(new IntType(32, false));
    public static final LogicalType UINT_64 = LogicalType.INTEGER(new IntType(64, false));
    public static final LogicalType UNKNOWN = LogicalType.UNKNOWN(new NullType());
    public static final LogicalType JSON = LogicalType.JSON(new JsonType());
    public static final LogicalType BSON = LogicalType.BSON(new BsonType());

    public static LogicalType DECIMAL(int scale, int precision) {
        return LogicalType.DECIMAL(new DecimalType(scale, precision));
    }

    public static class TimeUnits {
        public static final TimeUnit MILLIS = TimeUnit.MILLIS(new MilliSeconds());
        public static final TimeUnit MICROS = TimeUnit.MICROS(new MicroSeconds());
    }
}

