/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.bytes;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.shaded.parquet.bytes.MultiBufferInputStream;
import org.apache.hive.shaded.parquet.bytes.SingleBufferInputStream;

public abstract class ByteBufferInputStream
extends InputStream {
    public static ByteBufferInputStream wrap(ByteBuffer ... buffers) {
        if (buffers.length == 1) {
            return new SingleBufferInputStream(buffers[0]);
        }
        return new MultiBufferInputStream(Arrays.asList(buffers));
    }

    public static ByteBufferInputStream wrap(List<ByteBuffer> buffers) {
        if (buffers.size() == 1) {
            return new SingleBufferInputStream(buffers.get(0));
        }
        return new MultiBufferInputStream(buffers);
    }

    public abstract long position();

    public void skipFully(long n) throws IOException {
        long skipped = this.skip(n);
        if (skipped < n) {
            throw new EOFException("Not enough bytes to skip: " + skipped + " < " + n);
        }
    }

    public abstract int read(ByteBuffer var1);

    public abstract ByteBuffer slice(int var1) throws EOFException;

    public abstract List<ByteBuffer> sliceBuffers(long var1) throws EOFException;

    public ByteBufferInputStream sliceStream(long length) throws EOFException {
        return ByteBufferInputStream.wrap(this.sliceBuffers(length));
    }

    public abstract List<ByteBuffer> remainingBuffers();

    public ByteBufferInputStream remainingStream() {
        return ByteBufferInputStream.wrap(this.remainingBuffers());
    }
}

