/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.FunctionSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;

class CreateFunctionHandler
extends AbstractEventHandler {
    CreateFunctionHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        CreateFunctionMessage createFunctionMessage = this.deserializer.getCreateFunctionMessage(this.event.getMessage());
        LOG.info("Processing#{} CREATE_MESSAGE message : {}", (Object)this.fromEventId(), (Object)this.event.getMessage());
        Path metadataPath = new Path(withinContext.eventRoot, "_metadata");
        FileSystem fileSystem = metadataPath.getFileSystem((Configuration)withinContext.hiveConf);
        try (JsonWriter jsonWriter = new JsonWriter(fileSystem, metadataPath);){
            new FunctionSerializer(createFunctionMessage.getFunctionObj(), withinContext.hiveConf).writeTo(jsonWriter, withinContext.replicationSpec);
        }
        withinContext.createDmd(this).write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_CREATE_FUNCTION;
    }
}

