/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import org.antlr.runtime.CommonToken;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class WindowingSpec {
    private HashMap<String, WindowExpressionSpec> aliasToWdwExpr = new HashMap();
    private HashMap<String, WindowSpec> windowSpecs = new HashMap();
    private ArrayList<WindowExpressionSpec> windowExpressions = new ArrayList();

    public void addWindowSpec(String name, WindowSpec wdwSpec) {
        this.windowSpecs.put(name, wdwSpec);
    }

    public void addWindowFunction(WindowFunctionSpec wFn) {
        this.windowExpressions.add(wFn);
        this.aliasToWdwExpr.put(wFn.getAlias(), wFn);
    }

    public HashMap<String, WindowExpressionSpec> getAliasToWdwExpr() {
        return this.aliasToWdwExpr;
    }

    public HashMap<String, WindowSpec> getWindowSpecs() {
        return this.windowSpecs;
    }

    public ArrayList<WindowExpressionSpec> getWindowExpressions() {
        return this.windowExpressions;
    }

    public PTFInvocationSpec.PartitioningSpec getQueryPartitioningSpec() {
        WindowFunctionSpec wFn = (WindowFunctionSpec)this.getWindowExpressions().get(0);
        return wFn.getWindowSpec().getPartitioning();
    }

    public PTFInvocationSpec.PartitionSpec getQueryPartitionSpec() {
        return this.getQueryPartitioningSpec().getPartSpec();
    }

    public PTFInvocationSpec.OrderSpec getQueryOrderSpec() {
        return this.getQueryPartitioningSpec().getOrderSpec();
    }

    public void validateAndMakeEffective() throws SemanticException {
        for (WindowExpressionSpec expr : this.getWindowExpressions()) {
            WindowFunctionSpec wFn = (WindowFunctionSpec)expr;
            WindowSpec wdwSpec = wFn.getWindowSpec();
            if (wdwSpec != null) {
                ArrayList<String> sources = new ArrayList<String>();
                this.fillInWindowSpec(wdwSpec.getSourceId(), wdwSpec, sources);
            }
            if (wdwSpec == null) {
                wdwSpec = new WindowSpec();
                wFn.setWindowSpec(wdwSpec);
            }
            this.applyConstantPartition(wdwSpec);
            this.effectiveWindowFrame(wFn);
            this.validateWindowFrame(wdwSpec);
            this.setAndValidateOrderSpec(wFn);
        }
    }

    private void fillInWindowSpec(String sourceId, WindowSpec dest, ArrayList<String> visited) throws SemanticException {
        if (sourceId != null) {
            if (visited.contains(sourceId)) {
                visited.add(sourceId);
                throw new SemanticException(String.format("Cycle in Window references %s", visited));
            }
            WindowSpec source = this.getWindowSpecs().get(sourceId);
            if (source == null || source.equals(dest)) {
                throw new SemanticException(String.format("%s refers to an unknown source", dest));
            }
            if (dest.getPartition() == null) {
                dest.setPartition(source.getPartition());
            }
            if (dest.getOrder() == null) {
                dest.setOrder(source.getOrder());
            }
            if (dest.getWindowFrame() == null) {
                dest.setWindowFrame(source.getWindowFrame());
            }
            visited.add(sourceId);
            this.fillInWindowSpec(source.getSourceId(), dest, visited);
        }
    }

    private void applyConstantPartition(WindowSpec wdwSpec) {
        PTFInvocationSpec.PartitionSpec partSpec = wdwSpec.getPartition();
        if (partSpec == null) {
            partSpec = new PTFInvocationSpec.PartitionSpec();
            PTFInvocationSpec.PartitionExpression partExpr = new PTFInvocationSpec.PartitionExpression();
            partExpr.setExpression(new ASTNode(new CommonToken(367, "0")));
            partSpec.addExpression(partExpr);
            wdwSpec.setPartition(partSpec);
        }
    }

    private void effectiveWindowFrame(WindowFunctionSpec wFn) throws SemanticException {
        WindowSpec wdwSpec = wFn.getWindowSpec();
        WindowFunctionInfo wFnInfo = FunctionRegistry.getWindowFunctionInfo(wFn.getName());
        boolean supportsWindowing = wFnInfo == null ? true : wFnInfo.isSupportsWindow();
        WindowFrameSpec wFrame = wdwSpec.getWindowFrame();
        PTFInvocationSpec.OrderSpec orderSpec = wdwSpec.getOrder();
        if (wFrame == null) {
            wFrame = !supportsWindowing ? (wFn.getName().toLowerCase().equals("last_value") && orderSpec != null ? new WindowFrameSpec(WindowType.ROWS, new BoundarySpec(Direction.CURRENT), new BoundarySpec(Direction.FOLLOWING, 0)) : new WindowFrameSpec(WindowType.ROWS, new BoundarySpec(Direction.PRECEDING, Integer.MAX_VALUE), new BoundarySpec(Direction.FOLLOWING, Integer.MAX_VALUE))) : (orderSpec == null ? new WindowFrameSpec(WindowType.ROWS, new BoundarySpec(Direction.PRECEDING, Integer.MAX_VALUE), new BoundarySpec(Direction.FOLLOWING, Integer.MAX_VALUE)) : new WindowFrameSpec(WindowType.RANGE, new BoundarySpec(Direction.PRECEDING, Integer.MAX_VALUE), new BoundarySpec(Direction.CURRENT)));
            wdwSpec.setWindowFrame(wFrame);
        } else if (wFrame.getEnd() == null) {
            wFrame.setEnd(new BoundarySpec(Direction.CURRENT));
        }
    }

    private void validateWindowFrame(WindowSpec wdwSpec) throws SemanticException {
        WindowFrameSpec wFrame = wdwSpec.getWindowFrame();
        BoundarySpec start = wFrame.getStart();
        BoundarySpec end = wFrame.getEnd();
        if (start.getDirection() == Direction.FOLLOWING && start.getAmt() == Integer.MAX_VALUE) {
            throw new SemanticException("Start of a WindowFrame cannot be UNBOUNDED FOLLOWING");
        }
        if (end.getDirection() == Direction.PRECEDING && end.getAmt() == Integer.MAX_VALUE) {
            throw new SemanticException("End of a WindowFrame cannot be UNBOUNDED PRECEDING");
        }
    }

    private void setAndValidateOrderSpec(WindowFunctionSpec wFn) throws SemanticException {
        WindowSpec wdwSpec = wFn.getWindowSpec();
        wdwSpec.ensureOrderSpec(wFn);
        WindowFrameSpec wFrame = wdwSpec.getWindowFrame();
        PTFInvocationSpec.OrderSpec order = wdwSpec.getOrder();
        BoundarySpec start = wFrame.getStart();
        BoundarySpec end = wFrame.getEnd();
        if (wFrame.getWindowType() == WindowType.RANGE) {
            boolean multiOrderAllowed;
            if (order == null || order.getExpressions().size() == 0) {
                throw new SemanticException("Range based Window Frame needs to specify ORDER BY clause");
            }
            boolean currentRange = start.getDirection() == Direction.CURRENT && end.getDirection() == Direction.CURRENT;
            boolean defaultPreceding = start.getDirection() == Direction.PRECEDING && start.getAmt() == Integer.MAX_VALUE && end.getDirection() == Direction.CURRENT;
            boolean defaultFollowing = start.getDirection() == Direction.CURRENT && end.getDirection() == Direction.FOLLOWING && end.getAmt() == Integer.MAX_VALUE;
            boolean defaultPrecedingFollowing = start.getDirection() == Direction.PRECEDING && start.getAmt() == Integer.MAX_VALUE && end.getDirection() == Direction.FOLLOWING && end.getAmt() == Integer.MAX_VALUE;
            boolean bl = multiOrderAllowed = currentRange || defaultPreceding || defaultFollowing || defaultPrecedingFollowing;
            if (order.getExpressions().size() != 1 && !multiOrderAllowed) {
                throw new SemanticException("Range value based Window Frame can have only 1 Sort Key");
            }
        }
    }

    public static class BoundarySpec
    implements Comparable<BoundarySpec> {
        public static final int UNBOUNDED_AMOUNT = Integer.MAX_VALUE;
        Direction direction;
        int amt;

        public BoundarySpec() {
        }

        public BoundarySpec(Direction direction) {
            this(direction, 0);
        }

        public BoundarySpec(Direction direction, int amt) {
            this.direction = direction;
            this.amt = amt;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public int getAmt() {
            return this.amt;
        }

        public void setAmt(int amt) {
            this.amt = amt;
        }

        public String toString() {
            if (this.direction == Direction.CURRENT) {
                return "currentRow";
            }
            return String.format("%s %s", new Object[]{this.amt == Integer.MAX_VALUE ? "Unbounded" : Integer.valueOf(this.amt), this.direction});
        }

        @Override
        public int compareTo(BoundarySpec other) {
            int c = this.direction.compareTo(other.getDirection());
            if (c != 0) {
                return c;
            }
            return this.direction == Direction.PRECEDING ? other.amt - this.amt : this.amt - other.amt;
        }
    }

    public static enum WindowType {
        ROWS,
        RANGE;

    }

    public static enum Direction {
        PRECEDING,
        CURRENT,
        FOLLOWING;

    }

    public static class WindowFrameSpec {
        private WindowType windowType;
        private BoundarySpec start;
        private BoundarySpec end;

        public WindowFrameSpec(WindowType windowType, BoundarySpec start, BoundarySpec end) {
            this.windowType = windowType;
            this.start = start;
            this.end = end;
        }

        public WindowFrameSpec(WindowType windowType, BoundarySpec start) {
            this(windowType, start, null);
        }

        public BoundarySpec getStart() {
            return this.start;
        }

        public void setStart(BoundarySpec start) {
            this.start = start;
        }

        public BoundarySpec getEnd() {
            return this.end;
        }

        public void setEnd(BoundarySpec end) {
            this.end = end;
        }

        public WindowType getWindowType() {
            return this.windowType;
        }

        public String toString() {
            return String.format("window(type=%s, start=%s, end=%s)", new Object[]{this.windowType, this.start, this.end});
        }
    }

    public static class WindowSpec {
        private String sourceId;
        private PTFInvocationSpec.PartitioningSpec partitioning;
        private WindowFrameSpec windowFrame;

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public PTFInvocationSpec.PartitioningSpec getPartitioning() {
            return this.partitioning;
        }

        public void setPartitioning(PTFInvocationSpec.PartitioningSpec partitioning) {
            this.partitioning = partitioning;
        }

        public WindowFrameSpec getWindowFrame() {
            return this.windowFrame;
        }

        public void setWindowFrame(WindowFrameSpec windowFrame) {
            this.windowFrame = windowFrame;
        }

        public PTFInvocationSpec.PartitionSpec getPartition() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getPartSpec();
        }

        public void setPartition(PTFInvocationSpec.PartitionSpec partSpec) {
            this.partitioning = this.partitioning == null ? new PTFInvocationSpec.PartitioningSpec() : this.partitioning;
            this.partitioning.setPartSpec(partSpec);
        }

        public PTFInvocationSpec.OrderSpec getOrder() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getOrderSpec();
        }

        public void setOrder(PTFInvocationSpec.OrderSpec orderSpec) {
            this.partitioning = this.partitioning == null ? new PTFInvocationSpec.PartitioningSpec() : this.partitioning;
            this.partitioning.setOrderSpec(orderSpec);
        }

        protected void ensureOrderSpec(WindowFunctionSpec wFn) throws SemanticException {
            if (this.getOrder() == null) {
                PTFInvocationSpec.OrderSpec order = new PTFInvocationSpec.OrderSpec();
                order.prefixBy(this.getPartition());
                this.setOrder(order);
            }
        }

        public String toString() {
            return String.format("Window Spec=[%s%s%s]", this.sourceId == null ? "" : "Name='" + this.sourceId + "'", this.partitioning == null ? "" : this.partitioning, this.windowFrame == null ? "" : this.windowFrame);
        }
    }

    public static class WindowFunctionSpec
    extends WindowExpressionSpec {
        String name;
        boolean isStar;
        boolean isDistinct;
        ArrayList<ASTNode> args;
        WindowSpec windowSpec;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isStar() {
            return this.isStar;
        }

        public void setStar(boolean isStar) {
            this.isStar = isStar;
        }

        public boolean isDistinct() {
            return this.isDistinct;
        }

        public void setDistinct(boolean isDistinct) {
            this.isDistinct = isDistinct;
        }

        public ArrayList<ASTNode> getArgs() {
            this.args = this.args == null ? new ArrayList<ASTNode>() : this.args;
            return this.args;
        }

        public void setArgs(ArrayList<ASTNode> args) {
            this.args = args;
        }

        public void addArg(ASTNode arg) {
            this.args = this.args == null ? new ArrayList<ASTNode>() : this.args;
            this.args.add(arg);
        }

        public WindowSpec getWindowSpec() {
            return this.windowSpec;
        }

        public void setWindowSpec(WindowSpec windowSpec) {
            this.windowSpec = windowSpec;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.name).append("(");
            if (this.isStar) {
                buf.append("*");
            } else {
                if (this.isDistinct) {
                    buf.append("distinct ");
                }
                if (this.args != null) {
                    boolean first = true;
                    for (ASTNode arg : this.args) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append(", ");
                        }
                        buf.append(arg.toStringTree());
                    }
                }
            }
            buf.append(")");
            if (this.windowSpec != null) {
                buf.append(" ").append(this.windowSpec.toString());
            }
            if (this.alias != null) {
                buf.append(" as ").append(this.alias);
            }
            return buf.toString();
        }
    }

    public static class WindowExpressionSpec {
        String alias;
        ASTNode expression;

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public ASTNode getExpression() {
            return this.expression;
        }

        public void setExpression(ASTNode expression) {
            this.expression = expression;
        }
    }
}

