/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.FieldNode;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ColumnPrunerProcCtx
implements NodeProcessorCtx {
    private final ParseContext pctx;
    private final Map<Operator<? extends OperatorDesc>, List<FieldNode>> prunedColLists;
    private final Map<CommonJoinOperator, Map<Byte, List<FieldNode>>> joinPrunedColLists;

    public ColumnPrunerProcCtx(ParseContext pctx) {
        this.pctx = pctx;
        this.prunedColLists = new HashMap<Operator<? extends OperatorDesc>, List<FieldNode>>();
        this.joinPrunedColLists = new HashMap<CommonJoinOperator, Map<Byte, List<FieldNode>>>();
    }

    public ParseContext getParseContext() {
        return this.pctx;
    }

    public Map<CommonJoinOperator, Map<Byte, List<FieldNode>>> getJoinPrunedColLists() {
        return this.joinPrunedColLists;
    }

    public List<FieldNode> getPrunedColList(Operator<? extends OperatorDesc> op) {
        return this.prunedColLists.get(op);
    }

    public Map<Operator<? extends OperatorDesc>, List<FieldNode>> getPrunedColLists() {
        return this.prunedColLists;
    }

    public List<FieldNode> genColLists(Operator<? extends OperatorDesc> curOp) throws SemanticException {
        if (curOp.getChildOperators() == null) {
            return null;
        }
        List<FieldNode> colList = null;
        for (Operator<OperatorDesc> child : curOp.getChildOperators()) {
            List<Object> prunList = null;
            if (child instanceof CommonJoinOperator) {
                int tag = child.getParentOperators().indexOf(curOp);
                prunList = this.joinPrunedColLists.get(child).get((byte)tag);
            } else if (child instanceof FileSinkOperator) {
                prunList = new ArrayList();
                RowSchema oldRS = curOp.getSchema();
                for (ColumnInfo colInfo : oldRS.getSignature()) {
                    prunList.add(new FieldNode(colInfo.getInternalName()));
                }
            } else {
                prunList = this.prunedColLists.get(child);
            }
            if (prunList == null) continue;
            if (colList == null) {
                colList = new ArrayList<FieldNode>(prunList);
                continue;
            }
            colList = FieldNode.mergeFieldNodes(colList, prunList);
        }
        return colList;
    }

    public List<FieldNode> genColLists(Operator<? extends OperatorDesc> curOp, Operator<? extends OperatorDesc> child) throws SemanticException {
        if (curOp.getChildOperators() == null) {
            return null;
        }
        if (child instanceof CommonJoinOperator) {
            int tag = child.getParentOperators().indexOf(curOp);
            return this.joinPrunedColLists.get(child).get((byte)tag);
        }
        return this.prunedColLists.get(child);
    }

    public List<FieldNode> getColsFromSelectExpr(SelectOperator op) {
        List<FieldNode> cols = new ArrayList<FieldNode>();
        SelectDesc conf = (SelectDesc)op.getConf();
        if (conf.isSelStarNoCompute()) {
            for (ColumnInfo colInfo : op.getSchema().getSignature()) {
                cols.add(new FieldNode(colInfo.getInternalName()));
            }
        } else {
            List<ExprNodeDesc> exprList = conf.getColList();
            for (ExprNodeDesc expr : exprList) {
                cols = ColumnPrunerProcCtx.mergeFieldNodesWithDesc(cols, expr);
            }
        }
        return cols;
    }

    public List<FieldNode> getSelectColsFromChildren(SelectOperator op, List<FieldNode> colList) {
        List<FieldNode> cols = new ArrayList<FieldNode>();
        SelectDesc conf = (SelectDesc)op.getConf();
        if (colList != null && conf.isSelStarNoCompute()) {
            cols.addAll(colList);
            return cols;
        }
        List<ExprNodeDesc> selectExprs = conf.getColList();
        List<String> outputColumnNames = conf.getOutputColumnNames();
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            if (colList == null) {
                cols = ColumnPrunerProcCtx.mergeFieldNodesWithDesc(cols, selectExprs.get(i));
                continue;
            }
            FieldNode childFn = ColumnPrunerProcCtx.lookupColumn(colList, outputColumnNames.get(i));
            if (childFn == null) continue;
            ExprNodeDesc desc = selectExprs.get(i);
            if (desc instanceof ExprNodeColumnDesc && ((ExprNodeColumnDesc)desc).getIsGenerated()) {
                FieldNode fn = new FieldNode(((ExprNodeColumnDesc)desc).getColumn());
                fn.setNodes(childFn.getNodes());
                cols = FieldNode.mergeFieldNodes(cols, fn);
                continue;
            }
            cols = ColumnPrunerProcCtx.mergeFieldNodesWithDesc(cols, selectExprs.get(i));
        }
        return cols;
    }

    private static List<FieldNode> getNestedColPathByDesc(ExprNodeDesc desc) {
        ArrayList<FieldNode> res = new ArrayList<FieldNode>();
        ColumnPrunerProcCtx.getNestedColsFromExprNodeDesc(desc, null, res);
        return FieldNode.mergeFieldNodes(new ArrayList<FieldNode>(), res);
    }

    private static void getNestedColsFromExprNodeDesc(ExprNodeDesc desc, FieldNode pathToRoot, List<FieldNode> paths) {
        if (desc instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc columnDesc = (ExprNodeColumnDesc)desc;
            FieldNode p = new FieldNode(columnDesc.getColumn());
            ColumnPrunerProcCtx.checkListAndMap(columnDesc, pathToRoot, p);
            paths.add(p);
        } else if (desc instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc fieldDesc = (ExprNodeFieldDesc)desc;
            ExprNodeDesc childDesc = fieldDesc.getDesc();
            FieldNode p = new FieldNode(fieldDesc.getFieldName());
            ColumnPrunerProcCtx.checkListAndMap(fieldDesc, pathToRoot, p);
            ColumnPrunerProcCtx.getNestedColsFromExprNodeDesc(childDesc, p, paths);
        } else {
            List<ExprNodeDesc> children = desc.getChildren();
            if (children != null) {
                for (ExprNodeDesc c : children) {
                    ColumnPrunerProcCtx.getNestedColsFromExprNodeDesc(c, pathToRoot, paths);
                }
            }
        }
    }

    private static void checkListAndMap(ExprNodeDesc desc, FieldNode pathToRoot, FieldNode fn) {
        TypeInfo ti = desc.getTypeInfo();
        if (ti.getCategory() != ObjectInspector.Category.LIST && ti.getCategory() != ObjectInspector.Category.MAP) {
            fn.addFieldNodes(pathToRoot);
        }
    }

    public List<FieldNode> getSelectColsFromLVJoin(RowSchema rs, List<FieldNode> colList) throws SemanticException {
        ArrayList<FieldNode> columns = new ArrayList<FieldNode>();
        for (FieldNode col : colList) {
            if (rs.getColumnInfo(col.getFieldName()) == null) continue;
            columns.add(col);
        }
        return columns;
    }

    public void handleFilterUnionChildren(Operator<? extends OperatorDesc> curOp) throws SemanticException {
        if (curOp.getChildOperators() == null || !(curOp instanceof FilterOperator)) {
            return;
        }
        List<FieldNode> parentPrunList = this.prunedColLists.get(curOp);
        if (parentPrunList == null || parentPrunList.size() == 0) {
            return;
        }
        List<FieldNode> prunList = null;
        for (Operator<OperatorDesc> child : curOp.getChildOperators()) {
            if (!(child instanceof UnionOperator) || (prunList = this.genColLists(child)) == null || prunList.size() == 0 || parentPrunList.size() == prunList.size()) continue;
            ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
            ArrayList<String> outputColNames = new ArrayList<String>();
            HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
            ArrayList<ColumnInfo> outputRS = new ArrayList<ColumnInfo>();
            for (ColumnInfo colInfo : child.getSchema().getSignature()) {
                if (ColumnPrunerProcCtx.lookupColumn(prunList, colInfo.getInternalName()) == null) continue;
                ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
                exprs.add(colDesc);
                outputColNames.add(colInfo.getInternalName());
                ColumnInfo newCol = new ColumnInfo(colInfo.getInternalName(), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
                newCol.setAlias(colInfo.getAlias());
                outputRS.add(newCol);
                colExprMap.put(colInfo.getInternalName(), colDesc);
            }
            SelectDesc select = new SelectDesc(exprs, outputColNames, false);
            curOp.removeChild(child);
            SelectOperator sel = (SelectOperator)OperatorFactory.getAndMakeChild(select, new RowSchema(outputRS), curOp, new Operator[0]);
            OperatorFactory.makeChild(sel, child);
            sel.setColumnExprMap(colExprMap);
        }
    }

    static ArrayList<String> toColumnNames(List<FieldNode> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (FieldNode fn : columns) {
            names.add(fn.getFieldName());
        }
        return names;
    }

    static List<FieldNode> fromColumnNames(List<String> columnNames) {
        ArrayList<FieldNode> fieldNodes = new ArrayList<FieldNode>();
        for (String cn : columnNames) {
            fieldNodes.add(new FieldNode(cn));
        }
        return fieldNodes;
    }

    static FieldNode lookupColumn(Collection<FieldNode> columns, String colName) {
        for (FieldNode fn : columns) {
            if (fn.getFieldName() == null || !fn.getFieldName().equals(colName)) continue;
            return fn;
        }
        return null;
    }

    static List<FieldNode> mergeFieldNodesWithDesc(List<FieldNode> left, ExprNodeDesc desc) {
        return FieldNode.mergeFieldNodes(left, ColumnPrunerProcCtx.getNestedColPathByDesc(desc));
    }
}

