/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.io.parquet.vector.BaseVectorizedColumnReader;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.hive.shaded.parquet.column.page.PageReader;
import org.apache.hive.shaded.parquet.schema.Type;

public class VectorizedListColumnReader
extends BaseVectorizedColumnReader {
    private Object lastValue;
    private boolean eof = false;
    boolean isFirstRow = true;

    public VectorizedListColumnReader(ColumnDescriptor descriptor, PageReader pageReader, boolean skipTimestampConversion, ZoneId writerTimezone, Type type, TypeInfo hiveType) throws IOException {
        super(descriptor, pageReader, skipTimestampConversion, writerTimezone, type, hiveType);
    }

    @Override
    public void readBatch(int total, ColumnVector column, TypeInfo columnType) throws IOException {
        int index;
        ListColumnVector lcv = (ListColumnVector)column;
        lcv.offsets = new long[1024];
        lcv.lengths = new long[1024];
        List<Object> valueList = new ArrayList<Object>();
        PrimitiveObjectInspector.PrimitiveCategory category = ((PrimitiveTypeInfo)((ListTypeInfo)columnType).getListElementTypeInfo()).getPrimitiveCategory();
        if (this.isFirstRow) {
            if (!this.fetchNextValue(category)) {
                return;
            }
            this.isFirstRow = false;
        }
        for (index = 0; !this.eof && index < total; ++index) {
            this.addElement(lcv, valueList, category, index);
        }
        if (this.isCurrentPageDictionaryEncoded) {
            valueList = this.decodeDictionaryIds(category, valueList);
        }
        this.convertValueListToListColumnVector(category, lcv, valueList, index);
    }

    private int readPageIfNeed() throws IOException {
        int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
        if (leftInPage == 0) {
            this.readPage();
            leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
        }
        return leftInPage;
    }

    private boolean fetchNextValue(PrimitiveObjectInspector.PrimitiveCategory category) throws IOException {
        int left = this.readPageIfNeed();
        if (left > 0) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel == this.maxDefLevel) {
                this.lastValue = this.isCurrentPageDictionaryEncoded ? Integer.valueOf(this.dataColumn.readValueDictionaryId()) : this.readPrimitiveTypedRow(category);
            }
            return true;
        }
        this.eof = true;
        return false;
    }

    private void addElement(ListColumnVector lcv, List<Object> elements, PrimitiveObjectInspector.PrimitiveCategory category, int index) throws IOException {
        lcv.offsets[index] = elements.size();
        if (this.definitionLevel < this.maxDefLevel) {
            lcv.isNull[index] = true;
            lcv.lengths[index] = 0L;
            this.fetchNextValue(category);
            return;
        }
        do {
            elements.add(this.lastValue);
        } while (this.fetchNextValue(category) && this.repetitionLevel != 0);
        lcv.isNull[index] = false;
        lcv.lengths[index] = (long)elements.size() - lcv.offsets[index];
    }

    private Object readPrimitiveTypedRow(PrimitiveObjectInspector.PrimitiveCategory category) {
        switch (category) {
            case INT: 
            case BYTE: 
            case SHORT: {
                return this.dataColumn.readInteger();
            }
            case DATE: 
            case INTERVAL_YEAR_MONTH: 
            case LONG: {
                return this.dataColumn.readLong();
            }
            case BOOLEAN: {
                return this.dataColumn.readBoolean() ? 1 : 0;
            }
            case DOUBLE: {
                return this.dataColumn.readDouble();
            }
            case BINARY: {
                return this.dataColumn.readBytes();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return this.dataColumn.readString();
            }
            case FLOAT: {
                return Float.valueOf(this.dataColumn.readFloat());
            }
            case DECIMAL: {
                return this.dataColumn.readDecimal();
            }
            case TIMESTAMP: {
                return this.dataColumn.readTimestamp();
            }
        }
        throw new RuntimeException("Unsupported type in the list: " + this.type);
    }

    private List decodeDictionaryIds(PrimitiveObjectInspector.PrimitiveCategory category, List valueList) {
        ArrayList<Object> resultList;
        int total = valueList.size();
        List intList = valueList;
        switch (category) {
            case INT: 
            case BYTE: 
            case SHORT: {
                resultList = new ArrayList<Object>(total);
                for (int i = 0; i < total; ++i) {
                    resultList.add(this.dictionary.readInteger((Integer)intList.get(i)));
                }
                break;
            }
            case DATE: 
            case INTERVAL_YEAR_MONTH: 
            case LONG: {
                resultList = new ArrayList(total);
                for (int i = 0; i < total; ++i) {
                    resultList.add(this.dictionary.readLong((Integer)intList.get(i)));
                }
                break;
            }
            case BOOLEAN: {
                resultList = new ArrayList(total);
                for (int i = 0; i < total; ++i) {
                    resultList.add(this.dictionary.readBoolean((Integer)intList.get(i)) ? 1 : 0);
                }
                break;
            }
            case DOUBLE: {
                resultList = new ArrayList(total);
                for (int i = 0; i < total; ++i) {
                    resultList.add(this.dictionary.readDouble((Integer)intList.get(i)));
                }
                break;
            }
            case BINARY: {
                resultList = new ArrayList(total);
                for (int i = 0; i < total; ++i) {
                    resultList.add(this.dictionary.readBytes((Integer)intList.get(i)));
                }
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                resultList = new ArrayList(total);
                for (int i = 0; i < total; ++i) {
                    resultList.add(this.dictionary.readString((Integer)intList.get(i)));
                }
                break;
            }
            case FLOAT: {
                resultList = new ArrayList(total);
                for (int i = 0; i < total; ++i) {
                    resultList.add(Float.valueOf(this.dictionary.readFloat((Integer)intList.get(i))));
                }
                break;
            }
            case DECIMAL: {
                resultList = new ArrayList(total);
                for (int i = 0; i < total; ++i) {
                    resultList.add(this.dictionary.readDecimal((Integer)intList.get(i)));
                }
                break;
            }
            case TIMESTAMP: {
                resultList = new ArrayList(total);
                for (int i = 0; i < total; ++i) {
                    resultList.add(this.dictionary.readTimestamp((Integer)intList.get(i)));
                }
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type in the list: " + this.type);
            }
        }
        return resultList;
    }

    private void setChildrenInfo(ListColumnVector lcv, int itemNum, int elementNum) {
        lcv.childCount = itemNum;
        long[] lcvLength = new long[elementNum];
        long[] lcvOffset = new long[elementNum];
        System.arraycopy(lcv.lengths, 0, lcvLength, 0, elementNum);
        System.arraycopy(lcv.offsets, 0, lcvOffset, 0, elementNum);
        lcv.lengths = lcvLength;
        lcv.offsets = lcvOffset;
    }

    private void fillColumnVector(PrimitiveObjectInspector.PrimitiveCategory category, ListColumnVector lcv, List valueList, int elementNum) {
        int total = valueList.size();
        this.setChildrenInfo(lcv, total, elementNum);
        switch (category) {
            case BOOLEAN: {
                lcv.child = new LongColumnVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    ((LongColumnVector)lcv.child).vector[i] = ((Integer)valueList.get(i)).intValue();
                }
                break;
            }
            case INT: 
            case BYTE: 
            case SHORT: 
            case DATE: 
            case INTERVAL_YEAR_MONTH: 
            case LONG: {
                lcv.child = new LongColumnVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    ((LongColumnVector)lcv.child).vector[i] = (Long)valueList.get(i);
                }
                break;
            }
            case DOUBLE: {
                lcv.child = new DoubleColumnVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    ((DoubleColumnVector)lcv.child).vector[i] = (Double)valueList.get(i);
                }
                break;
            }
            case BINARY: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                lcv.child = new BytesColumnVector(total);
                lcv.child.init();
                for (int i = 0; i < valueList.size(); ++i) {
                    byte[] src = (byte[])valueList.get(i);
                    ((BytesColumnVector)lcv.child).setRef(i, src, 0, src.length);
                }
                break;
            }
            case FLOAT: {
                lcv.child = new DoubleColumnVector(total);
                for (int i = 0; i < valueList.size(); ++i) {
                    ((DoubleColumnVector)lcv.child).vector[i] = ((Float)valueList.get(i)).floatValue();
                }
                break;
            }
            case DECIMAL: {
                this.decimalTypeCheck(this.type);
                int precision = this.type.asPrimitiveType().getDecimalMetadata().getPrecision();
                int scale = this.type.asPrimitiveType().getDecimalMetadata().getScale();
                lcv.child = new DecimalColumnVector(total, precision, scale);
                for (int i = 0; i < valueList.size(); ++i) {
                    ((DecimalColumnVector)lcv.child).vector[i].set((byte[])valueList.get(i), scale);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type in the list: " + this.type);
            }
        }
    }

    private void convertValueListToListColumnVector(PrimitiveObjectInspector.PrimitiveCategory category, ListColumnVector lcv, List valueList, int elementNum) {
        this.fillColumnVector(category, lcv, valueList, elementNum);
        this.setIsRepeating(lcv);
    }

    private void setIsRepeating(ListColumnVector lcv) {
        ColumnVector child0 = this.getChildData(lcv, 0);
        for (int i = 1; i < lcv.offsets.length; ++i) {
            ColumnVector currentChild = this.getChildData(lcv, i);
            if (this.compareColumnVector(child0, currentChild)) continue;
            lcv.isRepeating = false;
            return;
        }
        lcv.isRepeating = true;
    }

    private ColumnVector getChildData(ListColumnVector lcv, int index) {
        if (lcv.offsets[index] > Integer.MAX_VALUE || lcv.lengths[index] > Integer.MAX_VALUE) {
            throw new RuntimeException("The element number in list is out of scope.");
        }
        if (lcv.isNull[index]) {
            return null;
        }
        int start = (int)lcv.offsets[index];
        int length = (int)lcv.lengths[index];
        ColumnVector child = lcv.child;
        ColumnVector resultCV = null;
        if (child instanceof LongColumnVector) {
            resultCV = new LongColumnVector(length);
            try {
                System.arraycopy(((LongColumnVector)lcv.child).vector, start, resultCV.vector, 0, length);
            }
            catch (Exception e) {
                throw new RuntimeException("Fail to copy at index:" + index + ", start:" + start + ",length:" + length + ",vec len:" + ((LongColumnVector)lcv.child).vector.length + ", offset len:" + lcv.offsets.length + ", len len:" + lcv.lengths.length, e);
            }
        }
        if (child instanceof DoubleColumnVector) {
            resultCV = new DoubleColumnVector(length);
            System.arraycopy(((DoubleColumnVector)lcv.child).vector, start, ((DoubleColumnVector)resultCV).vector, 0, length);
        }
        if (child instanceof BytesColumnVector) {
            resultCV = new BytesColumnVector(length);
            System.arraycopy(((BytesColumnVector)lcv.child).vector, start, ((BytesColumnVector)resultCV).vector, 0, length);
        }
        if (child instanceof DecimalColumnVector) {
            resultCV = new DecimalColumnVector(length, ((DecimalColumnVector)child).precision, ((DecimalColumnVector)child).scale);
            System.arraycopy(((DecimalColumnVector)lcv.child).vector, start, ((DecimalColumnVector)resultCV).vector, 0, length);
        }
        return resultCV;
    }

    private boolean compareColumnVector(ColumnVector cv1, ColumnVector cv2) {
        if (cv1 == null && cv2 == null) {
            return true;
        }
        if (cv1 != null && cv2 != null) {
            if (cv1 instanceof LongColumnVector && cv2 instanceof LongColumnVector) {
                return this.compareLongColumnVector((LongColumnVector)cv1, (LongColumnVector)cv2);
            }
            if (cv1 instanceof DoubleColumnVector && cv2 instanceof DoubleColumnVector) {
                return this.compareDoubleColumnVector((DoubleColumnVector)cv1, (DoubleColumnVector)cv2);
            }
            if (cv1 instanceof BytesColumnVector && cv2 instanceof BytesColumnVector) {
                return this.compareBytesColumnVector((BytesColumnVector)cv1, (BytesColumnVector)cv2);
            }
            if (cv1 instanceof DecimalColumnVector && cv2 instanceof DecimalColumnVector) {
                return this.compareDecimalColumnVector((DecimalColumnVector)cv1, (DecimalColumnVector)cv2);
            }
            throw new RuntimeException("Unsupported ColumnVector comparision between " + cv1.getClass().getName() + " and " + cv2.getClass().getName());
        }
        return false;
    }

    private boolean compareLongColumnVector(LongColumnVector cv1, LongColumnVector cv2) {
        int length1 = cv1.vector.length;
        int length2 = cv2.vector.length;
        if (length1 == length2) {
            for (int i = 0; i < length1; ++i) {
                if (cv1.vector[i] == cv2.vector[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean compareDoubleColumnVector(DoubleColumnVector cv1, DoubleColumnVector cv2) {
        int length1 = cv1.vector.length;
        int length2 = cv2.vector.length;
        if (length1 == length2) {
            for (int i = 0; i < length1; ++i) {
                if (cv1.vector[i] == cv2.vector[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean compareDecimalColumnVector(DecimalColumnVector cv1, DecimalColumnVector cv2) {
        int length1 = cv1.vector.length;
        int length2 = cv2.vector.length;
        if (length1 == length2 && cv1.scale == cv2.scale && cv1.precision == cv2.precision) {
            for (int i = 0; i < length1; ++i) {
                if (!(cv1.vector[i] != null && cv2.vector[i] == null || cv1.vector[i] == null && cv2.vector[i] != null) && (cv1.vector[i] == null || cv2.vector[i] == null || cv1.vector[i].equals(cv2.vector[i]))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean compareBytesColumnVector(BytesColumnVector cv1, BytesColumnVector cv2) {
        int length1 = cv1.vector.length;
        int length2 = cv2.vector.length;
        if (length1 == length2) {
            for (int i = 0; i < length1; ++i) {
                int innerLen1 = cv1.vector[i].length;
                int innerLen2 = cv2.vector[i].length;
                if (innerLen1 == innerLen2) {
                    for (int j = 0; j < innerLen1; ++j) {
                        if (cv1.vector[i][j] == cv2.vector[i][j]) continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

