/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql2rel.DeduplicateCorrelateVariables;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.delegation.hive.HiveParserRexNodeConverter;
import org.apache.flink.table.planner.delegation.hive.HiveParserTypeCheckProcFactory;
import org.apache.flink.table.planner.delegation.hive.HiveParserUtils;
import org.apache.flink.table.planner.delegation.hive.SqlFunctionConverter;
import org.apache.flink.table.planner.delegation.hive.TableFunctionConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseDriver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTBuilder;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserContext;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserJoinTypeCheckCtx;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserNamedJoinInfo;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserPreCboCtx;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQB;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBExpr;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBParseInfo;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBSubQuery;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQueryState;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSqlFunctionConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSubQueryUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeCheckCtx;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserWindowingSpec;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserCreateViewInfo;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserErrorMsg;
import org.apache.flink.table.planner.plan.FlinkCalciteCatalogReader;
import org.apache.flink.table.planner.plan.nodes.hive.LogicalDistribution;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserCalcitePlanner {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserCalcitePlanner.class);
    private final HiveParserSemanticAnalyzer semanticAnalyzer;
    private final CatalogManager catalogManager;
    private final FlinkCalciteCatalogReader catalogReader;
    private final FlinkPlannerImpl flinkPlanner;
    private final PlannerContext plannerContext;
    private final FrameworkConfig frameworkConfig;
    private final RelOptCluster cluster;
    private final SqlFunctionConverter funcConverter;
    private final LinkedHashMap<RelNode, HiveParserRowResolver> relToRowResolver = new LinkedHashMap();
    private final LinkedHashMap<RelNode, Map<String, Integer>> relToHiveColNameCalcitePosMap = new LinkedHashMap();
    private int subqueryId = 0;
    private HiveParserCreateViewInfo createViewInfo;
    private List<FieldSchema> ctasCols;

    public HiveParserCalcitePlanner(HiveParserQueryState queryState, PlannerContext plannerContext, FlinkCalciteCatalogReader catalogReader, FrameworkConfig frameworkConfig, CatalogManager catalogManager, HiveShim hiveShim) throws SemanticException {
        this.catalogManager = catalogManager;
        this.catalogReader = catalogReader;
        this.flinkPlanner = plannerContext.createFlinkPlanner(catalogManager.getCurrentCatalog(), catalogManager.getCurrentDatabase());
        this.plannerContext = plannerContext;
        this.frameworkConfig = frameworkConfig;
        this.semanticAnalyzer = new HiveParserSemanticAnalyzer(queryState, hiveShim, frameworkConfig, plannerContext.getCluster());
        this.cluster = plannerContext.getCluster();
        this.funcConverter = new SqlFunctionConverter(this.cluster, frameworkConfig.getOperatorTable(), catalogReader.nameMatcher());
    }

    public void setCtasCols(List<FieldSchema> ctasCols) {
        this.ctasCols = ctasCols;
    }

    public void setCreatViewInfo(HiveParserCreateViewInfo createViewInfo) {
        if (createViewInfo != null) {
            this.semanticAnalyzer.unparseTranslator.enable();
        }
        this.createViewInfo = createViewInfo;
    }

    public void initCtx(HiveParserContext context) {
        this.semanticAnalyzer.initCtx(context);
    }

    public void init(boolean clearPartsCache) {
        this.semanticAnalyzer.init(clearPartsCache);
    }

    public HiveParserQB getQB() {
        return this.semanticAnalyzer.getQB();
    }

    public RelNode genLogicalPlan(HiveParserASTNode ast) throws SemanticException {
        LOG.info("Starting generating logical plan");
        HiveParserPreCboCtx cboCtx = new HiveParserPreCboCtx();
        HiveParserBaseSemanticAnalyzer.processPositionAlias(ast, this.semanticAnalyzer.getConf());
        if (!this.semanticAnalyzer.genResolvedParseTree(ast, cboCtx)) {
            return null;
        }
        for (String alias : this.semanticAnalyzer.getQB().getSubqAliases()) {
            HiveParserBaseSemanticAnalyzer.removeOBInSubQuery(this.semanticAnalyzer.getQB().getSubqForAlias(alias));
        }
        HiveParserASTNode queryForCbo = ast;
        if (cboCtx.type == HiveParserPreCboCtx.Type.CTAS || cboCtx.type == HiveParserPreCboCtx.Type.VIEW) {
            queryForCbo = cboCtx.nodeOfInterest;
        }
        HiveParserUtils.verifyCanHandleAst(queryForCbo, this.getQB(), this.semanticAnalyzer.getQueryProperties());
        this.semanticAnalyzer.disableJoinMerge = true;
        return this.logicalPlan();
    }

    private RelNode logicalPlan() {
        if (this.semanticAnalyzer.columnAccessInfo == null) {
            this.semanticAnalyzer.columnAccessInfo = new ColumnAccessInfo();
        }
        this.subqueryId = 0;
        this.relToRowResolver.clear();
        this.relToHiveColNameCalcitePosMap.clear();
        try {
            RelNode plan = this.genLogicalPlan(this.getQB(), true, null, null);
            if (this.createViewInfo != null) {
                this.semanticAnalyzer.resultSchema = HiveParserUtils.convertRowSchemaToResultSetSchema(this.relToRowResolver.get(plan), false);
                HiveParserUtils.saveViewDefinition(this.semanticAnalyzer.resultSchema, this.createViewInfo, this.semanticAnalyzer.ctx.getTokenRewriteStream(), this.semanticAnalyzer.unparseTranslator, this.semanticAnalyzer.getConf());
            } else if (this.ctasCols != null) {
                this.semanticAnalyzer.resultSchema = HiveParserUtils.convertRowSchemaToResultSetSchema(this.relToRowResolver.get(plan), false);
                this.ctasCols.addAll(this.semanticAnalyzer.resultSchema);
            }
            return plan;
        }
        catch (SemanticException e) {
            throw new RuntimeException(e);
        }
    }

    private RelNode genSetOpLogicalPlan(HiveParserQBExpr.Opcode opcode, String alias, String leftalias, RelNode leftRel, String rightalias, RelNode rightRel) throws SemanticException {
        LogicalUnion setOpRel;
        HiveParserRowResolver leftRR = this.relToRowResolver.get(leftRel);
        HiveParserRowResolver rightRR = this.relToRowResolver.get(rightRel);
        LinkedHashMap<String, ColumnInfo> leftMap = leftRR.getFieldMap(leftalias);
        LinkedHashMap<String, ColumnInfo> rightMap = rightRR.getFieldMap(rightalias);
        if (leftMap.size() != rightMap.size()) {
            throw new SemanticException("Schema of both sides of union should match.");
        }
        HiveParserRowResolver setOpOutRR = new HiveParserRowResolver();
        Iterator lIter = ((HashMap)leftMap).entrySet().iterator();
        Iterator rIter = ((HashMap)rightMap).entrySet().iterator();
        while (lIter.hasNext()) {
            Map.Entry lEntry = lIter.next();
            Map.Entry rEntry = rIter.next();
            ColumnInfo lInfo = (ColumnInfo)lEntry.getValue();
            ColumnInfo rInfo = (ColumnInfo)rEntry.getValue();
            String field = (String)lEntry.getKey();
            TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType());
            if (commonTypeInfo == null) {
                HiveParserASTNode tabRef = this.getQB().getAliases().isEmpty() ? null : this.getQB().getParseInfo().getSrcForAlias(this.getQB().getAliases().get(0));
                throw new SemanticException(HiveParserUtils.generateErrorMessage(tabRef, "Schema of both sides of setop should match: Column " + field + " is of type " + lInfo.getType().getTypeName() + " on first table and type " + rInfo.getType().getTypeName() + " on second table"));
            }
            ColumnInfo setOpColInfo = new ColumnInfo(lInfo);
            setOpColInfo.setType(commonTypeInfo);
            setOpOutRR.put(alias, field, setOpColInfo);
        }
        boolean leftNeedsTypeCast = false;
        boolean rightNeedsTypeCast = false;
        ArrayList<RexNode> leftProjs = new ArrayList<RexNode>();
        ArrayList<RexNode> rightProjs = new ArrayList<RexNode>();
        List leftFields = leftRel.getRowType().getFieldList();
        List rightFields = rightRel.getRowType().getFieldList();
        for (int i = 0; i < leftFields.size(); ++i) {
            RelDataType rightFieldType;
            RelDataType leftFieldType = ((RelDataTypeField)leftFields.get(i)).getType();
            if (!leftFieldType.equals(rightFieldType = ((RelDataTypeField)rightFields.get(i)).getType())) {
                RelDataType unionFieldType = HiveParserUtils.toRelDataType(setOpOutRR.getColumnInfos().get(i).getType(), this.cluster.getTypeFactory());
                if (!unionFieldType.equals(leftFieldType)) {
                    leftNeedsTypeCast = true;
                }
                leftProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldType, (RexNode)this.cluster.getRexBuilder().makeInputRef(leftFieldType, i), true));
                if (!unionFieldType.equals(rightFieldType)) {
                    rightNeedsTypeCast = true;
                }
                rightProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldType, (RexNode)this.cluster.getRexBuilder().makeInputRef(rightFieldType, i), true));
                continue;
            }
            leftProjs.add(this.cluster.getRexBuilder().ensureType(leftFieldType, (RexNode)this.cluster.getRexBuilder().makeInputRef(leftFieldType, i), true));
            rightProjs.add(this.cluster.getRexBuilder().ensureType(rightFieldType, (RexNode)this.cluster.getRexBuilder().makeInputRef(rightFieldType, i), true));
        }
        if (leftNeedsTypeCast) {
            leftRel = LogicalProject.create((RelNode)leftRel, Collections.emptyList(), leftProjs, (List)leftRel.getRowType().getFieldNames());
        }
        if (rightNeedsTypeCast) {
            rightRel = LogicalProject.create((RelNode)rightRel, Collections.emptyList(), rightProjs, (List)rightRel.getRowType().getFieldNames());
        }
        List<RelNode> leftAndRight = Arrays.asList(leftRel, rightRel);
        switch (opcode) {
            case UNION: {
                setOpRel = LogicalUnion.create(leftAndRight, (boolean)true);
                break;
            }
            case INTERSECT: {
                setOpRel = LogicalIntersect.create(leftAndRight, (boolean)false);
                break;
            }
            case INTERSECTALL: {
                setOpRel = LogicalIntersect.create(leftAndRight, (boolean)true);
                break;
            }
            case EXCEPT: {
                setOpRel = LogicalMinus.create(leftAndRight, (boolean)false);
                break;
            }
            case EXCEPTALL: {
                setOpRel = LogicalMinus.create(leftAndRight, (boolean)true);
                break;
            }
            default: {
                throw new SemanticException("Unsupported set operator " + opcode.toString());
            }
        }
        this.relToRowResolver.put((RelNode)setOpRel, setOpOutRR);
        this.relToHiveColNameCalcitePosMap.put((RelNode)setOpRel, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(setOpOutRR));
        return setOpRel;
    }

    private RelNode genJoinRelNode(RelNode leftRel, String leftTableAlias, RelNode rightRel, String rightTableAlias, JoinType hiveJoinType, HiveParserASTNode joinCondAst) throws SemanticException {
        HiveParserRowResolver topRR;
        LogicalJoin topRel;
        JoinRelType calciteJoinType;
        RexLiteral joinCondRex;
        HiveParserRowResolver leftRR = this.relToRowResolver.get(leftRel);
        HiveParserRowResolver rightRR = this.relToRowResolver.get(rightRel);
        ArrayList<String> namedColumns = null;
        if (joinCondAst != null) {
            HiveParserJoinTypeCheckCtx jCtx = new HiveParserJoinTypeCheckCtx(leftRR, rightRR, hiveJoinType, this.frameworkConfig, this.cluster);
            HiveParserRowResolver combinedRR = HiveParserRowResolver.getCombinedRR(leftRR, rightRR);
            if (joinCondAst.getType() == 956 && !hiveJoinType.equals((Object)JoinType.LEFTSEMI)) {
                namedColumns = new ArrayList<String>();
                HiveParserASTNode and = (HiveParserASTNode)HiveASTParseDriver.ADAPTOR.create(33, "and");
                HiveParserASTNode equal = null;
                int count = 0;
                for (Node child : joinCondAst.getChildren()) {
                    String columnName = ((HiveParserASTNode)child).getText();
                    if (this.semanticAnalyzer.unparseTranslator != null && this.semanticAnalyzer.unparseTranslator.isEnabled()) {
                        this.semanticAnalyzer.unparseTranslator.addIdentifierTranslation((HiveParserASTNode)child);
                    }
                    namedColumns.add(columnName);
                    HiveParserASTNode left = HiveParserASTBuilder.qualifiedName(leftTableAlias, columnName);
                    HiveParserASTNode right = HiveParserASTBuilder.qualifiedName(rightTableAlias, columnName);
                    equal = (HiveParserASTNode)HiveASTParseDriver.ADAPTOR.create(18, "=");
                    HiveASTParseDriver.ADAPTOR.addChild(equal, left);
                    HiveASTParseDriver.ADAPTOR.addChild(equal, right);
                    HiveASTParseDriver.ADAPTOR.addChild(and, equal);
                    ++count;
                }
                joinCondAst = count > 1 ? and : equal;
            } else if (this.semanticAnalyzer.unparseTranslator != null && this.semanticAnalyzer.unparseTranslator.isEnabled()) {
                this.semanticAnalyzer.genAllExprNodeDesc(joinCondAst, combinedRR, jCtx);
            }
            Map<HiveParserASTNode, ExprNodeDesc> exprNodes = HiveParserUtils.genExprNode(joinCondAst, jCtx);
            if (jCtx.getError() != null) {
                throw new SemanticException(HiveParserUtils.generateErrorMessage(jCtx.getErrorSrcNode(), jCtx.getError()));
            }
            ExprNodeDesc joinCondExprNode = exprNodes.get(joinCondAst);
            ArrayList<RelNode> inputRels = new ArrayList<RelNode>();
            inputRels.add(leftRel);
            inputRels.add(rightRel);
            joinCondRex = (RexNode)HiveParserRexNodeConverter.convert(this.cluster, joinCondExprNode, inputRels, this.relToRowResolver, this.relToHiveColNameCalcitePosMap, false, this.funcConverter).accept((RexVisitor)this.funcConverter);
        } else {
            joinCondRex = this.cluster.getRexBuilder().makeLiteral(true);
        }
        boolean leftSemiJoin = false;
        switch (hiveJoinType) {
            case LEFTOUTER: {
                calciteJoinType = JoinRelType.LEFT;
                break;
            }
            case RIGHTOUTER: {
                calciteJoinType = JoinRelType.RIGHT;
                break;
            }
            case FULLOUTER: {
                calciteJoinType = JoinRelType.FULL;
                break;
            }
            case LEFTSEMI: {
                calciteJoinType = JoinRelType.SEMI;
                leftSemiJoin = true;
                break;
            }
            default: {
                calciteJoinType = JoinRelType.INNER;
            }
        }
        if (leftSemiJoin) {
            ArrayList sysFieldList = new ArrayList();
            ArrayList<RexNode> leftJoinKeys = new ArrayList<RexNode>();
            ArrayList<RexNode> rightJoinKeys = new ArrayList<RexNode>();
            RexNode nonEquiConds = RelOptUtil.splitJoinCondition(sysFieldList, (RelNode)leftRel, (RelNode)rightRel, (RexNode)joinCondRex, leftJoinKeys, rightJoinKeys, null, null);
            if (!nonEquiConds.isAlwaysTrue()) {
                throw new SemanticException("Non equality condition not supported in Semi-Join" + nonEquiConds);
            }
            RelNode[] inputRels = new RelNode[]{leftRel, rightRel};
            ArrayList<Integer> leftKeys = new ArrayList<Integer>();
            ArrayList<Integer> rightKeys = new ArrayList<Integer>();
            joinCondRex = HiveParserUtils.projectNonColumnEquiConditions(RelFactories.DEFAULT_PROJECT_FACTORY, inputRels, leftJoinKeys, rightJoinKeys, 0, leftKeys, rightKeys);
            topRel = LogicalJoin.create((RelNode)inputRels[0], (RelNode)inputRels[1], Collections.emptyList(), (RexNode)joinCondRex, Collections.emptySet(), (JoinRelType)calciteJoinType);
            if (inputRels[0] != leftRel) {
                HiveParserRowResolver newLeftRR = new HiveParserRowResolver();
                if (!HiveParserRowResolver.add(newLeftRR, leftRR)) {
                    LOG.warn("Duplicates detected when adding columns to RR: see previous message");
                }
                for (int i = leftRel.getRowType().getFieldCount(); i < inputRels[0].getRowType().getFieldCount(); ++i) {
                    ColumnInfo oColInfo = new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(i), HiveParserTypeConverter.convert(((RelDataTypeField)inputRels[0].getRowType().getFieldList().get(i)).getType()), null, false);
                    newLeftRR.put(oColInfo.getTabAlias(), oColInfo.getInternalName(), oColInfo);
                }
                HiveParserRowResolver joinRR = new HiveParserRowResolver();
                if (!HiveParserRowResolver.add(joinRR, newLeftRR)) {
                    LOG.warn("Duplicates detected when adding columns to RR: see previous message");
                }
                this.relToHiveColNameCalcitePosMap.put((RelNode)topRel, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(joinRR));
                this.relToRowResolver.put((RelNode)topRel, joinRR);
                ArrayList<RexInputRef> topFields = new ArrayList<RexInputRef>();
                ArrayList<String> topFieldNames = new ArrayList<String>();
                for (int i = 0; i < leftRel.getRowType().getFieldCount(); ++i) {
                    RelDataTypeField field = (RelDataTypeField)leftRel.getRowType().getFieldList().get(i);
                    topFields.add(leftRel.getCluster().getRexBuilder().makeInputRef(field.getType(), i));
                    topFieldNames.add(field.getName());
                }
                topRel = LogicalProject.create((RelNode)topRel, Collections.emptyList(), topFields, topFieldNames);
            }
            if (!HiveParserRowResolver.add(topRR = new HiveParserRowResolver(), leftRR)) {
                LOG.warn("Duplicates detected when adding columns to RR: see previous message");
            }
        } else {
            topRel = LogicalJoin.create((RelNode)leftRel, (RelNode)rightRel, Collections.emptyList(), (RexNode)joinCondRex, Collections.emptySet(), (JoinRelType)calciteJoinType);
            topRR = HiveParserRowResolver.getCombinedRR(leftRR, rightRR);
            if (namedColumns != null) {
                ArrayList<String> tableAliases = new ArrayList<String>();
                tableAliases.add(leftTableAlias);
                tableAliases.add(rightTableAlias);
                topRR.setNamedJoinInfo(new HiveParserNamedJoinInfo(tableAliases, namedColumns, hiveJoinType));
            }
        }
        this.relToHiveColNameCalcitePosMap.put((RelNode)topRel, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(topRR));
        this.relToRowResolver.put((RelNode)topRel, topRR);
        return topRel;
    }

    private RelNode genJoinLogicalPlan(HiveParserASTNode joinParseTree, Map<String, RelNode> aliasToRel) throws SemanticException {
        JoinType hiveJoinType;
        RelNode leftRel = null;
        RelNode rightRel = null;
        if (joinParseTree.getToken().getType() == 1002) {
            String msg = "UNIQUE JOIN is currently not supported in CBO, turn off cbo to use UNIQUE JOIN.";
            throw new SemanticException(msg);
        }
        switch (joinParseTree.getToken().getType()) {
            case 808: {
                hiveJoinType = JoinType.LEFTOUTER;
                break;
            }
            case 898: {
                hiveJoinType = JoinType.RIGHTOUTER;
                break;
            }
            case 765: {
                hiveJoinType = JoinType.FULLOUTER;
                break;
            }
            case 809: {
                hiveJoinType = JoinType.LEFTSEMI;
                break;
            }
            default: {
                hiveJoinType = JoinType.INNER;
            }
        }
        HiveParserASTNode left = (HiveParserASTNode)joinParseTree.getChild(0);
        String leftTableAlias = null;
        if (left.getToken().getType() == 981 || left.getToken().getType() == 945 || left.getToken().getType() == 879) {
            String tableName = HiveParserBaseSemanticAnalyzer.getUnescapedUnqualifiedTableName((HiveParserASTNode)left.getChild(0)).toLowerCase();
            leftTableAlias = left.getChildCount() == 1 ? tableName : HiveParserBaseSemanticAnalyzer.unescapeIdentifier(left.getChild(left.getChildCount() - 1).getText().toLowerCase());
            leftTableAlias = left.getToken().getType() == 879 ? HiveParserBaseSemanticAnalyzer.unescapeIdentifier(left.getChild(1).getText().toLowerCase()) : leftTableAlias;
            leftRel = aliasToRel.get(leftTableAlias);
        } else if (HiveParserUtils.isJoinToken(left)) {
            leftRel = this.genJoinLogicalPlan(left, aliasToRel);
        } else assert (false);
        HiveParserASTNode right = (HiveParserASTNode)joinParseTree.getChild(1);
        String rightTableAlias = null;
        if (right.getToken().getType() == 981 || right.getToken().getType() == 945 || right.getToken().getType() == 879) {
            String tableName = HiveParserBaseSemanticAnalyzer.getUnescapedUnqualifiedTableName((HiveParserASTNode)right.getChild(0)).toLowerCase();
            rightTableAlias = right.getChildCount() == 1 ? tableName : HiveParserBaseSemanticAnalyzer.unescapeIdentifier(right.getChild(right.getChildCount() - 1).getText().toLowerCase());
            rightTableAlias = right.getToken().getType() == 879 ? HiveParserBaseSemanticAnalyzer.unescapeIdentifier(right.getChild(1).getText().toLowerCase()) : rightTableAlias;
            rightRel = aliasToRel.get(rightTableAlias);
        } else assert (false);
        HiveParserASTNode joinCond = (HiveParserASTNode)joinParseTree.getChild(2);
        return this.genJoinRelNode(leftRel, leftTableAlias, rightRel, rightTableAlias, hiveJoinType, joinCond);
    }

    private RelNode genTableLogicalPlan(String tableAlias, HiveParserQB qb) throws SemanticException {
        HiveParserRowResolver rowResolver = new HiveParserRowResolver();
        try {
            ColumnInfo colInfo;
            String colName;
            if (qb.getParseInfo().needTableSample(tableAlias) || this.semanticAnalyzer.getNameToSplitSampleMap().containsKey(tableAlias) || Boolean.parseBoolean(this.semanticAnalyzer.getConf().get("hive.cbo.returnpath.hiveop", "false")) && this.semanticAnalyzer.getConf().getBoolVar(HiveConf.ConfVars.HIVETESTMODE)) {
                String msg = String.format("Table Sample specified for %s. Currently we don't support Table Sample clauses in CBO, turn off cbo for queries on tableSamples.", tableAlias);
                LOG.debug(msg);
                throw new SemanticException(msg);
            }
            Table table = qb.getMetaData().getSrcForAlias(tableAlias);
            if (table.isTemporary()) {
                RelNode values = HiveParserBaseSemanticAnalyzer.genValues(tableAlias, table, rowResolver, this.cluster, this.getQB().getValuesTableToData().get(tableAlias));
                this.relToRowResolver.put(values, rowResolver);
                this.relToHiveColNameCalcitePosMap.put(values, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(rowResolver));
                return values;
            }
            StructObjectInspector rowObjectInspector = (StructObjectInspector)table.getDeserializer().getObjectInspector();
            List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
            for (StructField structField : fields) {
                colName = structField.getFieldName();
                colInfo = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()), tableAlias, false);
                colInfo.setSkewedCol(HiveParserUtils.isSkewedCol(tableAlias, qb, colName));
                rowResolver.put(tableAlias, colName, colInfo);
            }
            for (FieldSchema fieldSchema : table.getPartCols()) {
                colName = fieldSchema.getName();
                colInfo = new ColumnInfo(colName, TypeInfoFactory.getPrimitiveTypeInfo(fieldSchema.getType()), tableAlias, true);
                rowResolver.put(tableAlias, colName, colInfo);
            }
            HiveParserBaseSemanticAnalyzer.TableType tableType = HiveParserBaseSemanticAnalyzer.obtainTableType(table);
            Preconditions.checkArgument((tableType == HiveParserBaseSemanticAnalyzer.TableType.NATIVE ? 1 : 0) != 0, (Object)"Only native tables are supported");
            RelNode relNode = this.catalogReader.getTable(Arrays.asList(this.catalogManager.getCurrentCatalog(), table.getDbName(), table.getTableName())).toRel(ViewExpanders.toRelContext((RelOptTable.ViewExpander)this.flinkPlanner.createToRelContext(), (RelOptCluster)this.cluster));
            Map<String, Integer> hiveToCalciteColMap = HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(rowResolver);
            this.relToRowResolver.put(relNode, rowResolver);
            this.relToHiveColNameCalcitePosMap.put(relNode, hiveToCalciteColMap);
            return relNode;
        }
        catch (Exception e) {
            if (e instanceof SemanticException) {
                throw (SemanticException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private RelNode genFilterRelNode(HiveParserASTNode filterExpr, RelNode srcRel, Map<String, Integer> outerNameToPosMap, HiveParserRowResolver outerRR, boolean useCaching) throws SemanticException {
        ExprNodeDesc filterCond = this.semanticAnalyzer.genExprNodeDesc(filterExpr, this.relToRowResolver.get(srcRel), outerRR, null, useCaching);
        if (filterCond instanceof ExprNodeConstantDesc && !filterCond.getTypeString().equals("boolean")) {
            throw new SemanticException("Filter expression with non-boolean return type.");
        }
        Map<String, Integer> hiveColNameToCalcitePos = this.relToHiveColNameCalcitePosMap.get(srcRel);
        RexNode convertedFilterExpr = new HiveParserRexNodeConverter(this.cluster, srcRel.getRowType(), outerNameToPosMap, hiveColNameToCalcitePos, this.relToRowResolver.get(srcRel), outerRR, 0, true, this.subqueryId, this.funcConverter).convert(filterCond);
        RexNode factoredFilterExpr = (RexNode)RexUtil.pullFactors((RexBuilder)this.cluster.getRexBuilder(), (RexNode)convertedFilterExpr).accept((RexVisitor)this.funcConverter);
        LogicalFilter filterRel = LogicalFilter.create((RelNode)srcRel, (RexNode)factoredFilterExpr);
        this.relToRowResolver.put((RelNode)filterRel, this.relToRowResolver.get(srcRel));
        this.relToHiveColNameCalcitePosMap.put((RelNode)filterRel, hiveColNameToCalcitePos);
        return filterRel;
    }

    private void subqueryRestrictionCheck(HiveParserQB qb, HiveParserASTNode searchCond, RelNode srcRel, boolean forHavingClause, Set<HiveParserASTNode> corrScalarQueries) throws SemanticException {
        List<HiveParserASTNode> subQueriesInOriginalTree = HiveParserSubQueryUtils.findSubQueries(searchCond);
        HiveParserASTNode clonedSearchCond = (HiveParserASTNode)HiveParserSubQueryUtils.ADAPTOR.dupTree(searchCond);
        List<HiveParserASTNode> subQueries = HiveParserSubQueryUtils.findSubQueries(clonedSearchCond);
        for (int i = 0; i < subQueriesInOriginalTree.size(); ++i) {
            String havingInputAlias;
            HiveParserRowResolver inputRR;
            int sqIdx = qb.incrNumSubQueryPredicates();
            HiveParserASTNode originalSubQueryAST = subQueriesInOriginalTree.get(i);
            HiveParserASTNode subQueryAST = subQueries.get(i);
            ObjectPair<Boolean, Integer> subqInfo = new ObjectPair<Boolean, Integer>(false, 0);
            if (!HiveParserBaseSemanticAnalyzer.topLevelConjunctCheck(clonedSearchCond, subqInfo)) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION, subQueryAST, "Only SubQuery expressions that are top level conjuncts are allowed"));
            }
            HiveParserASTNode outerQueryExpr = (HiveParserASTNode)subQueryAST.getChild(2);
            if (outerQueryExpr != null && outerQueryExpr.getType() == 946) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION, outerQueryExpr, "IN/NOT IN subqueries are not allowed in LHS"));
            }
            HiveParserQBSubQuery subQuery = HiveParserSubQueryUtils.buildSubQuery(sqIdx, subQueryAST, originalSubQueryAST, this.semanticAnalyzer.ctx, this.frameworkConfig, this.cluster);
            boolean isCorrScalarWithAgg = subQuery.subqueryRestrictionsCheck(inputRR = this.relToRowResolver.get(srcRel), forHavingClause, havingInputAlias = null);
            if (!isCorrScalarWithAgg) continue;
            corrScalarQueries.add(originalSubQueryAST);
        }
    }

    private boolean genSubQueryRelNode(HiveParserQB qb, HiveParserASTNode node, RelNode srcRel, boolean forHavingClause, Map<HiveParserASTNode, RelNode> subQueryToRelNode) throws SemanticException {
        HashSet<HiveParserASTNode> corrScalarQueriesWithAgg = new HashSet<HiveParserASTNode>();
        this.subqueryRestrictionCheck(qb, node, srcRel, forHavingClause, corrScalarQueriesWithAgg);
        ArrayDeque<HiveParserASTNode> stack = new ArrayDeque<HiveParserASTNode>();
        stack.push(node);
        boolean isSubQuery = false;
        block3: while (!stack.isEmpty()) {
            HiveParserASTNode next = (HiveParserASTNode)stack.pop();
            switch (next.getType()) {
                case 946: {
                    if (((ArrayList)next.getChildren()).size() == 3 && next.getChild(2).getType() == 946) {
                        throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION, next.getChild(2), "SubQuery in LHS expressions are not supported."));
                    }
                    String sbQueryAlias = "sq_" + qb.incrNumSubQueryPredicates();
                    HiveParserQB subQB = new HiveParserQB(qb.getId(), sbQueryAlias, true);
                    HiveParserBaseSemanticAnalyzer.Phase1Ctx ctx1 = HiveParserBaseSemanticAnalyzer.initPhase1Ctx();
                    this.semanticAnalyzer.doPhase1((HiveParserASTNode)next.getChild(1), subQB, ctx1, null);
                    this.semanticAnalyzer.getMetaData(subQB);
                    RelNode subQueryRelNode = this.genLogicalPlan(subQB, false, this.relToHiveColNameCalcitePosMap.get(srcRel), this.relToRowResolver.get(srcRel));
                    subQueryToRelNode.put(next, subQueryRelNode);
                    isSubQuery = true;
                    continue block3;
                }
            }
            int childCount = next.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                stack.push((HiveParserASTNode)next.getChild(i));
            }
        }
        return isSubQuery;
    }

    private RelNode genFilterRelNode(HiveParserQB qb, HiveParserASTNode searchCond, RelNode srcRel, Map<String, Integer> outerNameToPosMap, HiveParserRowResolver outerRR, boolean forHavingClause) throws SemanticException {
        HashMap<HiveParserASTNode, RelNode> subQueryToRelNode = new HashMap<HiveParserASTNode, RelNode>();
        boolean isSubQuery = this.genSubQueryRelNode(qb, searchCond, srcRel, forHavingClause, subQueryToRelNode);
        if (isSubQuery) {
            ExprNodeDesc subQueryExpr = this.semanticAnalyzer.genExprNodeDesc(searchCond, this.relToRowResolver.get(srcRel), outerRR, subQueryToRelNode, forHavingClause);
            Map<String, Integer> hiveColNameToCalcitePos = this.relToHiveColNameCalcitePosMap.get(srcRel);
            RexNode convertedFilterLHS = (RexNode)new HiveParserRexNodeConverter(this.cluster, srcRel.getRowType(), outerNameToPosMap, hiveColNameToCalcitePos, this.relToRowResolver.get(srcRel), outerRR, 0, true, this.subqueryId, this.funcConverter).convert(subQueryExpr).accept((RexVisitor)this.funcConverter);
            LogicalFilter filterRel = LogicalFilter.create((RelNode)srcRel, (RexNode)convertedFilterLHS);
            this.relToHiveColNameCalcitePosMap.put((RelNode)filterRel, this.relToHiveColNameCalcitePosMap.get(srcRel));
            this.relToRowResolver.put((RelNode)filterRel, this.relToRowResolver.get(srcRel));
            ++this.subqueryId;
            return filterRel;
        }
        return this.genFilterRelNode(searchCond, srcRel, outerNameToPosMap, outerRR, forHavingClause);
    }

    private RelNode genFilterLogicalPlan(HiveParserQB qb, RelNode srcRel, Map<String, Integer> outerNameToPosMap, HiveParserRowResolver outerRR) throws SemanticException {
        RelNode filterRel = null;
        Iterator<HiveParserASTNode> whereClauseIterator = qb.getParseInfo().getDestToWhereExpr().values().iterator();
        if (whereClauseIterator.hasNext()) {
            filterRel = this.genFilterRelNode(qb, (HiveParserASTNode)whereClauseIterator.next().getChild(0), srcRel, outerNameToPosMap, outerRR, false);
        }
        return filterRel;
    }

    private RelNode genGBRelNode(List<ExprNodeDesc> gbExprs, List<HiveParserBaseSemanticAnalyzer.AggInfo> aggInfos, List<Integer> groupSets, RelNode srcRel) throws SemanticException {
        Map<String, Integer> colNameToPos = this.relToHiveColNameCalcitePosMap.get(srcRel);
        HiveParserRexNodeConverter converter = new HiveParserRexNodeConverter(this.cluster, srcRel.getRowType(), colNameToPos, 0, false, this.funcConverter);
        boolean hasGroupSets = groupSets != null && !groupSets.isEmpty();
        ArrayList<Object> gbInputRexNodes = new ArrayList<Object>();
        HashMap<String, Integer> inputRexNodeToIndex = new HashMap<String, Integer>();
        ArrayList<Integer> gbKeyIndices = new ArrayList<Integer>();
        int inputIndex = 0;
        for (ExprNodeDesc key : gbExprs) {
            RexNode keyRex = (RexNode)this.convertNullLiteral(converter.convert(key)).accept((RexVisitor)this.funcConverter);
            gbInputRexNodes.add(keyRex);
            gbKeyIndices.add(inputIndex);
            inputRexNodeToIndex.put(keyRex.toString(), inputIndex);
            ++inputIndex;
        }
        ImmutableBitSet groupSet = ImmutableBitSet.of(gbKeyIndices);
        ArrayList transformedGroupSets = null;
        if (hasGroupSets) {
            HashSet set = new HashSet(groupSets.size());
            for (int val : groupSets) {
                set.add(HiveParserBaseSemanticAnalyzer.convert(val, groupSet.cardinality()));
            }
            transformedGroupSets = new ArrayList(set);
            transformedGroupSets.sort(ImmutableBitSet.COMPARATOR);
        }
        for (HiveParserBaseSemanticAnalyzer.AggInfo aggInfo : aggInfos) {
            for (ExprNodeDesc expr : aggInfo.getAggParams()) {
                RexNode paramRex = (RexNode)converter.convert(expr).accept((RexVisitor)this.funcConverter);
                Integer argIndex = (Integer)inputRexNodeToIndex.get(paramRex.toString());
                if (argIndex != null) continue;
                argIndex = gbInputRexNodes.size();
                inputRexNodeToIndex.put(paramRex.toString(), argIndex);
                gbInputRexNodes.add(paramRex);
            }
        }
        LogicalProject gbInputRel = LogicalProject.create((RelNode)srcRel, Collections.emptyList(), gbInputRexNodes, (List)null);
        ArrayList<AggregateCall> aggregateCalls = new ArrayList<AggregateCall>();
        for (HiveParserBaseSemanticAnalyzer.AggInfo aggInfo : aggInfos) {
            aggregateCalls.add(HiveParserUtils.toAggCall(aggInfo, converter, inputRexNodeToIndex, groupSet.cardinality(), (RelNode)gbInputRel, this.cluster, this.funcConverter));
        }
        if (hasGroupSets) {
            AggregateCall aggCall = AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.GROUPING_ID, (boolean)false, (boolean)false, (boolean)false, gbKeyIndices, (int)-1, (RelCollation)RelCollations.EMPTY, (int)groupSet.cardinality(), (RelNode)gbInputRel, null, null);
            aggregateCalls.add(aggCall);
        }
        if (gbInputRexNodes.isEmpty()) {
            gbInputRexNodes.add(this.cluster.getRexBuilder().makeInputRef(srcRel, 0));
        }
        return LogicalAggregate.create((RelNode)gbInputRel, (ImmutableBitSet)groupSet, transformedGroupSets, aggregateCalls);
    }

    private RelNode genGBLogicalPlan(HiveParserQB qb, RelNode srcRel) throws SemanticException {
        boolean cubeRollupGrpSetPresent;
        HiveParserASTNode node;
        RelNode gbRel = null;
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        String detsClauseName = qbp.getClauseNames().iterator().next();
        HiveParserASTNode selExprList = qb.getParseInfo().getSelForClause(detsClauseName);
        HiveParserSubQueryUtils.checkForTopLevelSubqueries(selExprList);
        if (selExprList.getToken().getType() == 904 && selExprList.getChildCount() == 1 && selExprList.getChild(0).getChildCount() == 1 && (node = (HiveParserASTNode)selExprList.getChild(0).getChild(0)).getToken().getType() == 652) {
            srcRel = this.genSelectLogicalPlan(qb, srcRel, srcRel, null, null);
            HiveParserRowResolver rr = this.relToRowResolver.get(srcRel);
            qbp.setSelExprForClause(detsClauseName, HiveParserUtils.genSelectDIAST(rr));
        }
        if (selExprList.getToken().getType() == 904 && !qb.getAllWindowingSpecs().isEmpty()) {
            return null;
        }
        List<HiveParserASTNode> gbAstExprs = HiveParserBaseSemanticAnalyzer.getGroupByForClause(qbp, detsClauseName);
        HashMap<String, HiveParserASTNode> aggregationTrees = qbp.getAggregationExprsForClause(detsClauseName);
        boolean hasGrpByAstExprs = !gbAstExprs.isEmpty();
        boolean hasAggregationTrees = aggregationTrees != null && !aggregationTrees.isEmpty();
        boolean bl = cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
        if (this.semanticAnalyzer.getConf().getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) && qbp.getDistinctFuncExprsForClause(detsClauseName).size() > 1) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_MULTIPLE_DISTINCTS.getMsg());
        }
        if (hasGrpByAstExprs || hasAggregationTrees) {
            ArrayList<ExprNodeDesc> gbExprNodeDescs = new ArrayList<ExprNodeDesc>();
            ArrayList<String> outputColNames = new ArrayList<String>();
            HiveParserRowResolver inputRR = this.relToRowResolver.get(srcRel);
            HiveParserRowResolver outputRR = new HiveParserRowResolver();
            outputRR.setIsExprResolver(true);
            if (hasGrpByAstExprs) {
                for (HiveParserASTNode gbAstExpr : gbAstExprs) {
                    Map<HiveParserASTNode, ExprNodeDesc> astToExprNodeDesc = this.semanticAnalyzer.genAllExprNodeDesc(gbAstExpr, inputRR);
                    ExprNodeDesc grpbyExprNDesc = astToExprNodeDesc.get(gbAstExpr);
                    if (grpbyExprNDesc == null) {
                        throw new SemanticException("Invalid Column Reference: " + gbAstExpr.dump());
                    }
                    HiveParserBaseSemanticAnalyzer.addToGBExpr(outputRR, inputRR, gbAstExpr, grpbyExprNDesc, gbExprNodeDescs, outputColNames);
                }
            }
            int numGroupCols = gbExprNodeDescs.size();
            List<Integer> groupingSets = null;
            if (cubeRollupGrpSetPresent) {
                if (qbp.getDestRollups().contains(detsClauseName)) {
                    groupingSets = HiveParserBaseSemanticAnalyzer.getGroupingSetsForRollup(gbAstExprs.size());
                } else if (qbp.getDestCubes().contains(detsClauseName)) {
                    groupingSets = HiveParserBaseSemanticAnalyzer.getGroupingSetsForCube(gbAstExprs.size());
                } else if (qbp.getDestGroupingSets().contains(detsClauseName)) {
                    groupingSets = HiveParserBaseSemanticAnalyzer.getGroupingSets(gbAstExprs, qbp, detsClauseName);
                }
            }
            ArrayList<HiveParserBaseSemanticAnalyzer.AggInfo> aggInfos = new ArrayList<HiveParserBaseSemanticAnalyzer.AggInfo>();
            if (hasAggregationTrees) {
                for (HiveParserASTNode value : aggregationTrees.values()) {
                    String aggName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
                    boolean isDistinct = value.getType() == 767;
                    boolean isAllColumns = value.getType() == 768;
                    ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
                    for (int i = 1; i < value.getChildCount(); ++i) {
                        HiveParserASTNode paraExpr = (HiveParserASTNode)value.getChild(i);
                        ExprNodeDesc paraExprNode = this.semanticAnalyzer.genExprNodeDesc(paraExpr, inputRR);
                        aggParameters.add(paraExprNode);
                    }
                    GenericUDAFEvaluator.Mode aggMode = HiveParserUtils.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
                    GenericUDAFEvaluator genericUDAFEvaluator = HiveParserUtils.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns, this.frameworkConfig.getOperatorTable());
                    assert (genericUDAFEvaluator != null);
                    HiveParserBaseSemanticAnalyzer.GenericUDAFInfo udaf = HiveParserUtils.getGenericUDAFInfo(genericUDAFEvaluator, aggMode, aggParameters);
                    String aggAlias = null;
                    if (value.getParent().getType() == 905 && value.getParent().getChildCount() == 2) {
                        aggAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(value.getParent().getChild(1).getText().toLowerCase());
                    }
                    HiveParserBaseSemanticAnalyzer.AggInfo aggInfo = new HiveParserBaseSemanticAnalyzer.AggInfo(aggParameters, udaf.returnType, aggName, isDistinct, isAllColumns, aggAlias);
                    aggInfos.add(aggInfo);
                    String field = aggAlias == null ? HiveParserBaseSemanticAnalyzer.getColumnInternalName(numGroupCols + aggInfos.size() - 1) : aggAlias;
                    outputColNames.add(field);
                    outputRR.putExpression(value, new ColumnInfo(field, aggInfo.getReturnType(), "", false));
                }
            }
            if (groupingSets != null && !groupingSets.isEmpty()) {
                String field = HiveParserBaseSemanticAnalyzer.getColumnInternalName(numGroupCols + aggInfos.size());
                outputColNames.add(field);
                outputRR.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo(field, TypeInfoFactory.longTypeInfo, null, true));
            }
            gbRel = this.genGBRelNode(gbExprNodeDescs, aggInfos, groupingSets, srcRel);
            this.relToHiveColNameCalcitePosMap.put(gbRel, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(outputRR));
            this.relToRowResolver.put(gbRel, outputRR);
        }
        return gbRel;
    }

    private Pair<RelNode, RelNode> genDistSortBy(HiveParserQB qb, RelNode srcRel, boolean outermostOB) throws SemanticException {
        LogicalDistribution res = null;
        RelNode originalInput = null;
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        String destClause = qbp.getClauseNames().iterator().next();
        HiveParserASTNode sortAST = qbp.getSortByForClause(destClause);
        HiveParserASTNode distAST = qbp.getDistributeByForClause(destClause);
        HiveParserASTNode clusterAST = qbp.getClusterByForClause(destClause);
        if (sortAST != null || distAST != null || clusterAST != null) {
            RexNode childRexNode;
            ExprNodeDesc childNodeDesc;
            Map<HiveParserASTNode, ExprNodeDesc> astToExprNodeDesc;
            HiveParserASTNode childAST;
            ArrayList<RexNode> virtualCols = new ArrayList<RexNode>();
            ArrayList<Pair> vcASTAndType = new ArrayList<Pair>();
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
            ArrayList<Integer> distKeys = new ArrayList<Integer>();
            HiveParserRowResolver inputRR = this.relToRowResolver.get(srcRel);
            HiveParserRexNodeConverter converter = new HiveParserRexNodeConverter(this.cluster, srcRel.getRowType(), this.relToHiveColNameCalcitePosMap.get(srcRel), 0, false, this.funcConverter);
            int numSrcFields = srcRel.getRowType().getFieldCount();
            if (clusterAST != null) {
                if (sortAST != null) {
                    throw new SemanticException("Cannot have both CLUSTER BY and SORT BY");
                }
                if (distAST != null) {
                    throw new SemanticException("Cannot have both CLUSTER BY and DISTRIBUTE BY");
                }
                for (Node node : clusterAST.getChildren()) {
                    int fieldIndex;
                    childAST = (HiveParserASTNode)node;
                    astToExprNodeDesc = this.semanticAnalyzer.genAllExprNodeDesc(childAST, inputRR);
                    childNodeDesc = astToExprNodeDesc.get(childAST);
                    if (childNodeDesc == null) {
                        throw new SemanticException("Invalid CLUSTER BY expression: " + childAST.toString());
                    }
                    childRexNode = (RexNode)converter.convert(childNodeDesc).accept((RexVisitor)this.funcConverter);
                    if (childRexNode instanceof RexInputRef) {
                        fieldIndex = ((RexInputRef)childRexNode).getIndex();
                    } else {
                        fieldIndex = numSrcFields + virtualCols.size();
                        virtualCols.add(childRexNode);
                        vcASTAndType.add(new Pair((Object)childAST, (Object)childNodeDesc.getTypeInfo()));
                    }
                    fieldCollations.add(new RelFieldCollation(fieldIndex, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST));
                    distKeys.add(fieldIndex);
                }
            } else {
                if (sortAST != null) {
                    for (Node node : sortAST.getChildren()) {
                        RelFieldCollation.NullDirection nullOrder;
                        int fieldIndex;
                        childAST = (HiveParserASTNode)node;
                        HiveParserASTNode nullOrderAST = (HiveParserASTNode)childAST.getChild(0);
                        HiveParserASTNode fieldAST = (HiveParserASTNode)nullOrderAST.getChild(0);
                        Map<HiveParserASTNode, ExprNodeDesc> astToExprNodeDesc2 = this.semanticAnalyzer.genAllExprNodeDesc(fieldAST, inputRR);
                        ExprNodeDesc fieldNodeDesc = astToExprNodeDesc2.get(fieldAST);
                        if (fieldNodeDesc == null) {
                            throw new SemanticException("Invalid sort by expression: " + fieldAST.toString());
                        }
                        RexNode childRexNode2 = (RexNode)converter.convert(fieldNodeDesc).accept((RexVisitor)this.funcConverter);
                        if (childRexNode2 instanceof RexInputRef) {
                            fieldIndex = ((RexInputRef)childRexNode2).getIndex();
                        } else {
                            fieldIndex = numSrcFields + virtualCols.size();
                            virtualCols.add(childRexNode2);
                            vcASTAndType.add(new Pair((Object)childAST, (Object)fieldNodeDesc.getTypeInfo()));
                        }
                        RelFieldCollation.Direction direction = RelFieldCollation.Direction.DESCENDING;
                        if (childAST.getType() == 982) {
                            direction = RelFieldCollation.Direction.ASCENDING;
                        }
                        if (nullOrderAST.getType() == 830) {
                            nullOrder = RelFieldCollation.NullDirection.FIRST;
                        } else if (nullOrderAST.getType() == 831) {
                            nullOrder = RelFieldCollation.NullDirection.LAST;
                        } else {
                            throw new SemanticException("Unexpected null ordering option: " + nullOrderAST.getType());
                        }
                        fieldCollations.add(new RelFieldCollation(fieldIndex, direction, nullOrder));
                    }
                }
                if (distAST != null) {
                    for (Node node : distAST.getChildren()) {
                        int fieldIndex;
                        childAST = (HiveParserASTNode)node;
                        astToExprNodeDesc = this.semanticAnalyzer.genAllExprNodeDesc(childAST, inputRR);
                        childNodeDesc = astToExprNodeDesc.get(childAST);
                        if (childNodeDesc == null) {
                            throw new SemanticException("Invalid DISTRIBUTE BY expression: " + childAST.toString());
                        }
                        childRexNode = (RexNode)converter.convert(childNodeDesc).accept((RexVisitor)this.funcConverter);
                        if (childRexNode instanceof RexInputRef) {
                            fieldIndex = ((RexInputRef)childRexNode).getIndex();
                        } else {
                            fieldIndex = numSrcFields + virtualCols.size();
                            virtualCols.add(childRexNode);
                            vcASTAndType.add(new Pair((Object)childAST, (Object)childNodeDesc.getTypeInfo()));
                        }
                        distKeys.add(fieldIndex);
                    }
                }
            }
            Preconditions.checkState((!fieldCollations.isEmpty() || !distKeys.isEmpty() ? 1 : 0) != 0, (Object)"Both field collations and dist keys are empty");
            RelNode realInput = srcRel;
            HiveParserRowResolver outputRR = new HiveParserRowResolver();
            if (!virtualCols.isEmpty()) {
                List originalInputRefs = srcRel.getRowType().getFieldList().stream().map(input -> new RexInputRef(input.getIndex(), input.getType())).collect(Collectors.toList());
                HiveParserRowResolver addedProjectRR = new HiveParserRowResolver();
                if (!HiveParserRowResolver.add(addedProjectRR, inputRR)) {
                    throw new SemanticException("Duplicates detected when adding columns to RR: see previous message");
                }
                int vColPos = inputRR.getRowSchema().getSignature().size();
                for (Pair astTypePair : vcASTAndType) {
                    addedProjectRR.putExpression((HiveParserASTNode)astTypePair.getKey(), new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(vColPos), (TypeInfo)astTypePair.getValue(), null, false));
                    ++vColPos;
                }
                realInput = this.genSelectRelNode((List<RexNode>)CompositeList.of(originalInputRefs, virtualCols), addedProjectRR, srcRel);
                if (outermostOB ? !HiveParserRowResolver.add(outputRR, inputRR) : !HiveParserRowResolver.add(outputRR, addedProjectRR)) {
                    throw new SemanticException("Duplicates detected when adding columns to RR: see previous message");
                }
                originalInput = srcRel;
            } else if (!HiveParserRowResolver.add(outputRR, inputRR)) {
                throw new SemanticException("Duplicates detected when adding columns to RR: see previous message");
            }
            RelTraitSet traitSet = this.cluster.traitSet();
            RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollationImpl.of(fieldCollations));
            res = LogicalDistribution.create((RelNode)realInput, (RelCollation)canonizedCollation, distKeys);
            Map<String, Integer> hiveColNameCalcitePosMap = HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(outputRR);
            this.relToRowResolver.put((RelNode)res, outputRR);
            this.relToHiveColNameCalcitePosMap.put((RelNode)res, hiveColNameCalcitePosMap);
        }
        return new Pair(res, originalInput);
    }

    private Pair<Sort, RelNode> genOBLogicalPlan(HiveParserQB qb, RelNode srcRel, boolean outermostOB) throws SemanticException {
        String dest;
        LogicalSort sortRel = null;
        RelNode originalOBInput = null;
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        HiveParserASTNode obAST = qbp.getOrderByForClause(dest = qbp.getClauseNames().iterator().next());
        if (obAST != null) {
            Integer limit = qb.getParseInfo().getDestLimit(dest);
            if (limit == null) {
                String mapRedMode = this.semanticAnalyzer.getConf().getVar(HiveConf.ConfVars.HIVEMAPREDMODE);
                boolean banLargeQuery = Boolean.parseBoolean(this.semanticAnalyzer.getConf().get("hive.strict.checks.large.query", "false"));
                if ("strict".equalsIgnoreCase(mapRedMode) || banLargeQuery) {
                    throw new SemanticException(HiveParserUtils.generateErrorMessage(obAST, "Order by-s without limit"));
                }
            }
            ArrayList<RexNode> virtualCols = new ArrayList<RexNode>();
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
            List obASTExprLst = obAST.getChildren();
            ArrayList<Pair> vcASTAndType = new ArrayList<Pair>();
            HiveParserRowResolver inputRR = this.relToRowResolver.get(srcRel);
            HiveParserRowResolver outputRR = new HiveParserRowResolver();
            HiveParserRexNodeConverter converter = new HiveParserRexNodeConverter(this.cluster, srcRel.getRowType(), this.relToHiveColNameCalcitePosMap.get(srcRel), 0, false, this.funcConverter);
            int numSrcFields = srcRel.getRowType().getFieldCount();
            for (Node node : obASTExprLst) {
                RelFieldCollation.NullDirection nullOrder;
                int fieldIndex;
                HiveParserASTNode obASTExpr = (HiveParserASTNode)node;
                HiveParserASTNode nullOrderASTExpr = (HiveParserASTNode)obASTExpr.getChild(0);
                HiveParserASTNode ref = (HiveParserASTNode)nullOrderASTExpr.getChild(0);
                Map<HiveParserASTNode, ExprNodeDesc> astToExprNodeDesc = this.semanticAnalyzer.genAllExprNodeDesc(ref, inputRR);
                ExprNodeDesc obExprNodeDesc = astToExprNodeDesc.get(ref);
                if (obExprNodeDesc == null) {
                    throw new SemanticException("Invalid order by expression: " + obASTExpr.toString());
                }
                RexNode rexNode = (RexNode)converter.convert(obExprNodeDesc).accept((RexVisitor)this.funcConverter);
                if (rexNode instanceof RexInputRef) {
                    fieldIndex = ((RexInputRef)rexNode).getIndex();
                } else {
                    fieldIndex = numSrcFields + virtualCols.size();
                    virtualCols.add(rexNode);
                    vcASTAndType.add(new Pair((Object)ref, (Object)obExprNodeDesc.getTypeInfo()));
                }
                RelFieldCollation.Direction direction = RelFieldCollation.Direction.DESCENDING;
                if (obASTExpr.getType() == 982) {
                    direction = RelFieldCollation.Direction.ASCENDING;
                }
                if (nullOrderASTExpr.getType() == 830) {
                    nullOrder = RelFieldCollation.NullDirection.FIRST;
                } else if (nullOrderASTExpr.getType() == 831) {
                    nullOrder = RelFieldCollation.NullDirection.LAST;
                } else {
                    throw new SemanticException("Unexpected null ordering option: " + nullOrderASTExpr.getType());
                }
                fieldCollations.add(new RelFieldCollation(fieldIndex, direction, nullOrder));
            }
            RelNode obInputRel = srcRel;
            if (!virtualCols.isEmpty()) {
                List originalInputRefs = srcRel.getRowType().getFieldList().stream().map(input -> new RexInputRef(input.getIndex(), input.getType())).collect(Collectors.toList());
                HiveParserRowResolver obSyntheticProjectRR = new HiveParserRowResolver();
                if (!HiveParserRowResolver.add(obSyntheticProjectRR, inputRR)) {
                    throw new SemanticException("Duplicates detected when adding columns to RR: see previous message");
                }
                int vcolPos = inputRR.getRowSchema().getSignature().size();
                for (Pair astTypePair : vcASTAndType) {
                    obSyntheticProjectRR.putExpression((HiveParserASTNode)astTypePair.getKey(), new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(vcolPos), (TypeInfo)astTypePair.getValue(), null, false));
                    ++vcolPos;
                }
                obInputRel = this.genSelectRelNode((List<RexNode>)CompositeList.of(originalInputRefs, virtualCols), obSyntheticProjectRR, srcRel);
                if (outermostOB ? !HiveParserRowResolver.add(outputRR, inputRR) : !HiveParserRowResolver.add(outputRR, obSyntheticProjectRR)) {
                    throw new SemanticException("Duplicates detected when adding columns to RR: see previous message");
                }
                originalOBInput = srcRel;
            } else if (!HiveParserRowResolver.add(outputRR, inputRR)) {
                throw new SemanticException("Duplicates detected when adding columns to RR: see previous message");
            }
            RelTraitSet traitSet = this.cluster.traitSet();
            RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollationImpl.of(fieldCollations));
            sortRel = LogicalSort.create((RelNode)obInputRel, (RelCollation)canonizedCollation, null, null);
            Map<String, Integer> hiveColNameCalcitePosMap = HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(outputRR);
            this.relToRowResolver.put((RelNode)sortRel, outputRR);
            this.relToHiveColNameCalcitePosMap.put((RelNode)sortRel, hiveColNameCalcitePosMap);
        }
        return new Pair(sortRel, originalOBInput);
    }

    private Sort genLimitLogicalPlan(HiveParserQB qb, RelNode srcRel) throws SemanticException {
        Integer fetch;
        LogicalSort sortRel = null;
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        AbstractMap.SimpleEntry<Integer, Integer> entry = qbp.getDestToLimit().get(qbp.getClauseNames().iterator().next());
        int offset = entry == null ? 0 : entry.getKey();
        Integer n = fetch = entry == null ? null : entry.getValue();
        if (fetch != null) {
            RexLiteral offsetRex = this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(offset));
            RexLiteral fetchRex = this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(fetch.intValue()));
            RelTraitSet traitSet = this.cluster.traitSet();
            RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollations.EMPTY);
            sortRel = LogicalSort.create((RelNode)srcRel, (RelCollation)canonizedCollation, (RexNode)offsetRex, (RexNode)fetchRex);
            HiveParserRowResolver outputRR = new HiveParserRowResolver();
            if (!HiveParserRowResolver.add(outputRR, this.relToRowResolver.get(srcRel))) {
                throw new SemanticException("Duplicates detected when adding columns to RR: see previous message");
            }
            Map<String, Integer> hiveColNameCalcitePosMap = HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(outputRR);
            this.relToRowResolver.put((RelNode)sortRel, outputRR);
            this.relToHiveColNameCalcitePosMap.put((RelNode)sortRel, hiveColNameCalcitePosMap);
        }
        return sortRel;
    }

    private Pair<RexNode, TypeInfo> getWindowRexAndType(HiveParserWindowingSpec.WindowExpressionSpec winExprSpec, RelNode srcRel) throws SemanticException {
        ArrayList<RelDataType> calciteAggFnArgTypes;
        ArrayList<RexNode> calciteAggFnArgs;
        HiveParserRexNodeConverter converter;
        RelDataType calciteAggFnRetType;
        HiveParserBaseSemanticAnalyzer.AggInfo hiveAggInfo;
        if (winExprSpec instanceof HiveParserWindowingSpec.WindowFunctionSpec) {
            HiveParserWindowingSpec.WindowFunctionSpec wFnSpec = (HiveParserWindowingSpec.WindowFunctionSpec)winExprSpec;
            HiveParserASTNode windowProjAst = wFnSpec.getExpression();
            int wndSpecASTIndx = HiveParserBaseSemanticAnalyzer.getWindowSpecIndx(windowProjAst);
            hiveAggInfo = HiveParserBaseSemanticAnalyzer.getHiveAggInfo(windowProjAst, wndSpecASTIndx - 1, this.relToRowResolver.get(srcRel), (HiveParserWindowingSpec.WindowFunctionSpec)winExprSpec, this.semanticAnalyzer, this.frameworkConfig, this.cluster);
            calciteAggFnRetType = HiveParserUtils.toRelDataType(hiveAggInfo.getReturnType(), this.cluster.getTypeFactory());
            Map<String, Integer> posMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
            converter = new HiveParserRexNodeConverter(this.cluster, srcRel.getRowType(), posMap, 0, false, this.funcConverter);
            calciteAggFnArgs = new ArrayList<RexNode>();
            calciteAggFnArgTypes = new ArrayList<RelDataType>();
            for (int i = 0; i < hiveAggInfo.getAggParams().size(); ++i) {
                calciteAggFnArgs.add(converter.convert(hiveAggInfo.getAggParams().get(i)));
                calciteAggFnArgTypes.add(HiveParserUtils.toRelDataType(hiveAggInfo.getAggParams().get(i).getTypeInfo(), this.cluster.getTypeFactory()));
            }
        } else {
            throw new SemanticException("Unsupported window Spec");
        }
        SqlAggFunction calciteAggFn = HiveParserSqlFunctionConverter.getCalciteAggFn(hiveAggInfo.getUdfName(), hiveAggInfo.isDistinct(), calciteAggFnArgTypes, calciteAggFnRetType);
        HiveParserRowResolver inputRR = this.relToRowResolver.get(srcRel);
        HiveParserWindowingSpec.WindowSpec wndSpec = ((HiveParserWindowingSpec.WindowFunctionSpec)winExprSpec).getWindowSpec();
        List<RexNode> partitionKeys = HiveParserBaseSemanticAnalyzer.getPartitionKeys(wndSpec.getPartition(), converter, inputRR, new HiveParserTypeCheckCtx(inputRR, this.frameworkConfig, this.cluster), this.semanticAnalyzer);
        List<RexFieldCollation> orderKeys = HiveParserBaseSemanticAnalyzer.getOrderKeys(wndSpec.getOrder(), converter, inputRR, new HiveParserTypeCheckCtx(inputRR, this.frameworkConfig, this.cluster), this.semanticAnalyzer);
        RexWindowBound lowerBound = HiveParserBaseSemanticAnalyzer.getBound(wndSpec.getWindowFrame().getStart(), this.cluster);
        RexWindowBound upperBound = HiveParserBaseSemanticAnalyzer.getBound(wndSpec.getWindowFrame().getEnd(), this.cluster);
        boolean isRows = wndSpec.getWindowFrame().getWindowType() == HiveParserWindowingSpec.WindowType.ROWS;
        RexNode window = HiveParserUtils.makeOver(this.cluster.getRexBuilder(), calciteAggFnRetType, calciteAggFn, calciteAggFnArgs, partitionKeys, orderKeys, lowerBound, upperBound, isRows, true, false, false, false);
        window = (RexNode)window.accept((RexVisitor)this.funcConverter);
        return new Pair((Object)window, (Object)HiveParserTypeConverter.convert(window.getType()));
    }

    private RelNode genSelectForWindowing(HiveParserQB qb, RelNode srcRel, HashSet<ColumnInfo> newColumns) throws SemanticException {
        HiveParserWindowingSpec wSpec;
        HiveParserWindowingSpec hiveParserWindowingSpec = wSpec = !qb.getAllWindowingSpecs().isEmpty() ? qb.getAllWindowingSpecs().values().iterator().next() : null;
        if (wSpec == null) {
            return null;
        }
        wSpec.validateAndMakeEffective();
        ArrayList<HiveParserWindowingSpec.WindowExpressionSpec> windowExpressions = wSpec.getWindowExpressions();
        if (windowExpressions == null || windowExpressions.isEmpty()) {
            return null;
        }
        HiveParserRowResolver inputRR = this.relToRowResolver.get(srcRel);
        ArrayList<RexNode> projsForWindowSelOp = new ArrayList<RexNode>(HiveParserUtils.getProjsFromBelowAsInputRef(srcRel));
        HiveParserRowResolver outRR = new HiveParserRowResolver();
        if (!HiveParserRowResolver.add(outRR, inputRR)) {
            LOG.warn("Duplicates detected when adding columns to RR: see previous message");
        }
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        String selClauseName = qbp.getClauseNames().iterator().next();
        boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
        for (HiveParserWindowingSpec.WindowExpressionSpec winExprSpec : windowExpressions) {
            if (!qbp.getDestToGroupBy().isEmpty()) {
                winExprSpec.setExpression(HiveParserUtils.rewriteGroupingFunctionAST(HiveParserBaseSemanticAnalyzer.getGroupByForClause(qbp, selClauseName), winExprSpec.getExpression(), !cubeRollupGrpSetPresent));
            }
            if (outRR.getExpression(winExprSpec.getExpression()) != null) continue;
            Pair<RexNode, TypeInfo> rexAndType = this.getWindowRexAndType(winExprSpec, srcRel);
            projsForWindowSelOp.add((RexNode)rexAndType.getKey());
            ColumnInfo oColInfo = new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(projsForWindowSelOp.size()), (TypeInfo)rexAndType.getValue(), null, false);
            outRR.putExpression(winExprSpec.getExpression(), oColInfo);
            newColumns.add(oColInfo);
        }
        return this.genSelectRelNode(projsForWindowSelOp, outRR, srcRel, windowExpressions);
    }

    private RelNode genSelectRelNode(List<RexNode> calciteColLst, HiveParserRowResolver outRR, RelNode srcRel) {
        return this.genSelectRelNode(calciteColLst, outRR, srcRel, null);
    }

    private RelNode genSelectRelNode(List<RexNode> calciteColLst, HiveParserRowResolver outRR, RelNode srcRel, List<HiveParserWindowingSpec.WindowExpressionSpec> windowExpressions) {
        HashSet<String> colNames = new HashSet<String>();
        ArrayList<ColumnInfo> colInfos = outRR.getRowSchema().getSignature();
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, String> windowToAlias = null;
        if (windowExpressions != null) {
            windowToAlias = new HashMap<String, String>();
            for (HiveParserWindowingSpec.WindowExpressionSpec wes : windowExpressions) {
                windowToAlias.put(wes.getExpression().toStringTree().toLowerCase(), wes.getAlias());
            }
        }
        for (int i = 0; i < calciteColLst.size(); ++i) {
            ColumnInfo cInfo = (ColumnInfo)colInfos.get(i);
            String[] qualifiedColNames = outRR.reverseLookup(cInfo.getInternalName());
            String tmpColAlias = qualifiedColNames[1];
            if (tmpColAlias.contains(".") || tmpColAlias.contains(":")) {
                tmpColAlias = cInfo.getInternalName();
            }
            if (tmpColAlias.startsWith("_c")) {
                tmpColAlias = "_o_" + tmpColAlias;
            } else if (windowToAlias != null && windowToAlias.containsKey(tmpColAlias)) {
                tmpColAlias = (String)windowToAlias.get(tmpColAlias);
            }
            int suffix = 1;
            while (colNames.contains(tmpColAlias)) {
                tmpColAlias = qualifiedColNames[1] + suffix;
                ++suffix;
            }
            colNames.add(tmpColAlias);
            columnNames.add(tmpColAlias);
        }
        LogicalProject selRel = LogicalProject.create((RelNode)srcRel, Collections.emptyList(), calciteColLst, columnNames);
        this.relToHiveColNameCalcitePosMap.put((RelNode)selRel, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(outRR));
        this.relToRowResolver.put((RelNode)selRel, outRR);
        return selRel;
    }

    private RelNode genSelectLogicalPlan(HiveParserQB qb, RelNode srcRel, RelNode starSrcRel, Map<String, Integer> outerNameToPos, HiveParserRowResolver outerRR) throws SemanticException {
        String funcName;
        SqlOperator sqlOperator;
        HiveParserRowResolver inputRR;
        boolean isInTransform;
        boolean hintPresent;
        HashSet<ColumnInfo> excludedColumns = new HashSet<ColumnInfo>();
        RelNode selForWindow = this.genSelectForWindowing(qb, srcRel, excludedColumns);
        srcRel = selForWindow == null ? srcRel : selForWindow;
        ArrayList<ExprNodeDesc> exprNodeDescs = new ArrayList<ExprNodeDesc>();
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        String selClauseName = qbp.getClauseNames().iterator().next();
        HiveParserASTNode selExprList = qbp.getSelForClause(selClauseName);
        HiveParserSubQueryUtils.checkForTopLevelSubqueries(selExprList);
        boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
        int posn = 0;
        boolean bl = hintPresent = selExprList.getChild(0).getType() == 344;
        if (hintPresent) {
            ++posn;
        }
        boolean bl2 = isInTransform = selExprList.getChild(posn).getChild(0).getType() == 992;
        if (isInTransform) {
            String msg = "SELECT TRANSFORM is currently not supported in CBO, turn off cbo to use TRANSFORM.";
            throw new SemanticException(msg);
        }
        HiveParserRowResolver outRR = new HiveParserRowResolver();
        Integer pos = 0;
        HiveParserRowResolver starRR = inputRR = this.relToRowResolver.get(srcRel);
        if (starSrcRel != null) {
            starRR = this.relToRowResolver.get(starSrcRel);
        }
        String udtfTableAlias = null;
        SqlOperator udtfOperator = null;
        String genericUDTFName = null;
        ArrayList<String> udtfColAliases = new ArrayList<String>();
        HiveParserASTNode expr = (HiveParserASTNode)selExprList.getChild(posn).getChild(0);
        int exprType = expr.getType();
        if ((exprType == 766 || exprType == 768) && HiveParserUtils.isUDTF(sqlOperator = HiveParserUtils.getAnySqlOperator(funcName = HiveParserTypeCheckProcFactory.DefaultExprProcessor.getFunctionText(expr, true), this.frameworkConfig.getOperatorTable()))) {
            LOG.debug("Found UDTF " + funcName);
            udtfOperator = sqlOperator;
            genericUDTFName = funcName;
            if (!HiveParserUtils.isNative(sqlOperator)) {
                this.semanticAnalyzer.unparseTranslator.addIdentifierTranslation((HiveParserASTNode)expr.getChild(0));
            }
            if (exprType == 768) {
                this.semanticAnalyzer.genColListRegex(".*", null, (HiveParserASTNode)expr.getChild(0), exprNodeDescs, null, inputRR, starRR, pos, outRR, qb.getAliases(), false);
            }
        }
        if (udtfOperator != null) {
            if (selExprList.getChildCount() > 1) {
                throw new SemanticException(HiveParserUtils.generateErrorMessage((HiveParserASTNode)selExprList.getChild(1), ErrorMsg.UDTF_MULTIPLE_EXPR.getMsg()));
            }
            HiveParserASTNode selExpr = (HiveParserASTNode)selExprList.getChild(posn);
            block4: for (int i = 1; i < selExpr.getChildCount(); ++i) {
                HiveParserASTNode selExprChild = (HiveParserASTNode)selExpr.getChild(i);
                switch (selExprChild.getType()) {
                    case 24: {
                        udtfColAliases.add(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(selExprChild.getText().toLowerCase()));
                        this.semanticAnalyzer.unparseTranslator.addIdentifierTranslation(selExprChild);
                        continue block4;
                    }
                    case 953: {
                        assert (selExprChild.getChildCount() == 1);
                        udtfTableAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(selExprChild.getChild(0).getText());
                        qb.addAlias(udtfTableAlias);
                        this.semanticAnalyzer.unparseTranslator.addIdentifierTranslation((HiveParserASTNode)selExprChild.getChild(0));
                        continue block4;
                    }
                    default: {
                        throw new SemanticException("Find invalid token type " + selExprChild.getType() + " in UDTF.");
                    }
                }
            }
            LOG.debug("UDTF table alias is " + udtfTableAlias);
            LOG.debug("UDTF col aliases are " + udtfColAliases);
        }
        HiveParserASTNode exprList = udtfOperator != null ? expr : selExprList;
        int startPos = udtfOperator != null ? posn + 1 : posn;
        ArrayList<String> colAliases = new ArrayList<String>();
        for (int i = startPos; i < exprList.getChildCount(); ++i) {
            ExprNodeColumnDesc colExp;
            String[] altMapping;
            ExprNodeDesc exprDesc;
            String recommended;
            String colAlias;
            String tabAlias;
            boolean hasAsClause;
            colAliases.add(null);
            HiveParserASTNode child = (HiveParserASTNode)exprList.getChild(i);
            boolean bl3 = hasAsClause = child.getChildCount() == 2;
            if (udtfOperator == null && child.getChildCount() > 2) {
                throw new SemanticException(HiveParserUtils.generateErrorMessage((HiveParserASTNode)child.getChild(2), ErrorMsg.INVALID_AS.getMsg()));
            }
            if (udtfOperator != null) {
                tabAlias = null;
                colAlias = this.semanticAnalyzer.getAutogenColAliasPrfxLbl() + i;
                expr = child;
            } else {
                expr = (HiveParserASTNode)child.getChild(0);
                String[] colRef = HiveParserUtils.getColAlias(child, this.semanticAnalyzer.getAutogenColAliasPrfxLbl(), inputRR, this.semanticAnalyzer.autogenColAliasPrfxIncludeFuncName(), i);
                tabAlias = colRef[0];
                colAlias = colRef[1];
                if (hasAsClause) {
                    colAliases.set(colAliases.size() - 1, colAlias);
                    this.semanticAnalyzer.unparseTranslator.addIdentifierTranslation((HiveParserASTNode)child.getChild(1));
                }
            }
            HashMap<HiveParserASTNode, RelNode> subQueryToRelNode = new HashMap<HiveParserASTNode, RelNode>();
            boolean isSubQuery = this.genSubQueryRelNode(qb, expr, srcRel, false, subQueryToRelNode);
            if (isSubQuery) {
                ExprNodeDesc subQueryDesc = this.semanticAnalyzer.genExprNodeDesc(expr, this.relToRowResolver.get(srcRel), outerRR, subQueryToRelNode, false);
                exprNodeDescs.add(subQueryDesc);
                ColumnInfo colInfo = new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(pos), subQueryDesc.getWritableObjectInspector(), tabAlias, false);
                if (outRR.putWithCheck(tabAlias, colAlias, null, colInfo)) continue;
                throw new SemanticException("Cannot add column to RR: " + tabAlias + "." + colAlias + " => " + colInfo + " due to duplication, see previous warnings");
            }
            if (expr.getType() == 652) {
                pos = this.semanticAnalyzer.genColListRegex(".*", expr.getChildCount() == 0 ? null : HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)expr.getChild(0)).toLowerCase(), expr, exprNodeDescs, excludedColumns, inputRR, starRR, pos, outRR, qb.getAliases(), false);
                continue;
            }
            if (expr.getType() == 977 && !hasAsClause && !inputRR.getIsExprResolver() && HiveParserUtils.isRegex(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), this.semanticAnalyzer.getConf())) {
                pos = this.semanticAnalyzer.genColListRegex(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), null, expr, exprNodeDescs, excludedColumns, inputRR, starRR, pos, outRR, qb.getAliases(), true);
                continue;
            }
            if (expr.getType() == 16 && expr.getChild(0).getType() == 977 && inputRR.hasTableAlias(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase())) && !hasAsClause && !inputRR.getIsExprResolver() && HiveParserUtils.isRegex(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), this.semanticAnalyzer.getConf())) {
                pos = this.semanticAnalyzer.genColListRegex(HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase()), expr, exprNodeDescs, excludedColumns, inputRR, starRR, pos, outRR, qb.getAliases(), false);
                continue;
            }
            if (HiveASTParseUtils.containsTokenOfType(expr, 767) && !(srcRel instanceof Aggregate)) {
                throw new SemanticException("Distinct without an aggregation.");
            }
            HiveParserTypeCheckCtx typeCheckCtx = new HiveParserTypeCheckCtx(inputRR, this.frameworkConfig, this.cluster);
            typeCheckCtx.setAllowStatefulFunctions(true);
            if (!qbp.getDestToGroupBy().isEmpty()) {
                expr = HiveParserUtils.rewriteGroupingFunctionAST(HiveParserBaseSemanticAnalyzer.getGroupByForClause(qbp, selClauseName), expr, !cubeRollupGrpSetPresent);
            }
            if ((recommended = this.semanticAnalyzer.recommendName(exprDesc = this.semanticAnalyzer.genExprNodeDesc(expr, inputRR, typeCheckCtx), colAlias)) != null && outRR.get(null, recommended) == null) {
                colAlias = recommended;
            }
            exprNodeDescs.add(exprDesc);
            ColumnInfo colInfo = new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(pos), exprDesc.getWritableObjectInspector(), tabAlias, false);
            colInfo.setSkewedCol(exprDesc instanceof ExprNodeColumnDesc && ((ExprNodeColumnDesc)exprDesc).isSkewedCol());
            outRR.put(tabAlias, colAlias, colInfo);
            if (exprDesc instanceof ExprNodeColumnDesc && (altMapping = inputRR.getAlternateMappings((colExp = (ExprNodeColumnDesc)exprDesc).getColumn())) != null) {
                outRR.put(altMapping[0], altMapping[1], colInfo);
            }
            Integer n = pos;
            Integer n2 = pos = Integer.valueOf(pos + 1);
        }
        ArrayList<RexNode> calciteColLst = new ArrayList<RexNode>();
        HiveParserRexNodeConverter rexNodeConverter = new HiveParserRexNodeConverter(this.cluster, srcRel.getRowType(), outerNameToPos, HiveParserBaseSemanticAnalyzer.buildHiveColNameToInputPosMap(exprNodeDescs, inputRR), this.relToRowResolver.get(srcRel), outerRR, 0, false, this.subqueryId, this.funcConverter);
        for (ExprNodeDesc colExpr : exprNodeDescs) {
            RexNode calciteCol = rexNodeConverter.convert(colExpr);
            calciteCol = (RexNode)this.convertNullLiteral(calciteCol).accept((RexVisitor)this.funcConverter);
            calciteColLst.add(calciteCol);
        }
        RelNode res = udtfOperator != null ? this.genUDTFPlan(udtfOperator, genericUDTFName, udtfTableAlias, udtfColAliases, qb, calciteColLst, outRR.getColumnInfos(), srcRel, true, false) : (HiveParserUtils.isIdentityProject(srcRel, calciteColLst, colAliases) && outerRR != null ? srcRel : this.genSelectRelNode(calciteColLst, outRR, srcRel));
        if (selForWindow != null && selExprList.getToken().getType() == 904) {
            ImmutableBitSet groupSet = ImmutableBitSet.range((int)res.getRowType().getFieldList().size());
            res = LogicalAggregate.create((RelNode)res, (ImmutableBitSet)groupSet, Collections.emptyList(), Collections.emptyList());
            HiveParserRowResolver groupByOutputRowResolver = new HiveParserRowResolver();
            for (int i = 0; i < outRR.getColumnInfos().size(); ++i) {
                ColumnInfo colInfo = outRR.getColumnInfos().get(i);
                ColumnInfo newColInfo = new ColumnInfo(colInfo.getInternalName(), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
                groupByOutputRowResolver.put(colInfo.getTabAlias(), colInfo.getAlias(), newColInfo);
            }
            this.relToHiveColNameCalcitePosMap.put(res, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(groupByOutputRowResolver));
            this.relToRowResolver.put(res, groupByOutputRowResolver);
        }
        return res;
    }

    private RexNode convertNullLiteral(RexNode rexNode) {
        RexLiteral literal;
        if (rexNode instanceof RexLiteral && (literal = (RexLiteral)rexNode).isNull() && literal.getTypeName() == SqlTypeName.NULL) {
            return this.cluster.getRexBuilder().makeNullLiteral(this.cluster.getTypeFactory().createSqlType(SqlTypeName.VARCHAR));
        }
        return rexNode;
    }

    /*
     * WARNING - void declaration
     */
    private RelNode genUDTFPlan(SqlOperator sqlOperator, String genericUDTFName, String outputTableAlias, List<String> colAliases, HiveParserQB qb, List<RexNode> operands, List<ColumnInfo> opColInfos, RelNode input, boolean inSelect, boolean isOuter) throws SemanticException {
        RelNode correlRel;
        void var20_26;
        int n;
        int numOutputCols;
        Preconditions.checkState((!isOuter || !inSelect ? 1 : 0) != 0, (Object)"OUTER is not supported for SELECT UDTF");
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        if (inSelect && !qbp.getDestToGroupBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_GROUP_BY.getMsg());
        }
        if (inSelect && !qbp.getDestToDistributeBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_DISTRIBUTE_BY.getMsg());
        }
        if (inSelect && !qbp.getDestToSortBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_SORT_BY.getMsg());
        }
        if (inSelect && !qbp.getDestToClusterBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_CLUSTER_BY.getMsg());
        }
        if (inSelect && !qbp.getAliasToLateralViews().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_LATERAL_VIEW.getMsg());
        }
        LOG.debug("Table alias: " + outputTableAlias + " Col aliases: " + colAliases);
        RelDataType relDataType = HiveParserUtils.inferReturnTypeForOperands(sqlOperator, operands, this.cluster.getTypeFactory());
        DataType dataType = HiveParserUtils.toDataType(relDataType);
        StructObjectInspector outputOI = (StructObjectInspector)HiveInspectors.getObjectInspector(HiveTypeUtil.toHiveTypeInfo(dataType, false));
        if (outputTableAlias == null) {
            void var16_18;
            Preconditions.checkState((boolean)inSelect, (Object)"Table alias not specified for lateral view");
            String prefix = "select_" + genericUDTFName + "_alias_";
            boolean bl = false;
            while (qb.getAliases().contains((String)prefix + (int)var16_18)) {
                ++var16_18;
            }
            outputTableAlias = (String)prefix + (int)var16_18;
        }
        if (colAliases.isEmpty()) {
            for (StructField structField : outputOI.getAllStructFieldRefs()) {
                colAliases.add(structField.getFieldName());
            }
        }
        if ((numOutputCols = outputOI.getAllStructFieldRefs().size()) != (n = colAliases.size())) {
            throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg("expected " + numOutputCols + " aliases but got " + n));
        }
        ArrayList<ColumnInfo> udtfOutputCols = new ArrayList<ColumnInfo>();
        Iterator<String> colAliasesIter = colAliases.iterator();
        for (StructField structField : outputOI.getAllStructFieldRefs()) {
            String colAlias = colAliasesIter.next();
            assert (colAlias != null);
            ColumnInfo col = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()), outputTableAlias, false);
            udtfOutputCols.add(col);
        }
        HiveParserRowResolver udtfOutRR = new HiveParserRowResolver();
        boolean bl = false;
        while (var20_26 < udtfOutputCols.size()) {
            udtfOutRR.put(outputTableAlias, colAliases.get((int)var20_26), (ColumnInfo)udtfOutputCols.get((int)var20_26));
            ++var20_26;
        }
        RelDataType relDataType2 = HiveParserTypeConverter.getType(this.cluster, udtfOutRR, null);
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        RelDataTypeFactory dtFactory = this.cluster.getRexBuilder().getTypeFactory();
        for (ColumnInfo ci : opColInfos) {
            argTypes.add(HiveParserUtils.toRelDataType(ci.getType(), dtFactory));
        }
        SqlOperator calciteOp = HiveParserSqlFunctionConverter.getCalciteFn(genericUDTFName, argTypes, relDataType2, false);
        RexNode rexNode = this.cluster.getRexBuilder().makeCall(calciteOp, operands);
        TableFunctionConverter udtfConverter = new TableFunctionConverter(this.cluster, input, this.frameworkConfig.getOperatorTable(), this.catalogReader.nameMatcher());
        RexCall convertedCall = (RexCall)rexNode.accept((RexVisitor)udtfConverter);
        SqlOperator convertedOperator = convertedCall.getOperator();
        Preconditions.checkState((boolean)(convertedOperator instanceof SqlUserDefinedTableFunction), (Object)("Expect operator to be " + SqlUserDefinedTableFunction.class.getSimpleName() + ", actually got " + convertedOperator.getClass().getSimpleName()));
        Class<Object[]> elementType = Object[].class;
        LogicalTableFunctionScan tableFunctionScan = LogicalTableFunctionScan.create((RelOptCluster)input.getCluster(), Collections.emptyList(), (RexNode)convertedCall, elementType, (RelDataType)relDataType2, null);
        qb.addAlias(outputTableAlias);
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        Pair<List<CorrelationId>, ImmutableBitSet> correlUse = HiveParserBaseSemanticAnalyzer.getCorrelationUse(convertedCall);
        if (correlUse == null) {
            correlRel = this.plannerContext.createRelBuilder(this.catalogManager.getCurrentCatalog(), this.catalogManager.getCurrentDatabase()).push(input).push((RelNode)tableFunctionScan).join(isOuter ? JoinRelType.LEFT : JoinRelType.INNER, (RexNode)rexBuilder.makeLiteral(true)).build();
        } else {
            if (((List)correlUse.left).size() > 1) {
                tableFunctionScan = DeduplicateCorrelateVariables.go((RexBuilder)rexBuilder, (CorrelationId)((CorrelationId)((List)correlUse.left).get(0)), (Iterable)Util.skip((List)((List)correlUse.left)), (RelNode)tableFunctionScan);
            }
            correlRel = LogicalCorrelate.create((RelNode)input, (RelNode)tableFunctionScan, (CorrelationId)((CorrelationId)((List)correlUse.left).get(0)), (ImmutableBitSet)((ImmutableBitSet)correlUse.right), (JoinRelType)(isOuter ? JoinRelType.LEFT : JoinRelType.INNER));
        }
        this.relToHiveColNameCalcitePosMap.put((RelNode)tableFunctionScan, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(udtfOutRR));
        this.relToRowResolver.put((RelNode)tableFunctionScan, udtfOutRR);
        HiveParserRowResolver correlRR = HiveParserRowResolver.getCombinedRR(this.relToRowResolver.get(input), this.relToRowResolver.get(tableFunctionScan));
        this.relToHiveColNameCalcitePosMap.put(correlRel, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(correlRR));
        this.relToRowResolver.put(correlRel, correlRR);
        if (!inSelect) {
            return correlRel;
        }
        ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
        HiveParserRowResolver projectRR = new HiveParserRowResolver();
        int j = 0;
        for (int i = input.getRowType().getFieldCount(); i < correlRel.getRowType().getFieldCount(); ++i) {
            projects.add(this.cluster.getRexBuilder().makeInputRef(correlRel, i));
            ColumnInfo inputColInfo = correlRR.getRowSchema().getSignature().get(i);
            String colAlias = inputColInfo.getAlias();
            ColumnInfo colInfo = new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(j++), inputColInfo.getObjectInspector(), null, false);
            projectRR.put(null, colAlias, colInfo);
        }
        LogicalProject projectNode = LogicalProject.create((RelNode)correlRel, Collections.emptyList(), projects, (RelDataType)tableFunctionScan.getRowType());
        this.relToHiveColNameCalcitePosMap.put((RelNode)projectNode, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(projectRR));
        this.relToRowResolver.put((RelNode)projectNode, projectRR);
        return projectNode;
    }

    private RelNode genLogicalPlan(HiveParserQBExpr qbexpr) throws SemanticException {
        switch (qbexpr.getOpcode()) {
            case NULLOP: {
                return this.genLogicalPlan(qbexpr.getQB(), false, null, null);
            }
            case UNION: 
            case INTERSECT: 
            case INTERSECTALL: 
            case EXCEPT: 
            case EXCEPTALL: {
                RelNode qbexpr1Ops = this.genLogicalPlan(qbexpr.getQBExpr1());
                RelNode qbexpr2Ops = this.genLogicalPlan(qbexpr.getQBExpr2());
                return this.genSetOpLogicalPlan(qbexpr.getOpcode(), qbexpr.getAlias(), qbexpr.getQBExpr1().getAlias(), qbexpr1Ops, qbexpr.getQBExpr2().getAlias(), qbexpr2Ops);
            }
        }
        return null;
    }

    private RelNode genLogicalPlan(HiveParserQB qb, boolean outerMostQB, Map<String, Integer> outerNameToPosMap, HiveParserRowResolver outerRR) throws SemanticException {
        Sort limitRel;
        HashMap<String, RelNode> aliasToRel = new HashMap<String, RelNode>();
        String reason = HiveParserUtils.canHandleQbForCbo(this.semanticAnalyzer.getQueryProperties());
        if (reason != null) {
            String msg = "CBO can not handle Sub Query because it: " + reason;
            throw new SemanticException(msg);
        }
        for (String subqAlias : qb.getSubqAliases()) {
            HiveParserQBExpr qbexpr = qb.getSubqForAlias(subqAlias);
            RelNode relNode = this.genLogicalPlan(qbexpr);
            aliasToRel.put(subqAlias, relNode);
            if (!qb.getViewToTabSchema().containsKey(subqAlias) || relNode instanceof Project) continue;
            throw new SemanticException("View " + subqAlias + " is corresponding to " + relNode.toString() + ", rather than a Project.");
        }
        for (String tableAlias : qb.getTabAliases()) {
            RelNode op = this.genTableLogicalPlan(tableAlias, qb);
            aliasToRel.put(tableAlias, op);
        }
        if (aliasToRel.isEmpty()) {
            LogicalValues dummySrc = LogicalValues.createOneRow((RelOptCluster)this.cluster);
            aliasToRel.put("_dummy_table", (RelNode)dummySrc);
            HiveParserRowResolver dummyRR = new HiveParserRowResolver();
            dummyRR.put("_dummy_table", "dummy_col", new ColumnInfo(HiveParserBaseSemanticAnalyzer.getColumnInternalName(0), TypeInfoFactory.intTypeInfo, "_dummy_table", false));
            this.relToRowResolver.put((RelNode)dummySrc, dummyRR);
            this.relToHiveColNameCalcitePosMap.put((RelNode)dummySrc, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(dummyRR));
        }
        RelNode res = !qb.getParseInfo().getAliasToLateralViews().isEmpty() ? this.genLateralViewPlan(qb, aliasToRel) : (qb.getParseInfo().getJoinExpr() != null ? this.genJoinLogicalPlan(qb.getParseInfo().getJoinExpr(), aliasToRel) : (RelNode)aliasToRel.values().iterator().next());
        RelNode filterRel = this.genFilterLogicalPlan(qb, res, outerNameToPosMap, outerRR);
        RelNode starSrcRel = res = filterRel == null ? res : filterRel;
        RelNode gbRel = this.genGBLogicalPlan(qb, res);
        res = gbRel == null ? res : gbRel;
        RelNode gbHavingRel = this.genGBHavingLogicalPlan(qb, res);
        res = gbHavingRel == null ? res : gbHavingRel;
        RelNode selectRel = this.genSelectLogicalPlan(qb, res, starSrcRel, outerNameToPosMap, outerRR);
        res = selectRel == null ? res : selectRel;
        Pair<Sort, RelNode> obAndTopProj = this.genOBLogicalPlan(qb, res, outerMostQB);
        Sort orderRel = (Sort)obAndTopProj.getKey();
        RelNode topConstrainingProjRel = (RelNode)obAndTopProj.getValue();
        Object object = res = orderRel == null ? res : orderRel;
        if (orderRel == null) {
            Pair<RelNode, RelNode> distAndTopProj = this.genDistSortBy(qb, res, outerMostQB);
            RelNode distRel = (RelNode)distAndTopProj.getKey();
            topConstrainingProjRel = (RelNode)distAndTopProj.getValue();
            RelNode relNode = res = distRel == null ? res : distRel;
        }
        if ((limitRel = this.genLimitLogicalPlan(qb, res)) != null) {
            if (orderRel != null) {
                HiveParserRowResolver orderRR = (HiveParserRowResolver)this.relToRowResolver.remove(orderRel);
                Map orderColNameToPos = (Map)this.relToHiveColNameCalcitePosMap.remove(orderRel);
                res = LogicalSort.create((RelNode)orderRel.getInput(), (RelCollation)orderRel.collation, (RexNode)limitRel.offset, (RexNode)limitRel.fetch);
                this.relToRowResolver.put(res, orderRR);
                this.relToHiveColNameCalcitePosMap.put(res, orderColNameToPos);
                this.relToRowResolver.remove(limitRel);
                this.relToHiveColNameCalcitePosMap.remove(limitRel);
            } else {
                res = limitRel;
            }
        }
        if (topConstrainingProjRel != null) {
            List<RexNode> originalInputRefs = topConstrainingProjRel.getRowType().getFieldList().stream().map(input -> new RexInputRef(input.getIndex(), input.getType())).collect(Collectors.toList());
            HiveParserRowResolver topConstrainingProjRR = new HiveParserRowResolver();
            if (!HiveParserRowResolver.add(topConstrainingProjRR, this.relToRowResolver.get(topConstrainingProjRel))) {
                LOG.warn("Duplicates detected when adding columns to RR: see previous message");
            }
            res = this.genSelectRelNode(originalInputRefs, topConstrainingProjRR, res);
        }
        if (qb.getParseInfo().getAlias() != null) {
            HiveParserRowResolver rr = this.relToRowResolver.get(res);
            HiveParserRowResolver newRR = new HiveParserRowResolver();
            String alias = qb.getParseInfo().getAlias();
            for (ColumnInfo colInfo : rr.getColumnInfos()) {
                String name = colInfo.getInternalName();
                String[] tmp = rr.reverseLookup(name);
                if ("".equals(tmp[0]) || tmp[1] == null) {
                    tmp[1] = colInfo.getInternalName();
                }
                ColumnInfo newColInfo = new ColumnInfo(colInfo);
                newColInfo.setTabAlias(alias);
                newRR.put(alias, tmp[1], newColInfo);
            }
            this.relToRowResolver.put(res, newRR);
            this.relToHiveColNameCalcitePosMap.put(res, HiveParserBaseSemanticAnalyzer.buildHiveToCalciteColumnMap(newRR));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created Plan for Query Block " + qb.getId());
        }
        this.semanticAnalyzer.setQB(qb);
        return res;
    }

    private RelNode genLateralViewPlan(HiveParserQB qb, Map<String, RelNode> aliasToRel) throws SemanticException {
        Map<String, ArrayList<HiveParserASTNode>> aliasToLateralViews = qb.getParseInfo().getAliasToLateralViews();
        Preconditions.checkArgument((aliasToLateralViews.size() == 1 ? 1 : 0) != 0, (Object)"We only support lateral views for 1 alias");
        Map.Entry<String, ArrayList<HiveParserASTNode>> entry = aliasToLateralViews.entrySet().iterator().next();
        String alias = entry.getKey();
        RelNode res = null;
        List lateralViews = entry.getValue();
        for (HiveParserASTNode lateralView : lateralViews) {
            boolean isOuter;
            Preconditions.checkArgument((lateralView.getChildCount() == 2 ? 1 : 0) != 0);
            boolean bl = isOuter = lateralView.getType() == 807;
            if (res == null) {
                res = aliasToRel.get(alias);
            }
            Preconditions.checkState((res != null ? 1 : 0) != 0, (Object)"Failed to decide LHS table for current lateral view");
            HiveParserRowResolver inputRR = this.relToRowResolver.get(res);
            HiveParserUtils.LateralViewInfo info = HiveParserUtils.extractLateralViewInfo(lateralView, inputRR, this.semanticAnalyzer, this.frameworkConfig, this.cluster);
            HiveParserRexNodeConverter rexNodeConverter = new HiveParserRexNodeConverter(this.cluster, res.getRowType(), this.relToHiveColNameCalcitePosMap.get(res), 0, false, this.funcConverter);
            ArrayList<RexNode> operands = new ArrayList<RexNode>(info.getOperands().size());
            for (ExprNodeDesc exprDesc : info.getOperands()) {
                operands.add((RexNode)rexNodeConverter.convert(exprDesc).accept((RexVisitor)this.funcConverter));
            }
            res = this.genUDTFPlan(info.getSqlOperator(), info.getFuncName(), info.getTabAlias(), info.getColAliases(), qb, operands, info.getOperandColInfos(), res, false, isOuter);
        }
        return res;
    }

    private RelNode genGBHavingLogicalPlan(HiveParserQB qb, RelNode srcRel) throws SemanticException {
        RelNode gbFilter = null;
        HiveParserQBParseInfo qbp = qb.getParseInfo();
        String destClauseName = qbp.getClauseNames().iterator().next();
        HiveParserASTNode havingClause = qbp.getHavingForClause(qbp.getClauseNames().iterator().next());
        if (havingClause != null) {
            if (!(srcRel instanceof Aggregate)) {
                throw new SemanticException("Having clause without any group-by.");
            }
            HiveParserASTNode targetNode = (HiveParserASTNode)havingClause.getChild(0);
            HiveParserBaseSemanticAnalyzer.validateNoHavingReferenceToAlias(qb, targetNode, this.relToRowResolver.get(srcRel), this.semanticAnalyzer);
            if (!qbp.getDestToGroupBy().isEmpty()) {
                boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
                targetNode = HiveParserUtils.rewriteGroupingFunctionAST(HiveParserBaseSemanticAnalyzer.getGroupByForClause(qbp, destClauseName), targetNode, !cubeRollupGrpSetPresent);
            }
            gbFilter = this.genFilterRelNode(qb, targetNode, srcRel, null, null, true);
        }
        return gbFilter;
    }

    public List<String> getDestSchemaForClause(String clause) {
        return this.getQB().getParseInfo().getDestSchemaForClause(clause);
    }
}

