/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.RCFileStorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.StorageFormatFactory;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HiveTableUtil {
    private static final byte HIVE_CONSTRAINT_ENABLE = 4;
    private static final byte HIVE_CONSTRAINT_VALIDATE = 2;
    private static final byte HIVE_CONSTRAINT_RELY = 1;
    private static final StorageFormatFactory storageFormatFactory = new StorageFormatFactory();

    private HiveTableUtil() {
    }

    public static TableSchema createTableSchema(List<FieldSchema> cols, List<FieldSchema> partitionKeys, Set<String> notNullColumns, UniqueConstraint primaryKey) {
        ArrayList<FieldSchema> allCols = new ArrayList<FieldSchema>(cols);
        allCols.addAll(partitionKeys);
        String[] colNames = new String[allCols.size()];
        DataType[] colTypes = new DataType[allCols.size()];
        for (int i = 0; i < allCols.size(); ++i) {
            FieldSchema fs = (FieldSchema)allCols.get(i);
            colNames[i] = fs.getName();
            colTypes[i] = HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString(fs.getType()));
            if (!notNullColumns.contains(colNames[i])) continue;
            colTypes[i] = (DataType)colTypes[i].notNull();
        }
        TableSchema.Builder builder = TableSchema.builder().fields(colNames, colTypes);
        if (primaryKey != null) {
            builder.primaryKey(primaryKey.getName(), primaryKey.getColumns().toArray(new String[0]));
        }
        return builder.build();
    }

    public static List<FieldSchema> createHiveColumns(TableSchema schema) {
        String[] fieldNames = schema.getFieldNames();
        DataType[] fieldTypes = schema.getFieldDataTypes();
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>(fieldNames.length);
        for (int i = 0; i < fieldNames.length; ++i) {
            columns.add(new FieldSchema(fieldNames[i], HiveTypeUtil.toHiveTypeInfo(fieldTypes[i], true).getTypeName(), null));
        }
        return columns;
    }

    public static Partition createHivePartition(String dbName, String tableName, List<String> values, StorageDescriptor sd, Map<String, String> parameters) {
        Partition partition = new Partition();
        partition.setDbName(dbName);
        partition.setTableName(tableName);
        partition.setValues(values);
        partition.setParameters(parameters);
        partition.setSd(sd);
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        partition.setCreateTime(currentTime);
        partition.setLastAccessTime(currentTime);
        return partition;
    }

    public static byte enableConstraint(byte trait) {
        return (byte)(trait | 4);
    }

    public static byte validateConstraint(byte trait) {
        return (byte)(trait | 2);
    }

    public static byte relyConstraint(byte trait) {
        return (byte)(trait | 1);
    }

    public static boolean requireEnableConstraint(byte trait) {
        return (trait & 4) != 0;
    }

    public static boolean requireValidateConstraint(byte trait) {
        return (trait & 2) != 0;
    }

    public static boolean requireRelyConstraint(byte trait) {
        return (trait & 1) != 0;
    }

    public static Optional<String> makePartitionFilter(int partColOffset, List<String> partColNames, List<Expression> expressions, HiveShim hiveShim) {
        ArrayList<String> filters = new ArrayList<String>(expressions.size());
        ExpressionExtractor extractor = new ExpressionExtractor(partColOffset, partColNames, hiveShim);
        for (Expression expression : expressions) {
            String str = (String)expression.accept((ExpressionVisitor)extractor);
            if (str == null) {
                return Optional.empty();
            }
            filters.add(str);
        }
        return Optional.of(String.join((CharSequence)" and ", filters));
    }

    private static void initiateTableFromProperties(org.apache.hadoop.hive.metastore.api.Table hiveTable, Map<String, String> properties, HiveConf hiveConf) {
        HiveTableUtil.extractExternal(hiveTable, properties);
        HiveTableUtil.extractRowFormat(hiveTable.getSd(), properties);
        HiveTableUtil.extractStoredAs(hiveTable.getSd(), properties, hiveConf);
        HiveTableUtil.extractLocation(hiveTable.getSd(), properties);
    }

    private static void extractExternal(org.apache.hadoop.hive.metastore.api.Table hiveTable, Map<String, String> properties) {
        boolean external = Boolean.parseBoolean(properties.remove("hive.is-external"));
        if (external) {
            hiveTable.setTableType(TableType.EXTERNAL_TABLE.toString());
            hiveTable.getParameters().put("EXTERNAL", "TRUE");
        }
    }

    public static void extractLocation(StorageDescriptor sd, Map<String, String> properties) {
        String location = properties.remove("hive.location-uri");
        if (location != null) {
            sd.setLocation(location);
        }
    }

    public static void extractRowFormat(StorageDescriptor sd, Map<String, String> properties) {
        String serdeLib = properties.remove("hive.serde.lib.class.name");
        if (serdeLib != null) {
            sd.getSerdeInfo().setSerializationLib(serdeLib);
        }
        List serdeProps = properties.keySet().stream().filter(p -> p.startsWith("hive.serde.info.prop.")).collect(Collectors.toList());
        for (String prop : serdeProps) {
            String value = properties.remove(prop);
            String key = prop.equals("hive.serde.info.prop.collection.delim") ? "colelction.delim" : prop.substring("hive.serde.info.prop.".length());
            sd.getSerdeInfo().getParameters().put(key, value);
            if (!key.equals("field.delim")) continue;
            sd.getSerdeInfo().getParameters().put("serialization.format", value);
        }
    }

    private static void extractStoredAs(StorageDescriptor sd, Map<String, String> properties, HiveConf hiveConf) {
        String storageFormat = properties.remove("hive.storage.file-format");
        String inputFormat = properties.remove("hive.stored.as.input.format");
        String outputFormat = properties.remove("hive.stored.as.output.format");
        if (storageFormat == null && inputFormat == null) {
            return;
        }
        if (storageFormat != null) {
            HiveTableUtil.setStorageFormat(sd, storageFormat, hiveConf);
        } else {
            sd.setInputFormat(inputFormat);
            sd.setOutputFormat(outputFormat);
        }
    }

    public static void setStorageFormat(StorageDescriptor sd, String format, HiveConf hiveConf) {
        StorageFormatDescriptor storageFormatDescriptor = storageFormatFactory.get(format);
        Preconditions.checkArgument((storageFormatDescriptor != null ? 1 : 0) != 0, (Object)("Unknown storage format " + format));
        sd.setInputFormat(storageFormatDescriptor.getInputFormat());
        sd.setOutputFormat(storageFormatDescriptor.getOutputFormat());
        String serdeLib = storageFormatDescriptor.getSerde();
        if (serdeLib == null && storageFormatDescriptor instanceof RCFileStorageFormatDescriptor) {
            serdeLib = hiveConf.getVar(HiveConf.ConfVars.HIVEDEFAULTRCFILESERDE);
        }
        if (serdeLib != null) {
            sd.getSerdeInfo().setSerializationLib(serdeLib);
        }
    }

    public static void setDefaultStorageFormat(StorageDescriptor sd, HiveConf hiveConf) {
        sd.getSerdeInfo().setSerializationLib(hiveConf.getVar(HiveConf.ConfVars.HIVEDEFAULTSERDE));
        HiveTableUtil.setStorageFormat(sd, hiveConf.getVar(HiveConf.ConfVars.HIVEDEFAULTFILEFORMAT), hiveConf);
    }

    public static void alterColumns(StorageDescriptor sd, CatalogTable catalogTable) {
        List<FieldSchema> allCols = HiveTableUtil.createHiveColumns(catalogTable.getSchema());
        List<FieldSchema> nonPartCols = allCols.subList(0, allCols.size() - catalogTable.getPartitionKeys().size());
        sd.setCols(nonPartCols);
    }

    public static SqlAlterHiveTable.AlterTableOp extractAlterTableOp(Map<String, String> props) {
        String opStr = props.remove("alter.table.op");
        if (opStr != null) {
            return SqlAlterHiveTable.AlterTableOp.valueOf((String)opStr);
        }
        return null;
    }

    public static org.apache.hadoop.hive.metastore.api.Table alterTableViaCatalogBaseTable(ObjectPath tablePath, CatalogBaseTable baseTable, org.apache.hadoop.hive.metastore.api.Table oldHiveTable, HiveConf hiveConf) {
        org.apache.hadoop.hive.metastore.api.Table newHiveTable = HiveTableUtil.instantiateHiveTable(tablePath, baseTable, hiveConf);
        if (!newHiveTable.getSd().isSetLocation()) {
            newHiveTable.getSd().setLocation(oldHiveTable.getSd().getLocation());
        }
        return newHiveTable;
    }

    public static org.apache.hadoop.hive.metastore.api.Table instantiateHiveTable(ObjectPath tablePath, CatalogBaseTable table, HiveConf hiveConf) {
        boolean isView = table instanceof CatalogView;
        org.apache.hadoop.hive.metastore.api.Table hiveTable = Table.getEmptyTable(tablePath.getDatabaseName(), tablePath.getObjectName());
        hiveTable.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        Map<String, String> properties = new HashMap<String, String>(table.getOptions());
        if (table.getComment() != null) {
            properties.put("comment", table.getComment());
        }
        boolean isHiveTable = HiveCatalog.isHiveTable(properties);
        StorageDescriptor sd = hiveTable.getSd();
        HiveTableUtil.setDefaultStorageFormat(sd, hiveConf);
        if (isHiveTable && !isView) {
            HiveTableUtil.initiateTableFromProperties(hiveTable, properties, hiveConf);
            List<FieldSchema> allColumns = HiveTableUtil.createHiveColumns(table.getSchema());
            if (table instanceof CatalogTable) {
                CatalogTable catalogTable = (CatalogTable)table;
                if (catalogTable.isPartitioned()) {
                    int partitionKeySize = catalogTable.getPartitionKeys().size();
                    List<FieldSchema> regularColumns = allColumns.subList(0, allColumns.size() - partitionKeySize);
                    List<FieldSchema> partitionColumns = allColumns.subList(allColumns.size() - partitionKeySize, allColumns.size());
                    sd.setCols(regularColumns);
                    hiveTable.setPartitionKeys(partitionColumns);
                } else {
                    sd.setCols(allColumns);
                    hiveTable.setPartitionKeys(new ArrayList<FieldSchema>());
                }
            } else {
                sd.setCols(allColumns);
            }
            hiveTable.getParameters().putAll(properties);
        } else {
            DescriptorProperties tableSchemaProps = new DescriptorProperties(true);
            tableSchemaProps.putTableSchema("schema", table.getSchema());
            if (table instanceof CatalogTable) {
                tableSchemaProps.putPartitionKeys(((CatalogTable)table).getPartitionKeys());
            }
            properties.putAll(tableSchemaProps.asMap());
            properties = HiveTableUtil.maskFlinkProperties(properties);
            if (isView || !properties.containsKey("flink." + FactoryUtil.CONNECTOR.key()) && !properties.containsKey("flink.connector.type")) {
                properties.put("is_generic", "true");
            }
            hiveTable.setParameters(properties);
        }
        if (isView) {
            hiveTable.setPartitionKeys(new ArrayList<FieldSchema>());
            CatalogView view = (CatalogView)table;
            hiveTable.setViewOriginalText(view.getOriginalQuery());
            hiveTable.setViewExpandedText(view.getExpandedQuery());
            hiveTable.setTableType(TableType.VIRTUAL_VIEW.name());
        }
        return hiveTable;
    }

    private static Map<String, String> maskFlinkProperties(Map<String, String> properties) {
        return properties.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).map(e -> new Tuple2((Object)("flink." + (String)e.getKey()), e.getValue())).collect(Collectors.toMap(t -> (String)t.f0, t -> (String)t.f1));
    }

    public static void checkAcidTable(CatalogTable catalogTable, ObjectPath tablePath) {
        String tableIsTransactional = (String)catalogTable.getOptions().get("transactional");
        if (tableIsTransactional == null) {
            tableIsTransactional = (String)catalogTable.getOptions().get("transactional".toUpperCase());
        }
        if (tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true")) {
            throw new FlinkHiveException(String.format("Reading or writing ACID table %s is not supported.", tablePath));
        }
    }

    public static Configuration getHadoopConfiguration(String hadoopConfDir) {
        if (new File(hadoopConfDir).exists()) {
            File mapredSite;
            File yarnSite;
            File hdfsSite;
            ArrayList<File> possiableConfFiles = new ArrayList<File>();
            File coreSite = new File(hadoopConfDir, "core-site.xml");
            if (coreSite.exists()) {
                possiableConfFiles.add(coreSite);
            }
            if ((hdfsSite = new File(hadoopConfDir, "hdfs-site.xml")).exists()) {
                possiableConfFiles.add(hdfsSite);
            }
            if ((yarnSite = new File(hadoopConfDir, "yarn-site.xml")).exists()) {
                possiableConfFiles.add(yarnSite);
            }
            if ((mapredSite = new File(hadoopConfDir, "mapred-site.xml")).exists()) {
                possiableConfFiles.add(mapredSite);
            }
            if (possiableConfFiles.isEmpty()) {
                return null;
            }
            Configuration hadoopConfiguration = new Configuration();
            for (File confFile : possiableConfFiles) {
                hadoopConfiguration.addResource(new Path(confFile.getAbsolutePath()));
            }
            return hadoopConfiguration;
        }
        return null;
    }

    private static class ExpressionExtractor
    implements ExpressionVisitor<String> {
        private static final Map<FunctionDefinition, String> FUNC_TO_STR = new HashMap<FunctionDefinition, String>();
        private final int partColOffset;
        private final List<String> partColNames;
        private final HiveShim hiveShim;

        ExpressionExtractor(int partColOffset, List<String> partColNames, HiveShim hiveShim) {
            this.partColOffset = partColOffset;
            this.partColNames = partColNames;
            this.hiveShim = hiveShim;
        }

        public String visit(CallExpression call) {
            FunctionDefinition funcDef = call.getFunctionDefinition();
            if (FUNC_TO_STR.containsKey(funcDef)) {
                ArrayList<String> operands = new ArrayList<String>();
                for (Expression child : call.getChildren()) {
                    String operand = (String)child.accept((ExpressionVisitor)this);
                    if (operand == null) {
                        return null;
                    }
                    operands.add(operand);
                }
                return "(" + String.join((CharSequence)(" " + FUNC_TO_STR.get(funcDef) + " "), operands) + ")";
            }
            return null;
        }

        public String visit(ValueLiteralExpression valueLiteral) {
            DataType dataType = valueLiteral.getOutputDataType();
            Object value = valueLiteral.getValueAs(Object.class).orElse(null);
            if (value == null) {
                return "null";
            }
            LogicalTypeRoot typeRoot = dataType.getLogicalType().getTypeRoot();
            if (typeRoot.getFamilies().contains(LogicalTypeFamily.DATETIME)) {
                return null;
            }
            value = HiveInspectors.getConversion(HiveInspectors.getObjectInspector(dataType), dataType.getLogicalType(), this.hiveShim).toHiveObject(value);
            String res = value.toString();
            if (typeRoot == LogicalTypeRoot.CHAR || typeRoot == LogicalTypeRoot.VARCHAR) {
                res = "'" + res.replace("'", "''") + "'";
            }
            return res;
        }

        public String visit(FieldReferenceExpression fieldReference) {
            return this.partColNames.get(fieldReference.getFieldIndex() - this.partColOffset);
        }

        public String visit(TypeLiteralExpression typeLiteral) {
            return typeLiteral.getOutputDataType().toString();
        }

        public String visit(Expression other) {
            return null;
        }

        static {
            FUNC_TO_STR.put((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, "=");
            FUNC_TO_STR.put((FunctionDefinition)BuiltInFunctionDefinitions.NOT_EQUALS, "<>");
            FUNC_TO_STR.put((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, ">");
            FUNC_TO_STR.put((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, ">=");
            FUNC_TO_STR.put((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, "<");
            FUNC_TO_STR.put((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, "<=");
            FUNC_TO_STR.put((FunctionDefinition)BuiltInFunctionDefinitions.AND, "and");
            FUNC_TO_STR.put((FunctionDefinition)BuiltInFunctionDefinitions.OR, "or");
        }
    }
}

