/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStatsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HiveStatsUtil.class);
    private static final int DEFAULT_UNKNOWN_STATS_VALUE = -1;

    private HiveStatsUtil() {
    }

    public static Map<String, CatalogColumnStatisticsDataBase> createCatalogColumnStats(@Nonnull List<ColumnStatisticsObj> hiveColStats, String hiveVersion) {
        Preconditions.checkNotNull(hiveColStats, (String)"hiveColStats can not be null");
        HashMap<String, CatalogColumnStatisticsDataBase> colStats = new HashMap<String, CatalogColumnStatisticsDataBase>();
        for (ColumnStatisticsObj colStatsObj : hiveColStats) {
            CatalogColumnStatisticsDataBase columnStats = HiveStatsUtil.createTableColumnStats(HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString(colStatsObj.getColType())), colStatsObj.getStatsData(), hiveVersion);
            colStats.put(colStatsObj.getColName(), columnStats);
        }
        return colStats;
    }

    public static ColumnStatistics createTableColumnStats(Table hiveTable, Map<String, CatalogColumnStatisticsDataBase> colStats, String hiveVersion) {
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc(true, hiveTable.getDbName(), hiveTable.getTableName());
        return HiveStatsUtil.createHiveColumnStatistics(colStats, hiveTable.getSd(), desc, hiveVersion);
    }

    public static ColumnStatistics createPartitionColumnStats(Partition hivePartition, String partName, Map<String, CatalogColumnStatisticsDataBase> colStats, String hiveVersion) {
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, hivePartition.getDbName(), hivePartition.getTableName());
        desc.setPartName(partName);
        return HiveStatsUtil.createHiveColumnStatistics(colStats, hivePartition.getSd(), desc, hiveVersion);
    }

    private static ColumnStatistics createHiveColumnStatistics(Map<String, CatalogColumnStatisticsDataBase> colStats, StorageDescriptor sd, ColumnStatisticsDesc desc, String hiveVersion) {
        ArrayList<ColumnStatisticsObj> colStatsList = new ArrayList<ColumnStatisticsObj>();
        for (FieldSchema field : sd.getCols()) {
            String hiveColName = field.getName();
            String hiveColType = field.getType();
            CatalogColumnStatisticsDataBase flinkColStat = colStats.get(field.getName());
            if (null == flinkColStat) continue;
            ColumnStatisticsData statsData = HiveStatsUtil.getColumnStatisticsData(HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString(hiveColType)), flinkColStat, hiveVersion);
            ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj(hiveColName, hiveColType, statsData);
            colStatsList.add(columnStatisticsObj);
        }
        return new ColumnStatistics(desc, colStatsList);
    }

    private static CatalogColumnStatisticsDataBase createTableColumnStats(DataType colType, ColumnStatisticsData stats, String hiveVersion) {
        HiveShim hiveShim = HiveShimLoader.loadHiveShim(hiveVersion);
        if (stats.isSetBinaryStats()) {
            BinaryColumnStatsData binaryStats = stats.getBinaryStats();
            return new CatalogColumnStatisticsDataBinary(binaryStats.isSetMaxColLen() ? Long.valueOf(binaryStats.getMaxColLen()) : null, binaryStats.isSetAvgColLen() ? Double.valueOf(binaryStats.getAvgColLen()) : null, binaryStats.isSetNumNulls() ? Long.valueOf(binaryStats.getNumNulls()) : null);
        }
        if (stats.isSetBooleanStats()) {
            BooleanColumnStatsData booleanStats = stats.getBooleanStats();
            return new CatalogColumnStatisticsDataBoolean(booleanStats.isSetNumTrues() ? Long.valueOf(booleanStats.getNumTrues()) : null, booleanStats.isSetNumFalses() ? Long.valueOf(booleanStats.getNumFalses()) : null, booleanStats.isSetNumNulls() ? Long.valueOf(booleanStats.getNumNulls()) : null);
        }
        if (hiveShim.isDateStats(stats)) {
            return hiveShim.toFlinkDateColStats(stats);
        }
        if (stats.isSetDoubleStats()) {
            DoubleColumnStatsData doubleStats = stats.getDoubleStats();
            return new CatalogColumnStatisticsDataDouble(doubleStats.isSetLowValue() ? Double.valueOf(doubleStats.getLowValue()) : null, doubleStats.isSetHighValue() ? Double.valueOf(doubleStats.getHighValue()) : null, doubleStats.isSetNumDVs() ? Long.valueOf(doubleStats.getNumDVs()) : null, doubleStats.isSetNumNulls() ? Long.valueOf(doubleStats.getNumNulls()) : null);
        }
        if (stats.isSetLongStats()) {
            LongColumnStatsData longColStats = stats.getLongStats();
            return new CatalogColumnStatisticsDataLong(longColStats.isSetLowValue() ? Long.valueOf(longColStats.getLowValue()) : null, longColStats.isSetHighValue() ? Long.valueOf(longColStats.getHighValue()) : null, longColStats.isSetNumDVs() ? Long.valueOf(longColStats.getNumDVs()) : null, longColStats.isSetNumNulls() ? Long.valueOf(longColStats.getNumNulls()) : null);
        }
        if (stats.isSetStringStats()) {
            StringColumnStatsData stringStats = stats.getStringStats();
            return new CatalogColumnStatisticsDataString(stringStats.isSetMaxColLen() ? Long.valueOf(stringStats.getMaxColLen()) : null, stringStats.isSetAvgColLen() ? Double.valueOf(stringStats.getAvgColLen()) : null, stringStats.isSetNumDVs() ? Long.valueOf(stringStats.getNumDVs()) : null, stringStats.isSetNumDVs() ? Long.valueOf(stringStats.getNumNulls()) : null);
        }
        if (stats.isSetDecimalStats()) {
            DecimalColumnStatsData decimalStats = stats.getDecimalStats();
            Double max = null;
            if (decimalStats.isSetHighValue()) {
                max = HiveStatsUtil.toHiveDecimal(decimalStats.getHighValue()).doubleValue();
            }
            Double min = null;
            if (decimalStats.isSetLowValue()) {
                min = HiveStatsUtil.toHiveDecimal(decimalStats.getLowValue()).doubleValue();
            }
            Long ndv = decimalStats.isSetNumDVs() ? Long.valueOf(decimalStats.getNumDVs()) : null;
            Long nullCount = decimalStats.isSetNumNulls() ? Long.valueOf(decimalStats.getNumNulls()) : null;
            return new CatalogColumnStatisticsDataDouble(min, max, ndv, nullCount);
        }
        LOG.warn("Flink does not support converting ColumnStatisticsData '{}' for Hive column type '{}' yet.", (Object)stats, (Object)colType);
        return null;
    }

    private static ColumnStatisticsData getColumnStatisticsData(DataType colType, CatalogColumnStatisticsDataBase colStat, String hiveVersion) {
        LogicalTypeRoot type = colType.getLogicalType().getTypeRoot();
        if (type.equals((Object)LogicalTypeRoot.CHAR) || type.equals((Object)LogicalTypeRoot.VARCHAR)) {
            if (colStat instanceof CatalogColumnStatisticsDataString) {
                CatalogColumnStatisticsDataString stringColStat = (CatalogColumnStatisticsDataString)colStat;
                StringColumnStatsData hiveStringColumnStats = new StringColumnStatsData();
                hiveStringColumnStats.clear();
                if (null != stringColStat.getMaxLength()) {
                    hiveStringColumnStats.setMaxColLen(stringColStat.getMaxLength());
                }
                if (null != stringColStat.getAvgLength()) {
                    hiveStringColumnStats.setAvgColLen(stringColStat.getAvgLength());
                }
                if (null != stringColStat.getNullCount()) {
                    hiveStringColumnStats.setNumNulls(stringColStat.getNullCount());
                }
                if (null != stringColStat.getNdv()) {
                    hiveStringColumnStats.setNumDVs(stringColStat.getNdv());
                }
                return ColumnStatisticsData.stringStats(hiveStringColumnStats);
            }
        } else if (type.equals((Object)LogicalTypeRoot.BOOLEAN)) {
            if (colStat instanceof CatalogColumnStatisticsDataBoolean) {
                CatalogColumnStatisticsDataBoolean booleanColStat = (CatalogColumnStatisticsDataBoolean)colStat;
                BooleanColumnStatsData hiveBoolStats = new BooleanColumnStatsData();
                hiveBoolStats.clear();
                if (null != booleanColStat.getTrueCount()) {
                    hiveBoolStats.setNumTrues(booleanColStat.getTrueCount());
                }
                if (null != booleanColStat.getFalseCount()) {
                    hiveBoolStats.setNumFalses(booleanColStat.getFalseCount());
                }
                if (null != booleanColStat.getNullCount()) {
                    hiveBoolStats.setNumNulls(booleanColStat.getNullCount());
                }
                return ColumnStatisticsData.booleanStats(hiveBoolStats);
            }
        } else if (type.equals((Object)LogicalTypeRoot.TINYINT) || type.equals((Object)LogicalTypeRoot.SMALLINT) || type.equals((Object)LogicalTypeRoot.INTEGER) || type.equals((Object)LogicalTypeRoot.BIGINT) || type.equals((Object)LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) || type.equals((Object)LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE) || type.equals((Object)LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE)) {
            if (colStat instanceof CatalogColumnStatisticsDataLong) {
                CatalogColumnStatisticsDataLong longColStat = (CatalogColumnStatisticsDataLong)colStat;
                LongColumnStatsData hiveLongColStats = new LongColumnStatsData();
                hiveLongColStats.clear();
                if (null != longColStat.getMax()) {
                    hiveLongColStats.setHighValue(longColStat.getMax());
                }
                if (null != longColStat.getMin()) {
                    hiveLongColStats.setLowValue(longColStat.getMin());
                }
                if (null != longColStat.getNdv()) {
                    hiveLongColStats.setNumDVs(longColStat.getNdv());
                }
                if (null != longColStat.getNullCount()) {
                    hiveLongColStats.setNumNulls(longColStat.getNullCount());
                }
                return ColumnStatisticsData.longStats(hiveLongColStats);
            }
        } else if (type.equals((Object)LogicalTypeRoot.FLOAT) || type.equals((Object)LogicalTypeRoot.DOUBLE)) {
            if (colStat instanceof CatalogColumnStatisticsDataDouble) {
                CatalogColumnStatisticsDataDouble doubleColumnStatsData = (CatalogColumnStatisticsDataDouble)colStat;
                DoubleColumnStatsData hiveFloatStats = new DoubleColumnStatsData();
                hiveFloatStats.clear();
                if (null != doubleColumnStatsData.getMax()) {
                    hiveFloatStats.setHighValue(doubleColumnStatsData.getMax());
                }
                if (null != doubleColumnStatsData.getMin()) {
                    hiveFloatStats.setLowValue(doubleColumnStatsData.getMin());
                }
                if (null != doubleColumnStatsData.getNullCount()) {
                    hiveFloatStats.setNumNulls(doubleColumnStatsData.getNullCount());
                }
                if (null != doubleColumnStatsData.getNdv()) {
                    hiveFloatStats.setNumDVs(doubleColumnStatsData.getNdv());
                }
                return ColumnStatisticsData.doubleStats(hiveFloatStats);
            }
        } else if (type.equals((Object)LogicalTypeRoot.DATE)) {
            if (colStat instanceof CatalogColumnStatisticsDataDate) {
                HiveShim hiveShim = HiveShimLoader.loadHiveShim(hiveVersion);
                return hiveShim.toHiveDateColStats((CatalogColumnStatisticsDataDate)colStat);
            }
        } else if (type.equals((Object)LogicalTypeRoot.VARBINARY) || type.equals((Object)LogicalTypeRoot.BINARY)) {
            if (colStat instanceof CatalogColumnStatisticsDataBinary) {
                CatalogColumnStatisticsDataBinary binaryColumnStatsData = (CatalogColumnStatisticsDataBinary)colStat;
                BinaryColumnStatsData hiveBinaryColumnStats = new BinaryColumnStatsData();
                hiveBinaryColumnStats.clear();
                if (null != binaryColumnStatsData.getMaxLength()) {
                    hiveBinaryColumnStats.setMaxColLen(binaryColumnStatsData.getMaxLength());
                }
                if (null != binaryColumnStatsData.getAvgLength()) {
                    hiveBinaryColumnStats.setAvgColLen(binaryColumnStatsData.getAvgLength());
                }
                if (null != binaryColumnStatsData.getNullCount()) {
                    hiveBinaryColumnStats.setNumNulls(binaryColumnStatsData.getNullCount());
                }
                return ColumnStatisticsData.binaryStats(hiveBinaryColumnStats);
            }
        } else if (type.equals((Object)LogicalTypeRoot.DECIMAL) && colStat instanceof CatalogColumnStatisticsDataDouble) {
            CatalogColumnStatisticsDataDouble flinkStats = (CatalogColumnStatisticsDataDouble)colStat;
            DecimalColumnStatsData hiveStats = new DecimalColumnStatsData();
            if (flinkStats.getMax() != null) {
                hiveStats.setHighValue(HiveStatsUtil.toThriftDecimal(HiveDecimal.create(BigDecimal.valueOf(flinkStats.getMax()))));
            }
            if (flinkStats.getMin() != null) {
                hiveStats.setLowValue(HiveStatsUtil.toThriftDecimal(HiveDecimal.create(BigDecimal.valueOf(flinkStats.getMin()))));
            }
            if (flinkStats.getNdv() != null) {
                hiveStats.setNumDVs(flinkStats.getNdv());
            }
            if (flinkStats.getNullCount() != null) {
                hiveStats.setNumNulls(flinkStats.getNullCount());
            }
            return ColumnStatisticsData.decimalStats(hiveStats);
        }
        throw new CatalogException(String.format("Flink does not support converting ColumnStats '%s' for Hive column type '%s' yet", colStat, colType));
    }

    private static Decimal toThriftDecimal(HiveDecimal hiveDecimal) {
        Decimal res = new Decimal();
        res.setUnscaled(ByteBuffer.wrap(hiveDecimal.unscaledValue().toByteArray()));
        res.setScale((short)hiveDecimal.scale());
        return res;
    }

    private static HiveDecimal toHiveDecimal(Decimal decimal) {
        return HiveDecimal.create(new BigInteger(decimal.getUnscaled()), (int)decimal.getScale());
    }

    public static int parsePositiveIntStat(Map<String, String> parameters, String key) {
        String value = parameters.get(key);
        if (value == null) {
            return -1;
        }
        int v = Integer.parseInt(value);
        return v > 0 ? v : -1;
    }

    public static long parsePositiveLongStat(Map<String, String> parameters, String key) {
        String value = parameters.get(key);
        if (value == null) {
            return -1L;
        }
        long v = Long.parseLong(value);
        return v > 0L ? v : -1L;
    }
}

