/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.factories;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.factories.HiveCatalogFactoryOptions;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalogFactory
implements CatalogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalogFactory.class);

    public String factoryIdentifier() {
        return "hive";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(HiveCatalogFactoryOptions.DEFAULT_DATABASE);
        options.add(FactoryUtil.PROPERTY_VERSION);
        options.add(HiveCatalogFactoryOptions.HIVE_CONF_DIR);
        options.add(HiveCatalogFactoryOptions.HIVE_VERSION);
        options.add(HiveCatalogFactoryOptions.HADOOP_CONF_DIR);
        return options;
    }

    public Catalog createCatalog(CatalogFactory.Context context) {
        FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)this, (CatalogFactory.Context)context);
        helper.validate();
        return new HiveCatalog(context.getName(), (String)helper.getOptions().get(HiveCatalogFactoryOptions.DEFAULT_DATABASE), (String)helper.getOptions().get(HiveCatalogFactoryOptions.HIVE_CONF_DIR), (String)helper.getOptions().get(HiveCatalogFactoryOptions.HADOOP_CONF_DIR), (String)helper.getOptions().get(HiveCatalogFactoryOptions.HIVE_VERSION));
    }
}

