/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HiveMetastoreClientWrapper
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetastoreClientWrapper.class);
    private final IMetaStoreClient client;
    private final HiveConf hiveConf;
    private final HiveShim hiveShim;

    public HiveMetastoreClientWrapper(HiveConf hiveConf, String hiveVersion) {
        this(hiveConf, HiveShimLoader.loadHiveShim(hiveVersion));
    }

    public HiveMetastoreClientWrapper(HiveConf hiveConf, HiveShim hiveShim) {
        this.hiveConf = (HiveConf)((Object)Preconditions.checkNotNull((Object)((Object)hiveConf), (String)"HiveConf cannot be null"));
        this.hiveShim = hiveShim;
        this.client = HiveCatalog.isEmbeddedMetastore(hiveConf) ? this.createMetastoreClient() : HiveMetaStoreClient.newSynchronizedClient(this.createMetastoreClient());
    }

    @Override
    public void close() {
        this.client.close();
    }

    public List<String> getDatabases(String pattern) throws MetaException, TException {
        return this.client.getDatabases(pattern);
    }

    public List<String> getAllDatabases() throws MetaException, TException {
        return this.client.getAllDatabases();
    }

    public List<String> getAllTables(String databaseName) throws MetaException, TException, UnknownDBException {
        return this.client.getAllTables(databaseName);
    }

    public void dropTable(String databaseName, String tableName) throws MetaException, TException, NoSuchObjectException {
        this.client.dropTable(databaseName, tableName);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTable) throws MetaException, NoSuchObjectException, TException {
        this.client.dropTable(dbName, tableName, deleteData, ignoreUnknownTable);
    }

    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        return this.client.tableExists(databaseName, tableName);
    }

    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        return this.client.getDatabase(name);
    }

    public Table getTable(String databaseName, String tableName) throws MetaException, NoSuchObjectException, TException {
        return this.client.getTable(databaseName, tableName);
    }

    public Partition add_partition(Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.client.add_partition(partition);
    }

    public int add_partitions(List<Partition> partitionList) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.client.add_partitions(partitionList);
    }

    public Partition getPartition(String databaseName, String tableName, List<String> list) throws NoSuchObjectException, MetaException, TException {
        return this.client.getPartition(databaseName, tableName, list);
    }

    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws TException {
        return this.client.getPartitionsByNames(databaseName, tableName, partitionNames);
    }

    public List<String> listPartitionNames(String databaseName, String tableName, short maxPartitions) throws MetaException, TException {
        return this.client.listPartitionNames(databaseName, tableName, maxPartitions);
    }

    public List<String> listPartitionNames(String databaseName, String tableName, List<String> partitionValues, short maxPartitions) throws MetaException, TException, NoSuchObjectException {
        return this.client.listPartitionNames(databaseName, tableName, partitionValues, maxPartitions);
    }

    public void createTable(Table table) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.client.createTable(table);
    }

    public void createDatabase(Database database) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        this.client.createDatabase(database);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreIfNotExists) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.client.dropDatabase(name, deleteData, ignoreIfNotExists);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreIfNotExists, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.client.dropDatabase(name, deleteData, ignoreIfNotExists, cascade);
    }

    public void alterDatabase(String name, Database database) throws NoSuchObjectException, MetaException, TException {
        this.client.alterDatabase(name, database);
    }

    public boolean dropPartition(String databaseName, String tableName, List<String> partitionValues, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.dropPartition(databaseName, tableName, partitionValues, deleteData);
    }

    public void renamePartition(String databaseName, String tableName, List<String> partitionValues, Partition partition) throws InvalidOperationException, MetaException, TException {
        this.client.renamePartition(databaseName, tableName, partitionValues, partition);
    }

    public void createFunction(Function function) throws InvalidObjectException, MetaException, TException {
        this.client.createFunction(function);
    }

    public void alterFunction(String databaseName, String functionName, Function function) throws InvalidObjectException, MetaException, TException {
        this.client.alterFunction(databaseName, functionName, function);
    }

    public void dropFunction(String databaseName, String functionName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        this.client.dropFunction(databaseName, functionName);
    }

    public List<String> getFunctions(String databaseName, String pattern) throws MetaException, TException {
        return this.client.getFunctions(databaseName, pattern);
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String databaseName, String tableName, List<String> columnNames) throws NoSuchObjectException, MetaException, TException {
        return this.client.getTableColumnStatistics(databaseName, tableName, columnNames);
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        return this.client.getPartitionColumnStatistics(dbName, tableName, partNames, colNames);
    }

    public boolean updateTableColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.updateTableColumnStatistics(columnStatistics);
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.updatePartitionColumnStatistics(columnStatistics);
    }

    public List<Partition> listPartitions(String dbName, String tblName, List<String> partVals, short max) throws TException {
        return this.client.listPartitions(dbName, tblName, partVals, max);
    }

    public List<Partition> listPartitions(String dbName, String tblName, short max) throws TException {
        return this.client.listPartitions(dbName, tblName, max);
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String dbName, String tblName, String filter, short max) throws TException {
        return this.client.listPartitionSpecsByFilter(dbName, tblName, filter, max);
    }

    public Set<String> getNotNullColumns(Configuration conf, String dbName, String tableName) {
        return this.hiveShim.getNotNullColumns(this.client, conf, dbName, tableName);
    }

    public Optional<UniqueConstraint> getPrimaryKey(String dbName, String tableName, byte trait) {
        return this.hiveShim.getPrimaryKey(this.client, dbName, tableName, trait);
    }

    public List<String> getViews(String databaseName) throws UnknownDBException, TException {
        return this.hiveShim.getViews(this.client, databaseName);
    }

    private IMetaStoreClient createMetastoreClient() {
        return this.hiveShim.getHiveMetastoreClient(this.hiveConf);
    }

    public Function getFunction(String databaseName, String functionName) throws MetaException, TException {
        try {
            return this.client.getFunction(databaseName, functionName);
        }
        catch (MetaException e) {
            if (e.getCause() instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)e.getCause();
            }
            if (e.getMessage().startsWith(NoSuchObjectException.class.getSimpleName())) {
                throw new NoSuchObjectException(e.getMessage());
            }
            throw e;
        }
    }

    public void alter_table(String databaseName, String tableName, Table table) throws InvalidOperationException, MetaException, TException {
        this.hiveShim.alterTable(this.client, databaseName, tableName, table);
    }

    public void alter_partition(String databaseName, String tableName, Partition partition) throws InvalidOperationException, MetaException, TException {
        this.hiveShim.alterPartition(this.client, databaseName, tableName, partition);
    }

    public void createTableWithConstraints(Table table, Configuration conf, UniqueConstraint pk, List<Byte> pkTraits, List<String> notNullCols, List<Byte> nnTraits) {
        this.hiveShim.createTableWithConstraints(this.client, table, conf, pk, pkTraits, notNullCols, nnTraits);
    }
}

