/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.hadoop.mapred.utils.HadoopUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.hive.HiveDynamicTableFactory;
import org.apache.flink.connectors.hive.HiveTableFactory;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveDatabase;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientFactory;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.factories.HiveCatalogFactoryOptions;
import org.apache.flink.table.catalog.hive.factories.HiveFunctionDefinitionFactory;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.catalog.hive.util.HiveStatsUtil;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.FunctionDefinitionFactory;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends AbstractCatalog {
    public static final String DEFAULT_DB = "default";
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    public static final String HIVE_SITE_FILE = "hive-site.xml";
    private static final String FLINK_SCALA_FUNCTION_PREFIX = "flink:scala:";
    private static final String FLINK_PYTHON_FUNCTION_PREFIX = "flink:python:";
    private final HiveConf hiveConf;
    private final String hiveVersion;
    private final HiveShim hiveShim;
    @VisibleForTesting
    HiveMetastoreClientWrapper client;

    public HiveCatalog(String catalogName, @Nullable String defaultDatabase, @Nullable String hiveConfDir) {
        this(catalogName, defaultDatabase, hiveConfDir, null);
    }

    public HiveCatalog(String catalogName, @Nullable String defaultDatabase, @Nullable String hiveConfDir, String hiveVersion) {
        this(catalogName, defaultDatabase, hiveConfDir, null, hiveVersion);
    }

    public HiveCatalog(String catalogName, @Nullable String defaultDatabase, @Nullable String hiveConfDir, @Nullable String hadoopConfDir, @Nullable String hiveVersion) {
        this(catalogName, defaultDatabase, HiveCatalog.createHiveConf(hiveConfDir, hadoopConfDir), hiveVersion);
    }

    public HiveCatalog(String catalogName, @Nullable String defaultDatabase, @Nullable HiveConf hiveConf, @Nullable String hiveVersion) {
        this(catalogName, defaultDatabase == null ? DEFAULT_DB : defaultDatabase, hiveConf, StringUtils.isNullOrWhitespaceOnly((String)hiveVersion) ? HiveShimLoader.getHiveVersion() : hiveVersion, false);
    }

    @VisibleForTesting
    protected HiveCatalog(String catalogName, String defaultDatabase, @Nullable HiveConf hiveConf, String hiveVersion, boolean allowEmbedded) {
        super(catalogName, defaultDatabase == null ? DEFAULT_DB : defaultDatabase);
        HiveConf hiveConf2 = this.hiveConf = hiveConf == null ? HiveCatalog.createHiveConf(null, null) : hiveConf;
        if (!allowEmbedded) {
            Preconditions.checkArgument((!HiveCatalog.isEmbeddedMetastore(this.hiveConf) ? 1 : 0) != 0, (Object)("Embedded metastore is not allowed. Make sure you have set a valid value for " + HiveConf.ConfVars.METASTOREURIS.toString()));
        }
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)hiveVersion) ? 1 : 0) != 0, (Object)"hiveVersion cannot be null or empty");
        this.hiveVersion = hiveVersion;
        this.hiveShim = HiveShimLoader.loadHiveShim(hiveVersion);
        this.hiveConf.set(HiveCatalogFactoryOptions.HIVE_VERSION.key(), hiveVersion);
        LOG.info("Created HiveCatalog '{}'", (Object)catalogName);
    }

    @VisibleForTesting
    static HiveConf createHiveConf(@Nullable String hiveConfDir, @Nullable String hadoopConfDir) {
        HiveConf hiveConf;
        block22: {
            org.apache.hadoop.conf.Configuration hadoopConf = null;
            if (StringUtils.isNullOrWhitespaceOnly((String)hadoopConfDir)) {
                String possibleHadoopConfPath;
                String[] stringArray = HadoopUtils.possibleHadoopConfPaths(new Configuration());
                int n = stringArray.length;
                for (int i = 0; i < n && (hadoopConf = HiveTableUtil.getHadoopConfiguration(possibleHadoopConfPath = stringArray[i])) == null; ++i) {
                }
            } else {
                hadoopConf = HiveTableUtil.getHadoopConfiguration(hadoopConfDir);
                if (hadoopConf == null) {
                    String possiableUsedConfFiles = "core-site.xml | hdfs-site.xml | yarn-site.xml | mapred-site.xml";
                    throw new CatalogException("Failed to load the hadoop conf from specified path:" + hadoopConfDir, (Throwable)new FileNotFoundException("Please check the path none of the conf files (" + possiableUsedConfFiles + ") exist in the folder."));
                }
            }
            if (hadoopConf == null) {
                hadoopConf = new org.apache.hadoop.conf.Configuration();
            }
            HiveConf.setHiveSiteLocation(null);
            HiveConf.setLoadMetastoreConfig(false);
            HiveConf.setLoadHiveServer2Config(false);
            hiveConf = new HiveConf(hadoopConf, HiveConf.class);
            LOG.info("Setting hive conf dir as {}", (Object)hiveConfDir);
            if (hiveConfDir != null) {
                Path hiveSite = new Path(hiveConfDir, HIVE_SITE_FILE);
                if (!hiveSite.toUri().isAbsolute()) {
                    hiveSite = new Path(new File(hiveSite.toString()).toURI());
                }
                try (FSDataInputStream inputStream = hiveSite.getFileSystem(hadoopConf).open(hiveSite);){
                    hiveConf.addResource((InputStream)inputStream, hiveSite.toString());
                    HiveCatalog.isEmbeddedMetastore(hiveConf);
                    break block22;
                }
                catch (IOException e) {
                    throw new CatalogException("Failed to load hive-site.xml from specified path:" + hiveSite, (Throwable)e);
                }
            }
            URL hiveSite = Thread.currentThread().getContextClassLoader().getResource(HIVE_SITE_FILE);
            if (hiveSite != null) {
                LOG.info("Found {} in classpath: {}", (Object)HIVE_SITE_FILE, (Object)hiveSite);
                hiveConf.addResource(hiveSite);
            }
        }
        return hiveConf;
    }

    @VisibleForTesting
    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    @VisibleForTesting
    public String getHiveVersion() {
        return this.hiveVersion;
    }

    public void open() throws CatalogException {
        if (this.client == null) {
            this.client = HiveMetastoreClientFactory.create(this.hiveConf, this.hiveVersion);
            LOG.info("Connected to Hive metastore");
        }
        if (!this.databaseExists(this.getDefaultDatabase())) {
            throw new CatalogException(String.format("Configured default database %s doesn't exist in catalog %s.", this.getDefaultDatabase(), this.getName()));
        }
    }

    public void close() throws CatalogException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
            LOG.info("Close connection to Hive metastore");
        }
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new HiveDynamicTableFactory(this.hiveConf));
    }

    public Optional<TableFactory> getTableFactory() {
        return Optional.of(new HiveTableFactory());
    }

    public Optional<FunctionDefinitionFactory> getFunctionDefinitionFactory() {
        return Optional.of(new HiveFunctionDefinitionFactory(this.hiveShim));
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        Database hiveDatabase = this.getHiveDatabase(databaseName);
        HashMap<String, String> properties = new HashMap<String, String>(hiveDatabase.getParameters());
        properties.put("hive.database.location-uri", hiveDatabase.getLocationUri());
        return new CatalogDatabaseImpl(properties, hiveDatabase.getDescription());
    }

    public void createDatabase(String databaseName, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        Preconditions.checkNotNull((Object)database, (String)"database cannot be null");
        Map properties = database.getProperties();
        String dbLocationUri = (String)properties.remove("hive.database.location-uri");
        Database hiveDatabase = new Database(databaseName, database.getComment(), dbLocationUri, properties);
        try {
            this.client.createDatabase(hiveDatabase);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new DatabaseAlreadyExistException(this.getName(), hiveDatabase.getName());
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to create database %s", hiveDatabase.getName()), (Throwable)e);
        }
    }

    public void alterDatabase(String databaseName, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        Database hiveDB;
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        Preconditions.checkNotNull((Object)newDatabase, (String)"newDatabase cannot be null");
        try {
            hiveDB = this.getHiveDatabase(databaseName);
        }
        catch (DatabaseNotExistException e) {
            if (!ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.getName(), databaseName);
            }
            return;
        }
        try {
            this.client.alterDatabase(databaseName, HiveCatalog.alterDatabase(hiveDB, newDatabase));
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter database %s", databaseName), (Throwable)e);
        }
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            return this.client.getAllDatabases();
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list all databases in %s", this.getName()), (Throwable)e);
        }
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            return this.client.getDatabase(databaseName) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to determine whether database %s exists or not", databaseName), (Throwable)e);
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        try {
            this.client.dropDatabase(name, true, ignoreIfNotExists, cascade);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.getName(), name);
            }
        }
        catch (InvalidOperationException e) {
            throw new DatabaseNotEmptyException(this.getName(), name);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to drop database %s", name), (Throwable)e);
        }
    }

    @VisibleForTesting
    public Database getHiveDatabase(String databaseName) throws DatabaseNotExistException {
        try {
            return this.client.getDatabase(databaseName);
        }
        catch (NoSuchObjectException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get database %s from %s", databaseName, this.getName()), (Throwable)e);
        }
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        Table hiveTable = this.getHiveTable(tablePath);
        return this.instantiateCatalogTable(hiveTable, this.hiveConf);
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        Preconditions.checkNotNull((Object)table, (String)"table cannot be null");
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
        Table hiveTable = HiveTableUtil.instantiateHiveTable(tablePath, table, this.hiveConf);
        UniqueConstraint pkConstraint = null;
        ArrayList<String> notNullCols = new ArrayList<String>();
        boolean isHiveTable = HiveCatalog.isHiveTable(table.getOptions());
        if (isHiveTable) {
            pkConstraint = table.getSchema().getPrimaryKey().orElse(null);
            String nnColStr = hiveTable.getParameters().remove("hive.not.null.cols");
            if (nnColStr != null) {
                notNullCols.addAll(Arrays.asList(nnColStr.split(";")));
            } else {
                for (int i = 0; i < table.getSchema().getFieldDataTypes().length; ++i) {
                    if (table.getSchema().getFieldDataTypes()[i].getLogicalType().isNullable()) continue;
                    notNullCols.add(table.getSchema().getFieldNames()[i]);
                }
            }
            hiveTable.getParameters().remove(FactoryUtil.CONNECTOR.key());
        }
        try {
            if (pkConstraint != null || !notNullCols.isEmpty()) {
                List<Byte> nnTraits;
                String pkTraitStr = hiveTable.getParameters().remove("hive.pk.constraint.trait");
                byte pkTrait = pkTraitStr == null ? HiveDDLUtils.defaultTrait() : Byte.parseByte(pkTraitStr);
                List<Byte> pkTraits = Collections.nCopies(pkConstraint == null ? 0 : pkConstraint.getColumns().size(), pkTrait);
                String nnTraitsStr = hiveTable.getParameters().remove("hive.not.null.constraint.traits");
                if (nnTraitsStr != null) {
                    String[] traits = nnTraitsStr.split(";");
                    Preconditions.checkArgument((traits.length == notNullCols.size() ? 1 : 0) != 0, (Object)"Number of NOT NULL columns and constraint traits mismatch");
                    nnTraits = Arrays.stream(traits).map(Byte::new).collect(Collectors.toList());
                } else {
                    nnTraits = Collections.nCopies(notNullCols.size(), HiveDDLUtils.defaultTrait());
                }
                this.client.createTableWithConstraints(hiveTable, this.hiveConf, pkConstraint, pkTraits, notNullCols, nnTraits);
            } else {
                this.client.createTable(hiveTable);
            }
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new TableAlreadyExistException(this.getName(), tablePath, (Throwable)e);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to create table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)newTableName) ? 1 : 0) != 0, (Object)"newTableName cannot be null or empty");
        try {
            if (this.tableExists(tablePath)) {
                ObjectPath newPath = new ObjectPath(tablePath.getDatabaseName(), newTableName);
                if (this.tableExists(newPath)) {
                    throw new TableAlreadyExistException(this.getName(), newPath);
                }
                Table table = this.getHiveTable(tablePath);
                table.setTableName(newTableName);
                this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), table);
            } else if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.getName(), tablePath);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to rename table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newCatalogTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Table hiveTable;
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        Preconditions.checkNotNull((Object)newCatalogTable, (String)"newCatalogTable cannot be null");
        try {
            hiveTable = this.getHiveTable(tablePath);
        }
        catch (TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
            return;
        }
        CatalogBaseTable existingTable = this.instantiateCatalogTable(hiveTable, this.hiveConf);
        if (existingTable.getTableKind() != newCatalogTable.getTableKind()) {
            throw new CatalogException(String.format("Table types don't match. Existing table is '%s' and new table is '%s'.", existingTable.getTableKind(), newCatalogTable.getTableKind()));
        }
        boolean isHiveTable = HiveCatalog.isHiveTable(hiveTable.getParameters());
        if (isHiveTable) {
            SqlAlterHiveTable.AlterTableOp op = HiveTableUtil.extractAlterTableOp(newCatalogTable.getOptions());
            if (op == null) {
                hiveTable = HiveTableUtil.alterTableViaCatalogBaseTable(tablePath, newCatalogTable, hiveTable, this.hiveConf);
            } else {
                this.alterTableViaProperties(op, hiveTable, (CatalogTable)newCatalogTable, hiveTable.getParameters(), newCatalogTable.getOptions(), hiveTable.getSd());
            }
        } else {
            hiveTable = HiveTableUtil.alterTableViaCatalogBaseTable(tablePath, newCatalogTable, hiveTable, this.hiveConf);
        }
        HiveCatalog.disallowChangeIsHiveTable(isHiveTable, HiveCatalog.isHiveTable(hiveTable.getParameters()));
        if (isHiveTable) {
            hiveTable.getParameters().remove(FactoryUtil.CONNECTOR.key());
        }
        try {
            this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), hiveTable);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        try {
            this.client.dropTable(tablePath.getDatabaseName(), tablePath.getObjectName(), true, ignoreIfNotExists);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.getName(), tablePath);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to drop table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        try {
            return this.client.getAllTables(databaseName);
        }
        catch (UnknownDBException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list tables in database %s", databaseName), (Throwable)e);
        }
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        try {
            return this.client.getViews(databaseName);
        }
        catch (UnknownDBException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list views in database %s", databaseName), (Throwable)e);
        }
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        try {
            return this.client.tableExists(tablePath.getDatabaseName(), tablePath.getObjectName());
        }
        catch (UnknownDBException e) {
            return false;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to check whether table %s exists or not.", tablePath.getFullName()), (Throwable)e);
        }
    }

    @VisibleForTesting
    public Table getHiveTable(ObjectPath tablePath) throws TableNotExistException {
        try {
            boolean isHiveTable;
            Table table = this.client.getTable(tablePath.getDatabaseName(), tablePath.getObjectName());
            if (table.getParameters().containsKey("is_generic")) {
                isHiveTable = !Boolean.parseBoolean(table.getParameters().remove("is_generic"));
            } else {
                boolean bl = isHiveTable = !table.getParameters().containsKey("flink." + FactoryUtil.CONNECTOR.key()) && !table.getParameters().containsKey("flink.connector.type");
            }
            if (isHiveTable) {
                table.getParameters().put(FactoryUtil.CONNECTOR.key(), "hive");
            }
            return table;
        }
        catch (NoSuchObjectException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get table %s from Hive metastore", tablePath.getFullName()), (Throwable)e);
        }
    }

    private CatalogBaseTable instantiateCatalogTable(Table hiveTable, HiveConf hiveConf) {
        TableSchema tableSchema;
        boolean isView = TableType.valueOf(hiveTable.getTableType()) == TableType.VIRTUAL_VIEW;
        Map<String, String> properties = new HashMap<String, String>(hiveTable.getParameters());
        boolean isHiveTable = HiveCatalog.isHiveTable(properties);
        List<Object> partitionKeys = new ArrayList();
        if (isHiveTable) {
            List<FieldSchema> fields = this.getNonPartitionFields(hiveConf, hiveTable);
            Set<String> notNullColumns = this.client.getNotNullColumns(hiveConf, hiveTable.getDbName(), hiveTable.getTableName());
            Optional<UniqueConstraint> primaryKey = isView ? Optional.empty() : this.client.getPrimaryKey(hiveTable.getDbName(), hiveTable.getTableName(), HiveTableUtil.relyConstraint((byte)0));
            primaryKey.ifPresent(pk -> notNullColumns.addAll(pk.getColumns()));
            tableSchema = HiveTableUtil.createTableSchema(fields, hiveTable.getPartitionKeys(), notNullColumns, primaryKey.orElse(null));
            if (!hiveTable.getPartitionKeys().isEmpty()) {
                partitionKeys = HiveCatalog.getFieldNames(hiveTable.getPartitionKeys());
            }
        } else {
            properties = HiveCatalog.retrieveFlinkProperties(properties);
            DescriptorProperties tableSchemaProps = new DescriptorProperties(true);
            tableSchemaProps.putProperties(properties);
            tableSchema = tableSchemaProps.getOptionalTableSchema("schema").orElseGet(() -> tableSchemaProps.getOptionalTableSchema("generic.table.schema").orElseGet(() -> TableSchema.builder().build()));
            partitionKeys = tableSchemaProps.getPartitionKeys();
            properties = CatalogTableImpl.removeRedundant(properties, (TableSchema)tableSchema, partitionKeys);
        }
        String comment = properties.remove("comment");
        if (isView) {
            return new CatalogViewImpl(hiveTable.getViewOriginalText(), hiveTable.getViewExpandedText(), tableSchema, properties, comment);
        }
        return new CatalogTableImpl(tableSchema, partitionKeys, properties, comment);
    }

    private List<FieldSchema> getNonPartitionFields(HiveConf hiveConf, Table hiveTable) {
        if (org.apache.hadoop.hive.ql.metadata.Table.hasMetastoreBasedSchema(hiveConf, hiveTable.getSd().getSerdeInfo().getSerializationLib())) {
            return hiveTable.getSd().getCols();
        }
        return this.hiveShim.getFieldsFromDeserializer(hiveConf, hiveTable, true);
    }

    private static Map<String, String> retrieveFlinkProperties(Map<String, String> hiveTableParams) {
        return hiveTableParams.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("flink.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("flink.".length()), e -> (String)e.getValue()));
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        try {
            return this.getHivePartition(tablePath, partitionSpec) != null;
        }
        catch (PartitionSpecInvalidException | TableNotExistException | NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get partition %s of table %s", partitionSpec, tablePath), (Throwable)e);
        }
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        Preconditions.checkNotNull((Object)partition, (String)"Partition cannot be null");
        Table hiveTable = this.getHiveTable(tablePath);
        this.ensurePartitionedTable(tablePath, hiveTable);
        boolean isHiveTable = HiveCatalog.isHiveTable(hiveTable.getParameters());
        if (!isHiveTable) {
            throw new CatalogException("Currently only supports partition for hive tables");
        }
        try {
            this.client.add_partition(this.instantiateHivePartition(hiveTable, partitionSpec, partition));
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new PartitionAlreadyExistsException(this.getName(), tablePath, partitionSpec);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to create partition %s of table %s", partitionSpec, tablePath), (Throwable)e);
        }
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        try {
            Table hiveTable = this.getHiveTable(tablePath);
            this.client.dropPartition(tablePath.getDatabaseName(), tablePath.getObjectName(), this.getOrderedFullPartitionValues(partitionSpec, HiveCatalog.getFieldNames(hiveTable.getPartitionKeys()), tablePath), true);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, (Throwable)e);
            }
        }
        catch (PartitionSpecInvalidException | TableNotExistException | MetaException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to drop partition %s of table %s", partitionSpec, tablePath));
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Table hiveTable = this.getHiveTable(tablePath);
        this.ensurePartitionedTable(tablePath, hiveTable);
        try {
            return this.client.listPartitionNames(tablePath.getDatabaseName(), tablePath.getObjectName(), (short)-1).stream().map(HiveCatalog::createPartitionSpec).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list partitions of table %s", tablePath), (Throwable)e);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        Table hiveTable = this.getHiveTable(tablePath);
        this.ensurePartitionedTable(tablePath, hiveTable);
        this.checkValidPartitionSpec(partitionSpec, HiveCatalog.getFieldNames(hiveTable.getPartitionKeys()), tablePath);
        try {
            List<String> partialVals = HiveReflectionUtils.getPvals(this.hiveShim, hiveTable.getPartitionKeys(), partitionSpec.getPartitionSpec());
            return this.client.listPartitionNames(tablePath.getDatabaseName(), tablePath.getObjectName(), partialVals, (short)-1).stream().map(HiveCatalog::createPartitionSpec).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list partitions of table %s", tablePath), (Throwable)e);
        }
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> expressions) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        Table hiveTable = this.getHiveTable(tablePath);
        this.ensurePartitionedTable(tablePath, hiveTable);
        List<String> partColNames = HiveCatalog.getFieldNames(hiveTable.getPartitionKeys());
        Optional<String> filter = HiveTableUtil.makePartitionFilter(this.getNonPartitionFields(this.hiveConf, hiveTable).size(), partColNames, expressions, this.hiveShim);
        if (!filter.isPresent()) {
            throw new UnsupportedOperationException("HiveCatalog is unable to handle the partition filter expressions: " + expressions);
        }
        try {
            PartitionSpecProxy partitionSpec = this.client.listPartitionSpecsByFilter(tablePath.getDatabaseName(), tablePath.getObjectName(), filter.get(), (short)-1);
            ArrayList<CatalogPartitionSpec> res = new ArrayList<CatalogPartitionSpec>(partitionSpec.size());
            PartitionSpecProxy.PartitionIterator partitions = partitionSpec.getPartitionIterator();
            while (partitions.hasNext()) {
                Partition partition = (Partition)partitions.next();
                HashMap<String, String> spec = new HashMap<String, String>();
                for (int i = 0; i < partColNames.size(); ++i) {
                    spec.put(partColNames.get(i), partition.getValues().get(i));
                }
                res.add(new CatalogPartitionSpec(spec));
            }
            return res;
        }
        catch (TException e) {
            throw new UnsupportedOperationException("Failed to list partition by filter from HMS, filter expressions: " + expressions, e);
        }
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        try {
            Partition hivePartition = this.getHivePartition(tablePath, partitionSpec);
            Map<String, String> properties = hivePartition.getParameters();
            properties.put("hive.location-uri", hivePartition.getSd().getLocation());
            String comment = properties.remove("comment");
            return new CatalogPartitionImpl(properties, comment);
        }
        catch (PartitionSpecInvalidException | TableNotExistException | MetaException | NoSuchObjectException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get partition %s of table %s", partitionSpec, tablePath), (Throwable)e);
        }
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        Preconditions.checkNotNull((Object)newPartition, (String)"New partition cannot be null");
        try {
            Table hiveTable = this.getHiveTable(tablePath);
            boolean isHiveTable = HiveCatalog.isHiveTable(hiveTable.getParameters());
            if (!isHiveTable) {
                throw new CatalogException("Currently only supports partition for hive tables");
            }
            Partition hivePartition = this.getHivePartition(hiveTable, partitionSpec);
            if (hivePartition == null) {
                if (ignoreIfNotExists) {
                    return;
                }
                throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
            }
            SqlAlterHiveTable.AlterTableOp op = HiveTableUtil.extractAlterTableOp(newPartition.getProperties());
            if (op == null) {
                throw new CatalogException("alter.table.op is missing for alter table operation");
            }
            this.alterTableViaProperties(op, null, null, hivePartition.getParameters(), newPartition.getProperties(), hivePartition.getSd());
            this.client.alter_partition(tablePath.getDatabaseName(), tablePath.getObjectName(), hivePartition);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, (Throwable)e);
            }
        }
        catch (PartitionSpecInvalidException | TableNotExistException | InvalidOperationException | MetaException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter existing partition with new partition %s of table %s", partitionSpec, tablePath), (Throwable)e);
        }
    }

    private Partition instantiateHivePartition(Table hiveTable, CatalogPartitionSpec partitionSpec, CatalogPartition catalogPartition) throws PartitionSpecInvalidException {
        List<String> partCols = HiveCatalog.getFieldNames(hiveTable.getPartitionKeys());
        List<String> partValues = this.getOrderedFullPartitionValues(partitionSpec, partCols, new ObjectPath(hiveTable.getDbName(), hiveTable.getTableName()));
        for (int i = 0; i < partCols.size(); ++i) {
            if (!StringUtils.isNullOrWhitespaceOnly((String)partValues.get(i))) continue;
            throw new PartitionSpecInvalidException(this.getName(), partCols, new ObjectPath(hiveTable.getDbName(), hiveTable.getTableName()), partitionSpec);
        }
        StorageDescriptor sd = hiveTable.getSd().deepCopy();
        sd.setLocation((String)catalogPartition.getProperties().remove("hive.location-uri"));
        HashMap<String, String> properties = new HashMap<String, String>(catalogPartition.getProperties());
        String comment = catalogPartition.getComment();
        if (comment != null) {
            properties.put("comment", comment);
        }
        return HiveTableUtil.createHivePartition(hiveTable.getDbName(), hiveTable.getTableName(), partValues, sd, properties);
    }

    private void ensurePartitionedTable(ObjectPath tablePath, Table hiveTable) throws TableNotPartitionedException {
        if (!HiveCatalog.isTablePartitioned(hiveTable)) {
            throw new TableNotPartitionedException(this.getName(), tablePath);
        }
    }

    public static List<String> getFieldNames(List<FieldSchema> fieldSchemas) {
        ArrayList<String> names = new ArrayList<String>(fieldSchemas.size());
        for (FieldSchema fs : fieldSchemas) {
            names.add(fs.getName());
        }
        return names;
    }

    private static CatalogPartitionSpec createPartitionSpec(String hivePartitionName) {
        String[] partKeyVals = hivePartitionName.split("/");
        HashMap<String, String> spec = new HashMap<String, String>(partKeyVals.length);
        for (String keyVal : partKeyVals) {
            String[] kv = keyVal.split("=");
            spec.put(PartitionPathUtils.unescapePathName((String)kv[0]), PartitionPathUtils.unescapePathName((String)kv[1]));
        }
        return new CatalogPartitionSpec(spec);
    }

    private List<String> getOrderedFullPartitionValues(CatalogPartitionSpec partitionSpec, List<String> partitionKeys, ObjectPath tablePath) throws PartitionSpecInvalidException {
        Map spec = partitionSpec.getPartitionSpec();
        if (spec.size() != partitionKeys.size()) {
            throw new PartitionSpecInvalidException(this.getName(), partitionKeys, tablePath, partitionSpec);
        }
        ArrayList<String> values = new ArrayList<String>(spec.size());
        for (String key : partitionKeys) {
            if (!spec.containsKey(key)) {
                throw new PartitionSpecInvalidException(this.getName(), partitionKeys, tablePath, partitionSpec);
            }
            values.add((String)spec.get(key));
        }
        return values;
    }

    private void checkValidPartitionSpec(CatalogPartitionSpec partitionSpec, List<String> partitionKeys, ObjectPath tablePath) throws PartitionSpecInvalidException {
        for (String key : partitionSpec.getPartitionSpec().keySet()) {
            if (partitionKeys.contains(key)) continue;
            throw new PartitionSpecInvalidException(this.getName(), partitionKeys, tablePath, partitionSpec);
        }
    }

    private Partition getHivePartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, PartitionSpecInvalidException, TException {
        return this.getHivePartition(this.getHiveTable(tablePath), partitionSpec);
    }

    @VisibleForTesting
    public Partition getHivePartition(Table hiveTable, CatalogPartitionSpec partitionSpec) throws PartitionSpecInvalidException, TException {
        return this.client.getPartition(hiveTable.getDbName(), hiveTable.getTableName(), this.getOrderedFullPartitionValues(partitionSpec, HiveCatalog.getFieldNames(hiveTable.getPartitionKeys()), new ObjectPath(hiveTable.getDbName(), hiveTable.getTableName())));
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null");
        Preconditions.checkNotNull((Object)function, (String)"function cannot be null");
        if (!(function instanceof CatalogFunctionImpl)) {
            throw new CatalogException(String.format("Unsupported catalog function type %s", function.getClass().getName()));
        }
        Function hiveFunction = HiveCatalog.instantiateHiveFunction(functionPath, function);
        try {
            this.client.createFunction(hiveFunction);
        }
        catch (NoSuchObjectException e) {
            throw new DatabaseNotExistException(this.getName(), functionPath.getDatabaseName(), (Throwable)e);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new FunctionAlreadyExistException(this.getName(), functionPath, (Throwable)e);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to create function %s", functionPath.getFullName()), (Throwable)e);
        }
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null");
        Preconditions.checkNotNull((Object)newFunction, (String)"newFunction cannot be null");
        try {
            this.getFunction(functionPath);
            if (!(newFunction instanceof CatalogFunctionImpl)) {
                throw new CatalogException(String.format("Unsupported catalog function type %s", newFunction.getClass().getName()));
            }
            Function hiveFunction = HiveCatalog.instantiateHiveFunction(functionPath, newFunction);
            this.client.alterFunction(functionPath.getDatabaseName(), functionPath.getObjectName(), hiveFunction);
        }
        catch (FunctionNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter function %s", functionPath.getFullName()), (Throwable)e);
        }
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null");
        try {
            this.client.dropFunction(functionPath.getDatabaseName(), functionPath.getObjectName());
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new FunctionNotExistException(this.getName(), functionPath, (Throwable)e);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to drop function %s", functionPath.getFullName()), (Throwable)e);
        }
    }

    public List<String> listFunctions(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        try {
            return this.client.getFunctions(databaseName, ".*");
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list functions in database %s", databaseName), (Throwable)e);
        }
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null or empty");
        try {
            Function function = this.client.getFunction(functionPath.getDatabaseName(), functionPath.getObjectName());
            if (function.getClassName().startsWith(FLINK_PYTHON_FUNCTION_PREFIX)) {
                return new CatalogFunctionImpl(function.getClassName().substring(FLINK_PYTHON_FUNCTION_PREFIX.length()), FunctionLanguage.PYTHON);
            }
            if (function.getClassName().startsWith(FLINK_SCALA_FUNCTION_PREFIX)) {
                return new CatalogFunctionImpl(function.getClassName().substring(FLINK_SCALA_FUNCTION_PREFIX.length()), FunctionLanguage.SCALA);
            }
            if (function.getClassName().startsWith("flink:")) {
                return new CatalogFunctionImpl(function.getClassName().substring("flink:".length()));
            }
            return new CatalogFunctionImpl(function.getClassName());
        }
        catch (NoSuchObjectException e) {
            throw new FunctionNotExistException(this.getName(), functionPath, (Throwable)e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get function %s", functionPath.getFullName()), (Throwable)e);
        }
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null or empty");
        try {
            return this.client.getFunction(functionPath.getDatabaseName(), functionPath.getObjectName()) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to check whether function %s exists or not", functionPath.getFullName()), (Throwable)e);
        }
    }

    private static Function instantiateHiveFunction(ObjectPath functionPath, CatalogFunction function) {
        String functionClassName;
        if (function.getFunctionLanguage() == FunctionLanguage.JAVA) {
            functionClassName = function.getClassName();
        } else if (function.getFunctionLanguage() == FunctionLanguage.SCALA) {
            functionClassName = FLINK_SCALA_FUNCTION_PREFIX + function.getClassName();
        } else if (function.getFunctionLanguage() == FunctionLanguage.PYTHON) {
            functionClassName = FLINK_PYTHON_FUNCTION_PREFIX + function.getClassName();
        } else {
            throw new UnsupportedOperationException("HiveCatalog supports only creating JAVA/SCALA or PYTHON based function for now");
        }
        return new Function(functionPath.getObjectName().trim().toLowerCase(), functionPath.getDatabaseName(), functionClassName, null, PrincipalType.GROUP, (int)(System.currentTimeMillis() / 1000L), FunctionType.JAVA, new ArrayList<ResourceUri>());
    }

    private static boolean isTablePartitioned(Table hiveTable) {
        return hiveTable.getPartitionKeysSize() != 0;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            Table hiveTable = this.getHiveTable(tablePath);
            if (!HiveCatalog.isTablePartitioned(hiveTable) && this.hiveVersion.compareTo("1.2.1") < 0) {
                throw new CatalogException("Alter table stats is not supported in Hive version " + this.hiveVersion);
            }
            if (this.statsChanged(tableStatistics, hiveTable.getParameters())) {
                this.updateStats(tableStatistics, hiveTable.getParameters());
                this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), hiveTable);
            }
        }
        catch (TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter table stats of table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
        try {
            Table hiveTable = this.getHiveTable(tablePath);
            if (HiveCatalog.isTablePartitioned(hiveTable)) {
                throw new TablePartitionedException(this.getName(), tablePath);
            }
            this.client.updateTableColumnStatistics(HiveStatsUtil.createTableColumnStats(hiveTable, columnStatistics.getColumnStatisticsData(), this.hiveVersion));
        }
        catch (TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter table column stats of table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    private boolean statsChanged(CatalogTableStatistics newTableStats, Map<String, String> parameters) {
        return newTableStats.getRowCount() != HiveStatsUtil.parsePositiveLongStat(parameters, "numRows") || newTableStats.getTotalSize() != HiveStatsUtil.parsePositiveLongStat(parameters, "totalSize") || newTableStats.getFileCount() != HiveStatsUtil.parsePositiveIntStat(parameters, "numFiles") || newTableStats.getRawDataSize() != HiveStatsUtil.parsePositiveLongStat(parameters, "numFiles");
    }

    private void updateStats(CatalogTableStatistics newTableStats, Map<String, String> parameters) {
        parameters.put("numRows", String.valueOf(newTableStats.getRowCount()));
        parameters.put("totalSize", String.valueOf(newTableStats.getTotalSize()));
        parameters.put("numFiles", String.valueOf(newTableStats.getFileCount()));
        parameters.put("rawDataSize", String.valueOf(newTableStats.getRawDataSize()));
    }

    private static CatalogTableStatistics createCatalogTableStatistics(Map<String, String> parameters) {
        return new CatalogTableStatistics(HiveStatsUtil.parsePositiveLongStat(parameters, "numRows"), HiveStatsUtil.parsePositiveIntStat(parameters, "numFiles"), HiveStatsUtil.parsePositiveLongStat(parameters, "totalSize"), HiveStatsUtil.parsePositiveLongStat(parameters, "rawDataSize"));
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        try {
            Partition hivePartition = this.getHivePartition(tablePath, partitionSpec);
            if (this.statsChanged(partitionStatistics, hivePartition.getParameters())) {
                this.updateStats(partitionStatistics, hivePartition.getParameters());
                this.client.alter_partition(tablePath.getDatabaseName(), tablePath.getObjectName(), hivePartition);
            }
        }
        catch (PartitionSpecInvalidException | TableNotExistException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter table stats of table %s 's partition %s", tablePath.getFullName(), String.valueOf(partitionSpec)), (Throwable)e);
        }
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        try {
            Partition hivePartition = this.getHivePartition(tablePath, partitionSpec);
            Table hiveTable = this.getHiveTable(tablePath);
            String partName = this.getEscapedPartitionName(tablePath, partitionSpec, hiveTable);
            this.client.updatePartitionColumnStatistics(HiveStatsUtil.createPartitionColumnStats(hivePartition, partName, columnStatistics.getColumnStatisticsData(), this.hiveVersion));
        }
        catch (PartitionSpecInvalidException | TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter table column stats of table %s 's partition %s", tablePath.getFullName(), String.valueOf(partitionSpec)), (Throwable)e);
        }
    }

    private String getEscapedPartitionName(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, Table hiveTable) throws PartitionSpecInvalidException {
        List<String> partitionCols = HiveCatalog.getFieldNames(hiveTable.getPartitionKeys());
        List<String> partitionVals = this.getOrderedFullPartitionValues(partitionSpec, partitionCols, tablePath);
        String defaultPartName = this.getHiveConf().getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        return FileUtils.makePartName(partitionCols, partitionVals, defaultPartName);
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Table hiveTable = this.getHiveTable(tablePath);
        if (!HiveCatalog.isTablePartitioned(hiveTable)) {
            return HiveCatalog.createCatalogTableStatistics(hiveTable.getParameters());
        }
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Table hiveTable = this.getHiveTable(tablePath);
        try {
            if (!HiveCatalog.isTablePartitioned(hiveTable)) {
                List<ColumnStatisticsObj> columnStatisticsObjs = this.client.getTableColumnStatistics(hiveTable.getDbName(), hiveTable.getTableName(), HiveCatalog.getFieldNames(hiveTable.getSd().getCols()));
                return new CatalogColumnStatistics(HiveStatsUtil.createCatalogColumnStats(columnStatisticsObjs, this.hiveVersion));
            }
            return CatalogColumnStatistics.UNKNOWN;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get table column stats of table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        try {
            Partition partition = this.getHivePartition(tablePath, partitionSpec);
            return HiveCatalog.createCatalogTableStatistics(partition.getParameters());
        }
        catch (PartitionSpecInvalidException | TableNotExistException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get partition stats of table %s 's partition %s", tablePath.getFullName(), String.valueOf(partitionSpec)), (Throwable)e);
        }
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        try {
            Partition partition = this.getHivePartition(tablePath, partitionSpec);
            Table hiveTable = this.getHiveTable(tablePath);
            String partName = this.getEscapedPartitionName(tablePath, partitionSpec, hiveTable);
            ArrayList<String> partNames = new ArrayList<String>();
            partNames.add(partName);
            Map<String, List<ColumnStatisticsObj>> partitionColumnStatistics = this.client.getPartitionColumnStatistics(partition.getDbName(), partition.getTableName(), partNames, HiveCatalog.getFieldNames(partition.getSd().getCols()));
            List<ColumnStatisticsObj> columnStatisticsObjs = partitionColumnStatistics.get(partName);
            if (columnStatisticsObjs != null && !columnStatisticsObjs.isEmpty()) {
                return new CatalogColumnStatistics(HiveStatsUtil.createCatalogColumnStats(columnStatisticsObjs, this.hiveVersion));
            }
            return CatalogColumnStatistics.UNKNOWN;
        }
        catch (PartitionSpecInvalidException | TableNotExistException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get table stats of table %s 's partition %s", tablePath.getFullName(), String.valueOf(partitionSpec)), (Throwable)e);
        }
    }

    @VisibleForTesting
    public static boolean isHiveTable(Map<String, String> properties) {
        return "hive".equalsIgnoreCase(properties.get(FactoryUtil.CONNECTOR.key()));
    }

    private static void disallowChangeIsHiveTable(boolean oldIsHive, boolean newIsHive) {
        Preconditions.checkArgument((oldIsHive == newIsHive ? 1 : 0) != 0, (Object)"Changing whether a table is Hive table is not allowed");
    }

    private void alterTableViaProperties(SqlAlterHiveTable.AlterTableOp alterOp, Table hiveTable, CatalogTable catalogTable, Map<String, String> oldProps, Map<String, String> newProps, StorageDescriptor sd) {
        switch (alterOp) {
            case CHANGE_TBL_PROPS: {
                oldProps.putAll(newProps);
                break;
            }
            case CHANGE_LOCATION: {
                HiveTableUtil.extractLocation(sd, newProps);
                break;
            }
            case CHANGE_FILE_FORMAT: {
                String newFileFormat = newProps.remove("hive.storage.file-format");
                HiveTableUtil.setStorageFormat(sd, newFileFormat, this.hiveConf);
                break;
            }
            case CHANGE_SERDE_PROPS: {
                HiveTableUtil.extractRowFormat(sd, newProps);
                break;
            }
            case ALTER_COLUMNS: {
                if (hiveTable == null) {
                    throw new CatalogException("ALTER COLUMNS cannot be done with ALTER PARTITION");
                }
                HiveTableUtil.alterColumns(hiveTable.getSd(), catalogTable);
                boolean cascade = Boolean.parseBoolean(newProps.remove("alter.column.cascade"));
                if (!cascade) break;
                if (!HiveCatalog.isTablePartitioned(hiveTable)) {
                    throw new CatalogException("ALTER COLUMNS CASCADE for non-partitioned table");
                }
                try {
                    for (CatalogPartitionSpec spec : this.listPartitions(new ObjectPath(hiveTable.getDbName(), hiveTable.getTableName()))) {
                        Partition partition = this.getHivePartition(hiveTable, spec);
                        HiveTableUtil.alterColumns(partition.getSd(), catalogTable);
                        this.client.alter_partition(hiveTable.getDbName(), hiveTable.getTableName(), partition);
                    }
                    break;
                }
                catch (Exception e) {
                    throw new CatalogException("Failed to cascade add/replace columns to partitions", (Throwable)e);
                }
            }
            default: {
                throw new CatalogException("Unsupported alter table operation " + alterOp);
            }
        }
    }

    @VisibleForTesting
    public static boolean isEmbeddedMetastore(HiveConf hiveConf) {
        return StringUtils.isNullOrWhitespaceOnly((String)hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
    }

    private static Database alterDatabase(Database hiveDB, CatalogDatabase newDatabase) {
        Map newParams = newDatabase.getProperties();
        String opStr = (String)newParams.remove("hive.alter.database.op");
        if (opStr == null) {
            opStr = SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_PROPS.name();
        }
        String newLocation = (String)newParams.remove("hive.database.location-uri");
        SqlAlterHiveDatabase.AlterHiveDatabaseOp op = SqlAlterHiveDatabase.AlterHiveDatabaseOp.valueOf((String)opStr);
        block0 : switch (op) {
            case CHANGE_PROPS: {
                hiveDB.setParameters(newParams);
                break;
            }
            case CHANGE_LOCATION: {
                hiveDB.setLocationUri(newLocation);
                break;
            }
            case CHANGE_OWNER: {
                String ownerName = (String)newParams.remove("hive.database.owner.name");
                String ownerType = (String)newParams.remove("hive.database.owner.type");
                hiveDB.setOwnerName(ownerName);
                switch (ownerType) {
                    case "role": {
                        hiveDB.setOwnerType(PrincipalType.ROLE);
                        break block0;
                    }
                    case "user": {
                        hiveDB.setOwnerType(PrincipalType.USER);
                        break block0;
                    }
                }
                throw new CatalogException("Unsupported database owner type: " + ownerType);
            }
            default: {
                throw new CatalogException("Unsupported alter database op:" + opStr);
            }
        }
        if (hiveDB.getParameters() != null) {
            hiveDB.getParameters().remove("is_generic");
        }
        return hiveDB;
    }
}

