/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.nohive.vector;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.flink.orc.nohive.vector.OrcNoHiveBytesVector;
import org.apache.flink.orc.nohive.vector.OrcNoHiveDecimalVector;
import org.apache.flink.orc.nohive.vector.OrcNoHiveDoubleVector;
import org.apache.flink.orc.nohive.vector.OrcNoHiveLongVector;
import org.apache.flink.orc.nohive.vector.OrcNoHiveTimestampVector;
import org.apache.flink.table.runtime.functions.SqlDateTimeUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;

public abstract class AbstractOrcNoHiveVector
implements org.apache.flink.table.data.vector.ColumnVector {
    private ColumnVector orcVector;

    AbstractOrcNoHiveVector(ColumnVector orcVector) {
        this.orcVector = orcVector;
    }

    public boolean isNullAt(int i) {
        return !this.orcVector.noNulls && this.orcVector.isNull[this.orcVector.isRepeating ? 0 : i];
    }

    public static org.apache.flink.table.data.vector.ColumnVector createFlinkVector(ColumnVector vector) {
        if (vector instanceof LongColumnVector) {
            return new OrcNoHiveLongVector((LongColumnVector)vector);
        }
        if (vector instanceof DoubleColumnVector) {
            return new OrcNoHiveDoubleVector((DoubleColumnVector)vector);
        }
        if (vector instanceof BytesColumnVector) {
            return new OrcNoHiveBytesVector((BytesColumnVector)vector);
        }
        if (vector instanceof DecimalColumnVector) {
            return new OrcNoHiveDecimalVector((DecimalColumnVector)vector);
        }
        if (vector instanceof TimestampColumnVector) {
            return new OrcNoHiveTimestampVector((TimestampColumnVector)vector);
        }
        throw new UnsupportedOperationException("Unsupport vector: " + vector.getClass().getName());
    }

    public static org.apache.flink.table.data.vector.ColumnVector createFlinkVectorFromConstant(LogicalType type, Object value, int batchSize) {
        return AbstractOrcNoHiveVector.createFlinkVector(AbstractOrcNoHiveVector.createHiveVectorFromConstant(type, value, batchSize));
    }

    private static ColumnVector createHiveVectorFromConstant(LogicalType type, Object value, int batchSize) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return AbstractOrcNoHiveVector.createBytesVector(batchSize, value);
            }
            case BOOLEAN: {
                return AbstractOrcNoHiveVector.createLongVector(batchSize, (Boolean)value != false ? 1 : 0);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return AbstractOrcNoHiveVector.createLongVector(batchSize, value);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return AbstractOrcNoHiveVector.createDecimalVector(batchSize, decimalType.getPrecision(), decimalType.getScale(), value);
            }
            case FLOAT: 
            case DOUBLE: {
                return AbstractOrcNoHiveVector.createDoubleVector(batchSize, value);
            }
            case DATE: {
                if (value instanceof LocalDate) {
                    value = Date.valueOf((LocalDate)value);
                }
                return AbstractOrcNoHiveVector.createLongVector(batchSize, SqlDateTimeUtils.dateToInternal((Date)((Date)value)));
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return AbstractOrcNoHiveVector.createTimestampVector(batchSize, value);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static LongColumnVector createLongVector(int batchSize, Object value) {
        LongColumnVector lcv = new LongColumnVector(batchSize);
        if (value == null) {
            lcv.noNulls = false;
            lcv.isNull[0] = true;
            lcv.isRepeating = true;
        } else {
            lcv.fill(((Number)value).longValue());
            lcv.isNull[0] = false;
        }
        return lcv;
    }

    private static BytesColumnVector createBytesVector(int batchSize, Object value) {
        BytesColumnVector bcv = new BytesColumnVector(batchSize);
        if (value == null) {
            bcv.noNulls = false;
            bcv.isNull[0] = true;
            bcv.isRepeating = true;
        } else {
            byte[] bytes = value instanceof byte[] ? (byte[])value : value.toString().getBytes(StandardCharsets.UTF_8);
            bcv.initBuffer(bytes.length);
            bcv.fill(bytes);
            bcv.isNull[0] = false;
        }
        return bcv;
    }

    private static DecimalColumnVector createDecimalVector(int batchSize, int precision, int scale, Object value) {
        DecimalColumnVector dv = new DecimalColumnVector(batchSize, precision, scale);
        if (value == null) {
            dv.noNulls = false;
            dv.isNull[0] = true;
            dv.isRepeating = true;
        } else {
            dv.set(0, value instanceof HiveDecimal ? (HiveDecimal)value : HiveDecimal.create((BigDecimal)((BigDecimal)value)));
            dv.isRepeating = true;
            dv.isNull[0] = false;
        }
        return dv;
    }

    private static DoubleColumnVector createDoubleVector(int batchSize, Object value) {
        DoubleColumnVector dcv = new DoubleColumnVector(batchSize);
        if (value == null) {
            dcv.noNulls = false;
            dcv.isNull[0] = true;
            dcv.isRepeating = true;
        } else {
            dcv.fill(((Number)value).doubleValue());
            dcv.isNull[0] = false;
        }
        return dcv;
    }

    private static TimestampColumnVector createTimestampVector(int batchSize, Object value) {
        TimestampColumnVector lcv = new TimestampColumnVector(batchSize);
        if (value == null) {
            lcv.noNulls = false;
            lcv.isNull[0] = true;
            lcv.isRepeating = true;
        } else {
            Timestamp timestamp = value instanceof LocalDateTime ? Timestamp.valueOf((LocalDateTime)value) : (Timestamp)value;
            lcv.fill(timestamp);
            lcv.isNull[0] = false;
        }
        return lcv;
    }
}

