/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.nohive;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.orc.OrcColumnarRowFileInputFormat;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.OrcSplitReaderUtil;
import org.apache.flink.orc.nohive.shim.OrcNoHiveShim;
import org.apache.flink.orc.nohive.vector.AbstractOrcNoHiveVector;
import org.apache.flink.orc.vector.AbstractOrcColumnVector;
import org.apache.flink.orc.vector.ColumnBatchFactory;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.VectorizedColumnBatch;
import org.apache.flink.table.filesystem.PartitionFieldExtractor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class OrcNoHiveColumnarRowInputFormat {
    private OrcNoHiveColumnarRowInputFormat() {
    }

    public static <SplitT extends FileSourceSplit> OrcColumnarRowFileInputFormat<VectorizedRowBatch, SplitT> createPartitionedFormat(Configuration hadoopConfig, RowType tableType, List<String> partitionKeys, PartitionFieldExtractor<SplitT> extractor, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, int batchSize) {
        String[] tableFieldNames = tableType.getFieldNames().toArray(new String[0]);
        LogicalType[] tableFieldTypes = tableType.getChildren().toArray(new LogicalType[0]);
        List<String> orcFieldNames = OrcSplitReaderUtil.getNonPartNames(tableFieldNames, partitionKeys);
        int[] orcSelectedFields = OrcSplitReaderUtil.getSelectedOrcFields(tableFieldNames, selectedFields, orcFieldNames);
        ColumnBatchFactory<VectorizedRowBatch, FileSourceSplit> batchGenerator = (split, rowBatch) -> {
            ColumnVector[] vectors = new ColumnVector[selectedFields.length];
            for (int i = 0; i < vectors.length; ++i) {
                String name = tableFieldNames[selectedFields[i]];
                LogicalType type = tableFieldTypes[selectedFields[i]];
                vectors[i] = partitionKeys.contains(name) ? AbstractOrcColumnVector.createFlinkVectorFromConstant(type, extractor.extract(split, name, type), batchSize) : AbstractOrcNoHiveVector.createFlinkVector(rowBatch.cols[orcFieldNames.indexOf(name)]);
            }
            return new VectorizedColumnBatch(vectors);
        };
        return new OrcColumnarRowFileInputFormat<VectorizedRowBatch, FileSourceSplit>(new OrcNoHiveShim(), hadoopConfig, OrcSplitReaderUtil.convertToOrcTypeWithPart(tableFieldNames, tableFieldTypes, partitionKeys), orcSelectedFields, conjunctPredicates, batchSize, batchGenerator, new RowType(Arrays.stream(selectedFields).mapToObj(i -> (RowType.RowField)tableType.getFields().get(i)).collect(Collectors.toList())));
    }
}

