/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.internal.column.columnindex;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.hive.shaded.parquet.filter2.predicate.Statistics;
import org.apache.flink.hive.shaded.parquet.internal.column.columnindex.BinaryTruncator;
import org.apache.flink.hive.shaded.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.flink.hive.shaded.parquet.io.api.Binary;
import org.apache.flink.hive.shaded.parquet.schema.PrimitiveComparator;
import org.apache.flink.hive.shaded.parquet.schema.PrimitiveType;

class BinaryColumnIndexBuilder
extends ColumnIndexBuilder {
    private final List<Binary> minValues = new ArrayList<Binary>();
    private final List<Binary> maxValues = new ArrayList<Binary>();
    private final BinaryTruncator truncator;
    private final int truncateLength;

    private static Binary convert(ByteBuffer buffer) {
        return Binary.fromReusedByteBuffer(buffer);
    }

    private static ByteBuffer convert(Binary value) {
        return value.toByteBuffer();
    }

    BinaryColumnIndexBuilder(PrimitiveType type, int truncateLength) {
        this.truncator = BinaryTruncator.getTruncator(type);
        this.truncateLength = truncateLength;
    }

    @Override
    void addMinMaxFromBytes(ByteBuffer min, ByteBuffer max) {
        this.minValues.add(BinaryColumnIndexBuilder.convert(min));
        this.maxValues.add(BinaryColumnIndexBuilder.convert(max));
    }

    @Override
    void addMinMax(Object min, Object max) {
        this.minValues.add(min == null ? null : this.truncator.truncateMin((Binary)min, this.truncateLength));
        this.maxValues.add(max == null ? null : this.truncator.truncateMax((Binary)max, this.truncateLength));
    }

    ColumnIndexBuilder.ColumnIndexBase<Binary> createColumnIndex(PrimitiveType type) {
        BinaryColumnIndex columnIndex = new BinaryColumnIndex(type);
        BinaryColumnIndex.access$102(columnIndex, this.minValues.toArray(new Binary[this.minValues.size()]));
        BinaryColumnIndex.access$202(columnIndex, this.maxValues.toArray(new Binary[this.maxValues.size()]));
        return columnIndex;
    }

    @Override
    void clearMinMax() {
        this.minValues.clear();
        this.maxValues.clear();
    }

    @Override
    int compareMinValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.minValues.get(index1), this.minValues.get(index2));
    }

    @Override
    int compareMaxValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.maxValues.get(index1), this.maxValues.get(index2));
    }

    @Override
    int sizeOf(Object value) {
        return ((Binary)value).length();
    }

    private static class BinaryColumnIndex
    extends ColumnIndexBuilder.ColumnIndexBase<Binary> {
        private Binary[] minValues;
        private Binary[] maxValues;

        private BinaryColumnIndex(PrimitiveType type) {
            super(type);
        }

        @Override
        ByteBuffer getMinValueAsBytes(int pageIndex) {
            return BinaryColumnIndexBuilder.convert(this.minValues[pageIndex]);
        }

        @Override
        ByteBuffer getMaxValueAsBytes(int pageIndex) {
            return BinaryColumnIndexBuilder.convert(this.maxValues[pageIndex]);
        }

        @Override
        String getMinValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.minValues[pageIndex]);
        }

        @Override
        String getMaxValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.maxValues[pageIndex]);
        }

        @Override
        <T extends Comparable<T>> Statistics<T> createStats(int arrayIndex) {
            return new Statistics<Binary>(this.minValues[arrayIndex], this.maxValues[arrayIndex], this.comparator);
        }

        @Override
        ColumnIndexBuilder.ColumnIndexBase.ValueComparator createValueComparator(Object value) {
            final Binary v = (Binary)value;
            return new ColumnIndexBuilder.ColumnIndexBase.ValueComparator(){

                @Override
                int compareValueToMin(int arrayIndex) {
                    return comparator.compare(v, minValues[arrayIndex]);
                }

                @Override
                int compareValueToMax(int arrayIndex) {
                    return comparator.compare(v, maxValues[arrayIndex]);
                }
            };
        }

        static /* synthetic */ Binary[] access$102(BinaryColumnIndex x0, Binary[] x1) {
            x0.minValues = x1;
            return x1;
        }

        static /* synthetic */ Binary[] access$202(BinaryColumnIndex x0, Binary[] x1) {
            x0.maxValues = x1;
            return x1;
        }
    }
}

