/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet.vector;

import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.vector.BytesColumnVector;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.DecimalColumnVector;
import org.apache.flink.table.data.vector.IntColumnVector;
import org.apache.flink.table.data.vector.LongColumnVector;

public class ParquetDecimalVector
implements DecimalColumnVector {
    private final ColumnVector vector;

    public ParquetDecimalVector(ColumnVector vector) {
        this.vector = vector;
    }

    public DecimalData getDecimal(int i, int precision, int scale) {
        if (DecimalDataUtils.is32BitDecimal((int)precision)) {
            return DecimalData.fromUnscaledLong((long)((IntColumnVector)this.vector).getInt(i), (int)precision, (int)scale);
        }
        if (DecimalDataUtils.is64BitDecimal((int)precision)) {
            return DecimalData.fromUnscaledLong((long)((LongColumnVector)this.vector).getLong(i), (int)precision, (int)scale);
        }
        return DecimalData.fromUnscaledBytes((byte[])((BytesColumnVector)this.vector).getBytes(i).getBytes(), (int)precision, (int)scale);
    }

    public boolean isNullAt(int i) {
        return this.vector.isNullAt(i);
    }
}

