/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.connectors.hive.read.HiveTableInputSplit;
import org.apache.flink.connectors.hive.read.SplitReader;
import org.apache.flink.connectors.hive.util.HivePartitionUtils;
import org.apache.flink.connectors.hive.util.JobConfUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.hive.shaded.formats.parquet.vector.ParquetColumnarRowSplitReader;
import org.apache.flink.hive.shaded.formats.parquet.vector.ParquetSplitReaderUtil;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

public class HiveVectorizedParquetSplitReader
implements SplitReader {
    private ParquetColumnarRowSplitReader reader;

    public HiveVectorizedParquetSplitReader(String hiveVersion, JobConf jobConf, String[] fieldNames, DataType[] fieldTypes, int[] selectedFields, HiveTableInputSplit split) throws IOException {
        StorageDescriptor sd = split.getHiveTablePartition().getStorageDescriptor();
        Configuration conf = new Configuration((Configuration)jobConf);
        sd.getSerdeInfo().getParameters().forEach((arg_0, arg_1) -> ((Configuration)conf).set(arg_0, arg_1));
        InputSplit hadoopSplit = split.getHadoopInputSplit();
        if (!(hadoopSplit instanceof FileSplit)) {
            throw new IllegalArgumentException("Unknown split type: " + hadoopSplit);
        }
        FileSplit fileSplit = (FileSplit)hadoopSplit;
        Map<String, Object> partitionValues = HivePartitionUtils.parsePartitionValues(split.getHiveTablePartition().getPartitionSpec(), fieldNames, fieldTypes, JobConfUtils.getDefaultPartitionName(jobConf), HiveShimLoader.loadHiveShim(hiveVersion));
        this.reader = ParquetSplitReaderUtil.genPartColumnarRowReader(hiveVersion.startsWith("3"), false, conf, fieldNames, fieldTypes, partitionValues, selectedFields, 2048, new Path(fileSplit.getPath().toString()), fileSplit.getStart(), fileSplit.getLength());
    }

    @Override
    public void seekToRow(long rowCount, RowData reuse) throws IOException {
        this.reader.seekToRow(rowCount);
    }

    @Override
    public boolean reachedEnd() throws IOException {
        return this.reader.reachedEnd();
    }

    @Override
    public RowData nextRecord(RowData reuse) {
        return this.reader.nextRecord();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

