/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive;

import java.util.Map;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveDatabase;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;

public class HiveDatabaseUtil {
    private HiveDatabaseUtil() {
    }

    static Database instantiateHiveDatabase(String databaseName, CatalogDatabase database) {
        Map properties = database.getProperties();
        boolean isGeneric = HiveCatalog.isGenericForCreate(properties);
        String dbLocationUri = isGeneric ? null : (String)properties.remove("hive.database.location-uri");
        return new Database(databaseName, database.getComment(), dbLocationUri, properties);
    }

    static Database alterDatabase(Database hiveDB, CatalogDatabase newDatabase) {
        Map<String, String> params = hiveDB.getParameters();
        boolean isGeneric = HiveCatalog.isGenericForGet(params);
        if (isGeneric) {
            hiveDB.setParameters(newDatabase.getProperties());
        } else {
            String opStr = (String)newDatabase.getProperties().remove("hive.alter.database.op");
            if (opStr == null) {
                throw new CatalogException("hive.alter.database.op property is missing for alter database statement");
            }
            String newLocation = (String)newDatabase.getProperties().remove("hive.database.location-uri");
            Map newParams = newDatabase.getProperties();
            SqlAlterHiveDatabase.AlterHiveDatabaseOp op = SqlAlterHiveDatabase.AlterHiveDatabaseOp.valueOf((String)opStr);
            block0 : switch (op) {
                case CHANGE_PROPS: {
                    if (params == null) {
                        hiveDB.setParameters(newParams);
                        break;
                    }
                    params.putAll(newParams);
                    break;
                }
                case CHANGE_LOCATION: {
                    hiveDB.setLocationUri(newLocation);
                    break;
                }
                case CHANGE_OWNER: {
                    String ownerName = (String)newParams.remove("hive.database.owner.name");
                    String ownerType = (String)newParams.remove("hive.database.owner.type");
                    hiveDB.setOwnerName(ownerName);
                    switch (ownerType) {
                        case "role": {
                            hiveDB.setOwnerType(PrincipalType.ROLE);
                            break block0;
                        }
                        case "user": {
                            hiveDB.setOwnerType(PrincipalType.USER);
                            break block0;
                        }
                    }
                    throw new CatalogException("Unsupported database owner type: " + ownerType);
                }
                default: {
                    throw new CatalogException("Unsupported alter database op:" + opStr);
                }
            }
        }
        return hiveDB;
    }
}

