/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.filter2.compat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.hive.shaded.parquet.Preconditions;
import org.apache.flink.hive.shaded.parquet.filter2.compat.FilterCompat;
import org.apache.flink.hive.shaded.parquet.filter2.dictionarylevel.DictionaryFilter;
import org.apache.flink.hive.shaded.parquet.filter2.predicate.FilterPredicate;
import org.apache.flink.hive.shaded.parquet.filter2.predicate.SchemaCompatibilityValidator;
import org.apache.flink.hive.shaded.parquet.filter2.statisticslevel.StatisticsFilter;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetFileReader;
import org.apache.flink.hive.shaded.parquet.hadoop.metadata.BlockMetaData;
import org.apache.flink.hive.shaded.parquet.schema.MessageType;

public class RowGroupFilter
implements FilterCompat.Visitor<List<BlockMetaData>> {
    private final List<BlockMetaData> blocks;
    private final MessageType schema;
    private final List<FilterLevel> levels;
    private final ParquetFileReader reader;

    @Deprecated
    public static List<BlockMetaData> filterRowGroups(FilterCompat.Filter filter, List<BlockMetaData> blocks, MessageType schema) {
        Preconditions.checkNotNull(filter, "filter");
        return filter.accept(new RowGroupFilter(blocks, schema));
    }

    public static List<BlockMetaData> filterRowGroups(List<FilterLevel> levels, FilterCompat.Filter filter, List<BlockMetaData> blocks, ParquetFileReader reader) {
        Preconditions.checkNotNull(filter, "filter");
        return filter.accept(new RowGroupFilter(levels, blocks, reader));
    }

    @Deprecated
    private RowGroupFilter(List<BlockMetaData> blocks, MessageType schema) {
        this.blocks = Preconditions.checkNotNull(blocks, "blocks");
        this.schema = Preconditions.checkNotNull(schema, "schema");
        this.levels = Collections.singletonList(FilterLevel.STATISTICS);
        this.reader = null;
    }

    private RowGroupFilter(List<FilterLevel> levels, List<BlockMetaData> blocks, ParquetFileReader reader) {
        this.blocks = Preconditions.checkNotNull(blocks, "blocks");
        this.reader = Preconditions.checkNotNull(reader, "reader");
        this.schema = reader.getFileMetaData().getSchema();
        this.levels = levels;
    }

    @Override
    public List<BlockMetaData> visit(FilterCompat.FilterPredicateCompat filterPredicateCompat) {
        FilterPredicate filterPredicate = filterPredicateCompat.getFilterPredicate();
        SchemaCompatibilityValidator.validate(filterPredicate, this.schema);
        ArrayList<BlockMetaData> filteredBlocks = new ArrayList<BlockMetaData>();
        for (BlockMetaData block : this.blocks) {
            boolean drop = false;
            if (this.levels.contains((Object)FilterLevel.STATISTICS)) {
                drop = StatisticsFilter.canDrop(filterPredicate, block.getColumns());
            }
            if (!drop && this.levels.contains((Object)FilterLevel.DICTIONARY)) {
                drop = DictionaryFilter.canDrop(filterPredicate, block.getColumns(), this.reader.getDictionaryReader(block));
            }
            if (drop) continue;
            filteredBlocks.add(block);
        }
        return filteredBlocks;
    }

    @Override
    public List<BlockMetaData> visit(FilterCompat.UnboundRecordFilterCompat unboundRecordFilterCompat) {
        return this.blocks;
    }

    @Override
    public List<BlockMetaData> visit(FilterCompat.NoOpFilter noOpFilter) {
        return this.blocks;
    }

    public static enum FilterLevel {
        STATISTICS,
        DICTIONARY;

    }
}

