/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.errors.DataConstraintViolationError;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="enforce_constraint", value="_FUNC_(x) - Internal UDF to enforce CHECK and NOT NULL constraint", extended="For internal use only")
public class GenericUDFEnforceConstraint
extends GenericUDF {
    private final BooleanWritable resultBool = new BooleanWritable();
    private transient BooleanObjectInspector boi;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length > 1) {
            throw new UDFArgumentLengthException("Invalid number of arguments. enforce_constraint UDF expected one argument but received: " + arguments.length);
        }
        this.boi = (BooleanObjectInspector)arguments[0];
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object a = arguments[0].get();
        boolean result = this.boi.get(a);
        if (!result) {
            throw new DataConstraintViolationError("Either CHECK or NOT NULL constraint violated!");
        }
        this.resultBool.set(true);
        return this.resultBool;
    }

    @Override
    protected String getFuncName() {
        return "enforce_constraint";
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }
}

