/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMkCollectionEvaluator;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="collect_set", value="_FUNC_(x) - Returns a set of objects with duplicate elements eliminated")
public class GenericUDAFCollectSet
extends AbstractGenericUDAFResolver {
    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        switch (parameters[0].getCategory()) {
            case PRIMITIVE: 
            case STRUCT: 
            case MAP: 
            case LIST: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Only primitive, struct, list or map type arguments are accepted but " + parameters[0].getTypeName() + " was passed as parameter 1.");
            }
        }
        return new GenericUDAFMkCollectionEvaluator(GenericUDAFMkCollectionEvaluator.BufferType.SET);
    }
}

