/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.ptf;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ptf.ShapeDetails;

public abstract class PTFInputDef {
    private String expressionTreeString;
    private ShapeDetails outputShape;
    private String alias;

    public String getExpressionTreeString() {
        return this.expressionTreeString;
    }

    public void setExpressionTreeString(String expressionTreeString) {
        this.expressionTreeString = expressionTreeString;
    }

    public ShapeDetails getOutputShape() {
        return this.outputShape;
    }

    @Explain(displayName="output shape")
    public String getOutputShapeExplain() {
        RowSchema schema = this.outputShape.getRr().getRowSchema();
        return StringUtils.join(schema.getSignature(), ", ");
    }

    public void setOutputShape(ShapeDetails outputShape) {
        this.outputShape = outputShape;
    }

    @Explain(displayName="input alias")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public abstract PTFInputDef getInput();
}

