/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;

public class DumpMetaData {
    private static final String DUMP_METADATA = "_dumpmetadata";
    private DumpType dumpType;
    private Long eventFrom = null;
    private Long eventTo = null;
    private String payload = null;
    private boolean initialized = false;
    private final Path dumpFile;
    private final HiveConf hiveConf;
    private Path cmRoot;

    public DumpMetaData(Path dumpRoot, HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.dumpFile = new Path(dumpRoot, DUMP_METADATA);
    }

    public DumpMetaData(Path dumpRoot, DumpType lvl, Long eventFrom, Long eventTo, Path cmRoot, HiveConf hiveConf) {
        this(dumpRoot, hiveConf);
        this.setDump(lvl, eventFrom, eventTo, cmRoot);
    }

    public void setDump(DumpType lvl, Long eventFrom, Long eventTo, Path cmRoot) {
        this.dumpType = lvl;
        this.eventFrom = eventFrom;
        this.eventTo = eventTo;
        this.initialized = true;
        this.cmRoot = cmRoot;
    }

    private void loadDumpFromFile() throws SemanticException {
        block11: {
            BufferedReader br = null;
            try {
                FileSystem fs = this.dumpFile.getFileSystem((Configuration)this.hiveConf);
                br = new BufferedReader(new InputStreamReader((InputStream)fs.open(this.dumpFile)));
                String line = null;
                line = br.readLine();
                if (line != null) {
                    String[] lineContents = line.split("\t", 5);
                    this.setDump(DumpType.valueOf(lineContents[0]), Long.valueOf(lineContents[1]), Long.valueOf(lineContents[2]), new Path(lineContents[3]));
                    this.setPayload(lineContents[4].equals("NULL") ? null : lineContents[4]);
                    break block11;
                }
                throw new IOException("Unable to read valid values from dumpFile:" + this.dumpFile.toUri().toString());
            }
            catch (IOException ioe) {
                throw new SemanticException(ioe);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new SemanticException(e);
                    }
                }
            }
        }
    }

    public DumpType getDumpType() throws SemanticException {
        this.initializeIfNot();
        return this.dumpType;
    }

    public String getPayload() throws SemanticException {
        this.initializeIfNot();
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public Long getEventFrom() throws SemanticException {
        this.initializeIfNot();
        return this.eventFrom;
    }

    public Long getEventTo() throws SemanticException {
        this.initializeIfNot();
        return this.eventTo;
    }

    public Path getDumpFilePath() {
        return this.dumpFile;
    }

    public boolean isIncrementalDump() throws SemanticException {
        this.initializeIfNot();
        return this.dumpType == DumpType.INCREMENTAL;
    }

    private void initializeIfNot() throws SemanticException {
        if (!this.initialized) {
            this.loadDumpFromFile();
        }
    }

    public void write() throws SemanticException {
        Utils.writeOutput(Arrays.asList(this.dumpType.toString(), this.eventFrom.toString(), this.eventTo.toString(), this.cmRoot.toString(), this.payload), this.dumpFile, this.hiveConf);
    }
}

