/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCleanerTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(EventCleanerTask.class);
    private Configuration conf;

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.EVENT_CLEAN_FREQ, unit);
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void run() {
        try {
            RawStore ms = HiveMetaStore.HMSHandler.getMSForConf(this.conf);
            long deleteCnt = ms.cleanupEvents();
            if (deleteCnt > 0L) {
                LOG.info("Number of events deleted from event Table: " + deleteCnt);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while trying to delete events ", (Throwable)e);
        }
    }
}

