/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet;

import java.util.Map;
import org.apache.flink.hive.shaded.parquet.ParquetReadOptions;
import org.apache.flink.hive.shaded.parquet.bytes.ByteBufferAllocator;
import org.apache.flink.hive.shaded.parquet.compression.CompressionCodecFactory;
import org.apache.flink.hive.shaded.parquet.filter2.compat.FilterCompat;
import org.apache.flink.hive.shaded.parquet.format.converter.ParquetMetadataConverter;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetInputFormat;
import org.apache.flink.hive.shaded.parquet.hadoop.util.HadoopCodecs;
import org.apache.hadoop.conf.Configuration;

public class HadoopReadOptions
extends ParquetReadOptions {
    private final Configuration conf;
    private static final String ALLOCATION_SIZE = "parquet.read.allocation.size";

    private HadoopReadOptions(boolean useSignedStringMinMax, boolean useStatsFilter, boolean useDictionaryFilter, boolean useRecordFilter, FilterCompat.Filter recordFilter, ParquetMetadataConverter.MetadataFilter metadataFilter, CompressionCodecFactory codecFactory, ByteBufferAllocator allocator, int maxAllocationSize, Map<String, String> properties, Configuration conf) {
        super(useSignedStringMinMax, useStatsFilter, useDictionaryFilter, useRecordFilter, recordFilter, metadataFilter, codecFactory, allocator, maxAllocationSize, properties);
        this.conf = conf;
    }

    @Override
    public String getProperty(String property) {
        String value = super.getProperty(property);
        if (value != null) {
            return value;
        }
        return this.conf.get(property);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static Builder builder(Configuration conf) {
        return new Builder(conf);
    }

    public static class Builder
    extends ParquetReadOptions.Builder {
        private final Configuration conf;

        public Builder(Configuration conf) {
            this.conf = conf;
            this.useSignedStringMinMax(conf.getBoolean("parquet.strings.signed-min-max.enabled", false));
            this.useDictionaryFilter(conf.getBoolean("parquet.filter.stats.enabled", true));
            this.useStatsFilter(conf.getBoolean("parquet.filter.dictionary.enabled", true));
            this.useRecordFilter(conf.getBoolean("parquet.filter.record-level.enabled", true));
            this.withCodecFactory(HadoopCodecs.newFactory(conf, 0));
            this.withRecordFilter(ParquetInputFormat.getFilter(conf));
            this.withMaxAllocationInBytes(conf.getInt(HadoopReadOptions.ALLOCATION_SIZE, 0x800000));
            String badRecordThresh = conf.get("parquet.read.bad.record.threshold");
            if (badRecordThresh != null) {
                this.set("parquet.read.bad.record.threshold", badRecordThresh);
            }
        }

        @Override
        public ParquetReadOptions build() {
            return new HadoopReadOptions(this.useSignedStringMinMax, this.useStatsFilter, this.useDictionaryFilter, this.useRecordFilter, this.recordFilter, this.metadataFilter, this.codecFactory, this.allocator, this.maxAllocationSize, this.properties, this.conf);
        }
    }
}

