/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.io.api;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hive.shaded.parquet.bytes.BytesUtils;
import org.apache.hive.shaded.parquet.io.ParquetEncodingException;

public abstract class Binary
implements Comparable<Binary>,
Serializable {
    protected boolean isBackingBytesReused;
    public static final Binary EMPTY = Binary.fromConstantByteArray(new byte[0]);

    private Binary() {
    }

    public abstract String toStringUsingUTF8();

    public abstract int length();

    public abstract void writeTo(OutputStream var1) throws IOException;

    public abstract void writeTo(DataOutput var1) throws IOException;

    public abstract byte[] getBytes();

    public abstract byte[] getBytesUnsafe();

    public abstract Binary slice(int var1, int var2);

    abstract boolean equals(byte[] var1, int var2, int var3);

    abstract boolean equals(Binary var1);

    @Override
    public abstract int compareTo(Binary var1);

    abstract int compareTo(byte[] var1, int var2, int var3);

    public abstract ByteBuffer toByteBuffer();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Binary) {
            return this.equals((Binary)obj);
        }
        return false;
    }

    public String toString() {
        return "Binary{" + this.length() + (this.isBackingBytesReused ? " reused" : " constant") + " bytes, " + Arrays.toString(this.getBytesUnsafe()) + "}";
    }

    public Binary copy() {
        if (this.isBackingBytesReused) {
            return Binary.fromConstantByteArray(this.getBytes());
        }
        return this;
    }

    public boolean isBackingBytesReused() {
        return this.isBackingBytesReused;
    }

    public static Binary fromReusedByteArray(byte[] value, int offset, int length) {
        return new ByteArraySliceBackedBinary(value, offset, length, true);
    }

    public static Binary fromConstantByteArray(byte[] value, int offset, int length) {
        return new ByteArraySliceBackedBinary(value, offset, length, false);
    }

    @Deprecated
    public static Binary fromByteArray(byte[] value, int offset, int length) {
        return Binary.fromReusedByteArray(value, offset, length);
    }

    public static Binary fromReusedByteArray(byte[] value) {
        return new ByteArrayBackedBinary(value, true);
    }

    public static Binary fromConstantByteArray(byte[] value) {
        return new ByteArrayBackedBinary(value, false);
    }

    @Deprecated
    public static Binary fromByteArray(byte[] value) {
        return Binary.fromReusedByteArray(value);
    }

    public static Binary fromReusedByteBuffer(ByteBuffer value) {
        return new ByteBufferBackedBinary(value, true);
    }

    public static Binary fromConstantByteBuffer(ByteBuffer value) {
        return new ByteBufferBackedBinary(value, false);
    }

    @Deprecated
    public static Binary fromByteBuffer(ByteBuffer value) {
        return Binary.fromReusedByteBuffer(value);
    }

    public static Binary fromString(String value) {
        return new FromStringBinary(value);
    }

    private static final int hashCode(byte[] array, int offset, int length) {
        int result = 1;
        for (int i = offset; i < offset + length; ++i) {
            byte b = array[i];
            result = 31 * result + b;
        }
        return result;
    }

    private static final boolean equals(byte[] array1, int offset1, int length1, byte[] array2, int offset2, int length2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (length1 != length2) {
            return false;
        }
        if (array1 == array2 && offset1 == offset2) {
            return true;
        }
        for (int i = 0; i < length1; ++i) {
            if (array1[i + offset1] == array2[i + offset2]) continue;
            return false;
        }
        return true;
    }

    private static final int compareTwoByteArrays(byte[] array1, int offset1, int length1, byte[] array2, int offset2, int length2) {
        if (array1 == null && array2 == null) {
            return 0;
        }
        if (array1 == array2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int min_length = length1 < length2 ? length1 : length2;
        for (int i = 0; i < min_length; ++i) {
            if (array1[i + offset1] < array2[i + offset2]) {
                return 1;
            }
            if (array1[i + offset1] <= array2[i + offset2]) continue;
            return -1;
        }
        if (length1 == length2) {
            return 0;
        }
        if (length1 < length2) {
            return 1;
        }
        return -1;
    }

    private static class ByteBufferBackedBinary
    extends Binary {
        private transient ByteBuffer value;
        private transient byte[] cachedBytes;

        public ByteBufferBackedBinary(ByteBuffer value, boolean isBackingBytesReused) {
            this.value = value;
            this.isBackingBytesReused = isBackingBytesReused;
        }

        @Override
        public String toStringUsingUTF8() {
            return BytesUtils.UTF8.decode(this.value).toString();
        }

        @Override
        public int length() {
            return this.value.remaining();
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.getBytesUnsafe());
        }

        @Override
        public byte[] getBytes() {
            byte[] bytes = new byte[this.value.remaining()];
            this.value.mark();
            this.value.get(bytes).reset();
            if (!this.isBackingBytesReused) {
                this.cachedBytes = bytes;
            }
            return bytes;
        }

        @Override
        public byte[] getBytesUnsafe() {
            return this.cachedBytes != null ? this.cachedBytes : this.getBytes();
        }

        @Override
        public Binary slice(int start, int length) {
            return Binary.fromConstantByteArray(this.getBytesUnsafe(), start, length);
        }

        public int hashCode() {
            if (this.value.hasArray()) {
                return Binary.hashCode(this.value.array(), this.value.arrayOffset() + this.value.position(), this.value.arrayOffset() + this.value.remaining());
            }
            byte[] bytes = this.getBytesUnsafe();
            return Binary.hashCode(bytes, 0, bytes.length);
        }

        @Override
        boolean equals(Binary other) {
            if (this.value.hasArray()) {
                return other.equals(this.value.array(), this.value.arrayOffset() + this.value.position(), this.value.arrayOffset() + this.value.remaining());
            }
            byte[] bytes = this.getBytesUnsafe();
            return other.equals(bytes, 0, bytes.length);
        }

        @Override
        boolean equals(byte[] other, int otherOffset, int otherLength) {
            if (this.value.hasArray()) {
                return Binary.equals(this.value.array(), this.value.arrayOffset() + this.value.position(), this.value.arrayOffset() + this.value.remaining(), other, otherOffset, otherLength);
            }
            byte[] bytes = this.getBytesUnsafe();
            return Binary.equals(bytes, 0, bytes.length, other, otherOffset, otherLength);
        }

        @Override
        public int compareTo(Binary other) {
            if (this.value.hasArray()) {
                return other.compareTo(this.value.array(), this.value.arrayOffset() + this.value.position(), this.value.arrayOffset() + this.value.remaining());
            }
            byte[] bytes = this.getBytesUnsafe();
            return other.compareTo(bytes, 0, bytes.length);
        }

        @Override
        int compareTo(byte[] other, int otherOffset, int otherLength) {
            if (this.value.hasArray()) {
                return Binary.compareTwoByteArrays(this.value.array(), this.value.arrayOffset() + this.value.position(), this.value.arrayOffset() + this.value.remaining(), other, otherOffset, otherLength);
            }
            byte[] bytes = this.getBytesUnsafe();
            return Binary.compareTwoByteArrays(bytes, 0, bytes.length, other, otherOffset, otherLength);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return this.value;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.write(this.getBytesUnsafe());
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            byte[] bytes = this.getBytesUnsafe();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes, 0, length);
            this.value = ByteBuffer.wrap(bytes);
        }

        private void readObjectNoData() throws ObjectStreamException {
            this.value = ByteBuffer.wrap(new byte[0]);
        }
    }

    private static class ByteArrayBackedBinary
    extends Binary {
        private final byte[] value;

        public ByteArrayBackedBinary(byte[] value, boolean isBackingBytesReused) {
            this.value = value;
            this.isBackingBytesReused = isBackingBytesReused;
        }

        @Override
        public String toStringUsingUTF8() {
            return BytesUtils.UTF8.decode(ByteBuffer.wrap(this.value)).toString();
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.value);
        }

        @Override
        public byte[] getBytes() {
            return Arrays.copyOfRange(this.value, 0, this.value.length);
        }

        @Override
        public byte[] getBytesUnsafe() {
            return this.value;
        }

        @Override
        public Binary slice(int start, int length) {
            if (this.isBackingBytesReused) {
                return Binary.fromReusedByteArray(this.value, start, length);
            }
            return Binary.fromConstantByteArray(this.value, start, length);
        }

        public int hashCode() {
            return Binary.hashCode(this.value, 0, this.value.length);
        }

        @Override
        boolean equals(Binary other) {
            return other.equals(this.value, 0, this.value.length);
        }

        @Override
        boolean equals(byte[] other, int otherOffset, int otherLength) {
            return Binary.equals(this.value, 0, this.value.length, other, otherOffset, otherLength);
        }

        @Override
        public int compareTo(Binary other) {
            return other.compareTo(this.value, 0, this.value.length);
        }

        @Override
        int compareTo(byte[] other, int otherOffset, int otherLength) {
            return Binary.compareTwoByteArrays(this.value, 0, this.value.length, other, otherOffset, otherLength);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.value);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.write(this.value);
        }
    }

    private static class FromStringBinary
    extends ByteArrayBackedBinary {
        public FromStringBinary(String value) {
            super(FromStringBinary.encodeUTF8(value), false);
        }

        private static byte[] encodeUTF8(String value) {
            try {
                return value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ParquetEncodingException("UTF-8 not supported.", e);
            }
        }

        @Override
        public String toString() {
            return "Binary{\"" + this.toStringUsingUTF8() + "\"}";
        }
    }

    private static class ByteArraySliceBackedBinary
    extends Binary {
        private final byte[] value;
        private final int offset;
        private final int length;

        public ByteArraySliceBackedBinary(byte[] value, int offset, int length, boolean isBackingBytesReused) {
            this.value = value;
            this.offset = offset;
            this.length = length;
            this.isBackingBytesReused = isBackingBytesReused;
        }

        @Override
        public String toStringUsingUTF8() {
            return BytesUtils.UTF8.decode(ByteBuffer.wrap(this.value, this.offset, this.length)).toString();
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.value, this.offset, this.length);
        }

        @Override
        public byte[] getBytes() {
            return Arrays.copyOfRange(this.value, this.offset, this.offset + this.length);
        }

        @Override
        public byte[] getBytesUnsafe() {
            return this.getBytes();
        }

        @Override
        public Binary slice(int start, int length) {
            if (this.isBackingBytesReused) {
                return Binary.fromReusedByteArray(this.value, this.offset + start, length);
            }
            return Binary.fromConstantByteArray(this.value, this.offset + start, length);
        }

        public int hashCode() {
            return Binary.hashCode(this.value, this.offset, this.length);
        }

        @Override
        boolean equals(Binary other) {
            return other.equals(this.value, this.offset, this.length);
        }

        @Override
        boolean equals(byte[] other, int otherOffset, int otherLength) {
            return Binary.equals(this.value, this.offset, this.length, other, otherOffset, otherLength);
        }

        @Override
        public int compareTo(Binary other) {
            return other.compareTo(this.value, this.offset, this.length);
        }

        @Override
        int compareTo(byte[] other, int otherOffset, int otherLength) {
            return Binary.compareTwoByteArrays(this.value, this.offset, this.length, other, otherOffset, otherLength);
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.value, this.offset, this.length);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.write(this.value, this.offset, this.length);
        }
    }
}

