/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.filter2.compat;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.shaded.parquet.Preconditions;
import org.apache.hive.shaded.parquet.filter2.compat.FilterCompat;
import org.apache.hive.shaded.parquet.filter2.predicate.FilterPredicate;
import org.apache.hive.shaded.parquet.filter2.predicate.SchemaCompatibilityValidator;
import org.apache.hive.shaded.parquet.filter2.statisticslevel.StatisticsFilter;
import org.apache.hive.shaded.parquet.hadoop.metadata.BlockMetaData;
import org.apache.hive.shaded.parquet.schema.MessageType;

public class RowGroupFilter
implements FilterCompat.Visitor<List<BlockMetaData>> {
    private final List<BlockMetaData> blocks;
    private final MessageType schema;

    public static List<BlockMetaData> filterRowGroups(FilterCompat.Filter filter, List<BlockMetaData> blocks, MessageType schema) {
        Preconditions.checkNotNull(filter, "filter");
        return filter.accept(new RowGroupFilter(blocks, schema));
    }

    private RowGroupFilter(List<BlockMetaData> blocks, MessageType schema) {
        this.blocks = Preconditions.checkNotNull(blocks, "blocks");
        this.schema = Preconditions.checkNotNull(schema, "schema");
    }

    @Override
    public List<BlockMetaData> visit(FilterCompat.FilterPredicateCompat filterPredicateCompat) {
        FilterPredicate filterPredicate = filterPredicateCompat.getFilterPredicate();
        SchemaCompatibilityValidator.validate(filterPredicate, this.schema);
        ArrayList<BlockMetaData> filteredBlocks = new ArrayList<BlockMetaData>();
        for (BlockMetaData block : this.blocks) {
            if (StatisticsFilter.canDrop(filterPredicate, block.getColumns())) continue;
            filteredBlocks.add(block);
        }
        return filteredBlocks;
    }

    @Override
    public List<BlockMetaData> visit(FilterCompat.UnboundRecordFilterCompat unboundRecordFilterCompat) {
        return this.blocks;
    }

    @Override
    public List<BlockMetaData> visit(FilterCompat.NoOpFilter noOpFilter) {
        return this.blocks;
    }
}

