/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.filter;

import org.apache.hive.shaded.parquet.column.ColumnReader;
import org.apache.hive.shaded.parquet.filter.RecordFilter;
import org.apache.hive.shaded.parquet.filter.UnboundRecordFilter;

public final class PagedRecordFilter
implements RecordFilter {
    private final long startPos;
    private final long endPos;
    private long currentPos = 0L;

    public static final UnboundRecordFilter page(final long startPos, final long pageSize) {
        return new UnboundRecordFilter(){

            @Override
            public RecordFilter bind(Iterable<ColumnReader> readers) {
                return new PagedRecordFilter(startPos, pageSize);
            }
        };
    }

    private PagedRecordFilter(long startPos, long pageSize) {
        this.startPos = startPos;
        this.endPos = startPos + pageSize;
    }

    @Override
    public boolean isMatch() {
        ++this.currentPos;
        return this.currentPos >= this.startPos && this.currentPos < this.endPos;
    }
}

