/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.column.values.rle;

import java.io.IOException;
import org.apache.hive.shaded.parquet.Ints;
import org.apache.hive.shaded.parquet.bytes.BytesInput;
import org.apache.hive.shaded.parquet.column.Encoding;
import org.apache.hive.shaded.parquet.column.values.ValuesWriter;
import org.apache.hive.shaded.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.hive.shaded.parquet.io.ParquetEncodingException;

public class RunLengthBitPackingHybridValuesWriter
extends ValuesWriter {
    private final RunLengthBitPackingHybridEncoder encoder;

    public RunLengthBitPackingHybridValuesWriter(int bitWidth, int initialCapacity, int pageSize) {
        this.encoder = new RunLengthBitPackingHybridEncoder(bitWidth, initialCapacity, pageSize);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.encoder.writeInt(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public void writeBoolean(boolean v) {
        this.writeInteger(v ? 1 : 0);
    }

    @Override
    public long getBufferedSize() {
        return this.encoder.getBufferedSize();
    }

    @Override
    public long getAllocatedSize() {
        return this.encoder.getAllocatedSize();
    }

    @Override
    public BytesInput getBytes() {
        try {
            BytesInput rle = this.encoder.toBytes();
            return BytesInput.concat(BytesInput.fromInt(Ints.checkedCast(rle.size())), rle);
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.RLE;
    }

    @Override
    public void reset() {
        this.encoder.reset();
    }

    @Override
    public String memUsageString(String prefix) {
        return String.format("%s RunLengthBitPackingHybrid %d bytes", prefix, this.getAllocatedSize());
    }
}

