/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.column.values.rle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.hive.shaded.parquet.bytes.BytesUtils;
import org.apache.hive.shaded.parquet.column.values.ValuesReader;
import org.apache.hive.shaded.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.hive.shaded.parquet.io.ParquetDecodingException;

public class RunLengthBitPackingHybridValuesReader
extends ValuesReader {
    private final int bitWidth;
    private RunLengthBitPackingHybridDecoder decoder;
    private int nextOffset;

    public RunLengthBitPackingHybridValuesReader(int bitWidth) {
        this.bitWidth = bitWidth;
    }

    @Override
    public void initFromPage(int valueCountL, byte[] page, int offset) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(page, offset, page.length - offset);
        int length = BytesUtils.readIntLittleEndian(in);
        this.decoder = new RunLengthBitPackingHybridDecoder(this.bitWidth, in);
        this.nextOffset = offset + length + 4;
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public int readInteger() {
        try {
            return this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        return this.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

