/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.column.values.delta;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hive.shaded.parquet.Preconditions;
import org.apache.hive.shaded.parquet.bytes.BytesInput;
import org.apache.hive.shaded.parquet.bytes.BytesUtils;

class DeltaBinaryPackingConfig {
    final int blockSizeInValues;
    final int miniBlockNumInABlock;
    final int miniBlockSizeInValues;

    public DeltaBinaryPackingConfig(int blockSizeInValues, int miniBlockNumInABlock) {
        this.blockSizeInValues = blockSizeInValues;
        this.miniBlockNumInABlock = miniBlockNumInABlock;
        double miniSize = (double)blockSizeInValues / (double)miniBlockNumInABlock;
        Preconditions.checkArgument(miniSize % 8.0 == 0.0, "miniBlockSize must be multiple of 8, but it's " + miniSize);
        this.miniBlockSizeInValues = (int)miniSize;
    }

    public static DeltaBinaryPackingConfig readConfig(InputStream in) throws IOException {
        return new DeltaBinaryPackingConfig(BytesUtils.readUnsignedVarInt(in), BytesUtils.readUnsignedVarInt(in));
    }

    public BytesInput toBytesInput() {
        return BytesInput.concat(BytesInput.fromUnsignedVarInt(this.blockSizeInValues), BytesInput.fromUnsignedVarInt(this.miniBlockNumInABlock));
    }
}

