/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.column.values.bitpacking;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hive.shaded.parquet.Log;
import org.apache.hive.shaded.parquet.bytes.BytesUtils;
import org.apache.hive.shaded.parquet.column.values.ValuesReader;
import org.apache.hive.shaded.parquet.column.values.bitpacking.BytePacker;
import org.apache.hive.shaded.parquet.column.values.bitpacking.Packer;

public class ByteBitPackingValuesReader
extends ValuesReader {
    private static final int VALUES_AT_A_TIME = 8;
    private static final Log LOG = Log.getLog(ByteBitPackingValuesReader.class);
    private final int bitWidth;
    private final BytePacker packer;
    private final int[] decoded = new int[8];
    private int decodedPosition = 7;
    private byte[] encoded;
    private int encodedPos;
    private int nextOffset;

    public ByteBitPackingValuesReader(int bound, Packer packer) {
        this.bitWidth = BytesUtils.getWidthFromMaxInt(bound);
        this.packer = packer.newBytePacker(this.bitWidth);
    }

    @Override
    public int readInteger() {
        ++this.decodedPosition;
        if (this.decodedPosition == this.decoded.length) {
            if (this.encodedPos + this.bitWidth > this.encoded.length) {
                this.packer.unpack8Values(Arrays.copyOfRange(this.encoded, this.encodedPos, this.encodedPos + this.bitWidth), 0, this.decoded, 0);
            } else {
                this.packer.unpack8Values(this.encoded, this.encodedPos, this.decoded, 0);
            }
            this.encodedPos += this.bitWidth;
            this.decodedPosition = 0;
        }
        return this.decoded[this.decodedPosition];
    }

    @Override
    public void initFromPage(int valueCount, byte[] page, int offset) throws IOException {
        int effectiveBitLength = valueCount * this.bitWidth;
        int length = BytesUtils.paddedByteCountFromBits(effectiveBitLength);
        if (Log.DEBUG) {
            LOG.debug("reading " + length + " bytes for " + valueCount + " values of size " + this.bitWidth + " bits.");
        }
        this.encoded = page;
        this.encodedPos = offset;
        this.decodedPosition = 7;
        this.nextOffset = offset + length;
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

