/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Function;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EximUtil {
    public static final String METADATA_NAME = "_metadata";
    public static final String FILES_NAME = "_files";
    public static final String DATA_PATH_NAME = "data";
    private static final Logger LOG = LoggerFactory.getLogger(EximUtil.class);
    public static final String METADATA_FORMAT_VERSION = "0.2";
    public static final String METADATA_FORMAT_FORWARD_COMPATIBLE_VERSION = null;

    private EximUtil() {
    }

    static URI getValidatedURI(HiveConf conf, String dcPath) throws SemanticException {
        try {
            boolean testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
            URI uri = new Path(dcPath).toUri();
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            String path = uri.getPath();
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
            LOG.info("Path before norm :" + path);
            if (!path.startsWith("/")) {
                path = testMode ? new Path(System.getProperty("test.tmp.dir"), path).toUri().getPath() : new Path(new Path("/user/" + System.getProperty("user.name")), path).toUri().getPath();
            }
            scheme = fs.getScheme();
            if (StringUtils.isEmpty(authority)) {
                URI defaultURI = FileSystem.get((Configuration)conf).getUri();
                authority = defaultURI.getAuthority();
            }
            LOG.info("Scheme:" + scheme + ", authority:" + authority + ", path:" + path);
            Collection eximSchemes = conf.getStringCollection(HiveConf.ConfVars.HIVE_EXIM_URI_SCHEME_WL.varname);
            if (!eximSchemes.contains(scheme)) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg("only the following file systems accepted for export/import : " + conf.get(HiveConf.ConfVars.HIVE_EXIM_URI_SCHEME_WL.varname)));
            }
            try {
                return new URI(scheme, authority, path, null, null);
            }
            catch (URISyntaxException e) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
            }
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.IO_ERROR.getMsg() + ": " + e.getMessage(), e);
        }
    }

    static void validateTable(Table table) throws SemanticException {
        if (table.isNonNative()) {
            throw new SemanticException(ErrorMsg.EXIM_FOR_NON_NATIVE.getMsg());
        }
    }

    public static String relativeToAbsolutePath(HiveConf conf, String location) throws SemanticException {
        try {
            boolean testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
            if (testMode) {
                URI uri = new Path(location).toUri();
                FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
                String scheme = fs.getScheme();
                String authority = uri.getAuthority();
                String path = uri.getPath();
                if (!path.startsWith("/")) {
                    path = new Path(System.getProperty("test.tmp.dir"), path).toUri().getPath();
                }
                try {
                    uri = new URI(scheme, authority, path, null, null);
                }
                catch (URISyntaxException e) {
                    throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
                }
                return uri.toString();
            }
            return location;
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.IO_ERROR.getMsg() + ": " + e.getMessage(), e);
        }
    }

    public static void createDbExportDump(FileSystem fs, Path metadataPath, Database dbObj, ReplicationSpec replicationSpec) throws IOException, SemanticException {
        FSDataOutputStream out = fs.create(metadataPath);
        JsonGenerator jgen = new JsonFactory().createJsonGenerator((OutputStream)out);
        jgen.writeStartObject();
        jgen.writeStringField("version", METADATA_FORMAT_VERSION);
        dbObj.putToParameters(ReplicationSpec.KEY.CURR_STATE_ID.toString(), replicationSpec.getCurrentReplicationState());
        if (METADATA_FORMAT_FORWARD_COMPATIBLE_VERSION != null) {
            jgen.writeStringField("fcversion", METADATA_FORMAT_FORWARD_COMPATIBLE_VERSION);
        }
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        try {
            jgen.writeStringField("db", serializer.toString(dbObj, "UTF-8"));
        }
        catch (TException e) {
            throw new SemanticException(ErrorMsg.ERROR_SERIALIZE_METASTORE.getMsg(), e);
        }
        jgen.writeEndObject();
        jgen.close();
    }

    public static void createExportDump(FileSystem fs, Path metadataPath, Table tableHandle, Iterable<Partition> partitions, ReplicationSpec replicationSpec) throws SemanticException, IOException {
        if (replicationSpec == null) {
            replicationSpec = new ReplicationSpec();
        }
        if (tableHandle == null) {
            replicationSpec.setNoop(true);
        }
        FSDataOutputStream out = fs.create(metadataPath);
        JsonGenerator jgen = new JsonFactory().createJsonGenerator((OutputStream)out);
        jgen.writeStartObject();
        jgen.writeStringField("version", METADATA_FORMAT_VERSION);
        if (METADATA_FORMAT_FORWARD_COMPATIBLE_VERSION != null) {
            jgen.writeStringField("fcversion", METADATA_FORMAT_FORWARD_COMPATIBLE_VERSION);
        }
        if (replicationSpec.isInReplicationScope()) {
            for (ReplicationSpec.KEY key : ReplicationSpec.KEY.values()) {
                String value = replicationSpec.get(key);
                if (value == null) continue;
                jgen.writeStringField(key.toString(), value);
            }
            if (tableHandle != null) {
                org.apache.hadoop.hive.metastore.api.Table ttable = tableHandle.getTTable();
                ttable.putToParameters(ReplicationSpec.KEY.CURR_STATE_ID.toString(), replicationSpec.getCurrentReplicationState());
                if (ttable.getParameters().containsKey("EXTERNAL") && ttable.getParameters().get("EXTERNAL").equalsIgnoreCase("TRUE")) {
                    ttable.putToParameters("EXTERNAL", "FALSE");
                }
                if (ttable.isSetTableType() && ttable.getTableType().equalsIgnoreCase(TableType.EXTERNAL_TABLE.toString())) {
                    ttable.setTableType(TableType.MANAGED_TABLE.toString());
                }
            }
        }
        if (tableHandle != null && !replicationSpec.isNoop()) {
            TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
            try {
                jgen.writeStringField("table", serializer.toString(tableHandle.getTTable(), "UTF-8"));
                jgen.writeFieldName("partitions");
                jgen.writeStartArray();
                if (partitions != null) {
                    for (Partition partition : partitions) {
                        org.apache.hadoop.hive.metastore.api.Partition tptn = partition.getTPartition();
                        if (replicationSpec.isInReplicationScope()) {
                            tptn.putToParameters(ReplicationSpec.KEY.CURR_STATE_ID.toString(), replicationSpec.getCurrentReplicationState());
                            if (tptn.getParameters().containsKey("EXTERNAL") && tptn.getParameters().get("EXTERNAL").equalsIgnoreCase("TRUE")) {
                                tptn.putToParameters("EXTERNAL", "FALSE");
                            }
                        }
                        jgen.writeString(serializer.toString(tptn, "UTF-8"));
                        jgen.flush();
                    }
                }
                jgen.writeEndArray();
            }
            catch (TException e) {
                throw new SemanticException(ErrorMsg.ERROR_SERIALIZE_METASTORE.getMsg(), e);
            }
        }
        jgen.writeEndObject();
        jgen.close();
    }

    public static ReadMetaData readMetaData(FileSystem fs, Path metadataPath) throws IOException, SemanticException {
        try (FSDataInputStream mdstream = null;){
            mdstream = fs.open(metadataPath);
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream sb = new ByteArrayOutputStream();
            int read = mdstream.read(buffer);
            while (read != -1) {
                sb.write(buffer, 0, read);
                read = mdstream.read(buffer);
            }
            String md = new String(sb.toByteArray(), "UTF-8");
            JSONObject jsonContainer = new JSONObject(md);
            String version = jsonContainer.getString("version");
            String fcversion = EximUtil.getJSONStringEntry(jsonContainer, "fcversion");
            EximUtil.checkCompatibility(version, fcversion);
            String dbDesc = EximUtil.getJSONStringEntry(jsonContainer, "db");
            String tableDesc = EximUtil.getJSONStringEntry(jsonContainer, "table");
            TDeserializer deserializer = new TDeserializer(new TJSONProtocol.Factory());
            Database db = null;
            if (dbDesc != null) {
                db = new Database();
                deserializer.deserialize(db, dbDesc, "UTF-8");
            }
            org.apache.hadoop.hive.metastore.api.Table table = null;
            ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partitionsList = null;
            if (tableDesc != null) {
                table = new org.apache.hadoop.hive.metastore.api.Table();
                deserializer.deserialize(table, tableDesc, "UTF-8");
                JSONArray jsonPartitions = new JSONArray(jsonContainer.getString("partitions"));
                partitionsList = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>(jsonPartitions.length());
                for (int i = 0; i < jsonPartitions.length(); ++i) {
                    String partDesc = jsonPartitions.getString(i);
                    org.apache.hadoop.hive.metastore.api.Partition partition = new org.apache.hadoop.hive.metastore.api.Partition();
                    deserializer.deserialize(partition, partDesc, "UTF-8");
                    partitionsList.add(partition);
                }
            }
            ReadMetaData readMetaData = new ReadMetaData(db, table, partitionsList, EximUtil.readReplicationSpec(jsonContainer));
            return readMetaData;
        }
    }

    private static ReplicationSpec readReplicationSpec(final JSONObject jsonContainer) {
        Function<String, String> keyFetcher = new Function<String, String>(){

            @Override
            public String apply(@Nullable String s) {
                return EximUtil.getJSONStringEntry(jsonContainer, s);
            }
        };
        return new ReplicationSpec(keyFetcher);
    }

    private static String getJSONStringEntry(JSONObject jsonContainer, String name) {
        String retval = null;
        try {
            retval = jsonContainer.getString(name);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return retval;
    }

    private static void checkCompatibility(String version, String fcVersion) throws SemanticException {
        EximUtil.doCheckCompatibility(METADATA_FORMAT_VERSION, version, fcVersion);
    }

    public static void doCheckCompatibility(String currVersion, String version, String fcVersion) throws SemanticException {
        if (version == null) {
            throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Version number missing"));
        }
        StringTokenizer st = new StringTokenizer(version, ".");
        int data_major = Integer.parseInt(st.nextToken());
        StringTokenizer st2 = new StringTokenizer(currVersion, ".");
        int code_major = Integer.parseInt(st2.nextToken());
        int code_minor = Integer.parseInt(st2.nextToken());
        if (code_major > data_major) {
            throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Not backward compatible. Producer version " + version + ", Consumer version " + currVersion));
        }
        if (fcVersion == null || fcVersion.isEmpty()) {
            if (code_major < data_major) {
                throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Not forward compatible.Producer version " + version + ", Consumer version " + currVersion));
            }
        } else {
            StringTokenizer st3 = new StringTokenizer(fcVersion, ".");
            int fc_major = Integer.parseInt(st3.nextToken());
            int fc_minor = Integer.parseInt(st3.nextToken());
            if (fc_major > code_major || fc_major == code_major && fc_minor > code_minor) {
                throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Not forward compatible.Minimum version " + fcVersion + ", Consumer version " + currVersion));
            }
        }
    }

    public static Map<String, String> makePartSpec(List<FieldSchema> partCols, List<String> partVals) {
        TreeMap<String, String> partSpec = new TreeMap<String, String>();
        for (int i = 0; i < partCols.size(); ++i) {
            partSpec.put(partCols.get(i).getName(), partVals.get(i));
        }
        return partSpec;
    }

    public static boolean schemaCompare(List<FieldSchema> newSchema, List<FieldSchema> oldSchema) {
        Iterator<FieldSchema> newColIter = newSchema.iterator();
        for (FieldSchema oldCol : oldSchema) {
            FieldSchema newCol = null;
            if (!newColIter.hasNext()) {
                return false;
            }
            newCol = newColIter.next();
            if (oldCol.getName().equals(newCol.getName()) && oldCol.getType().equals(newCol.getType())) continue;
            return false;
        }
        return !newColIter.hasNext();
    }

    public static PathFilter getDirectoryFilter(final FileSystem fs) {
        return new PathFilter(){

            public boolean accept(Path p) {
                try {
                    return fs.isDirectory(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static class ReadMetaData {
        private final Database db;
        private final org.apache.hadoop.hive.metastore.api.Table table;
        private final Iterable<org.apache.hadoop.hive.metastore.api.Partition> partitions;
        private final ReplicationSpec replicationSpec;

        public ReadMetaData() {
            this(null, null, null, new ReplicationSpec());
        }

        public ReadMetaData(Database db, org.apache.hadoop.hive.metastore.api.Table table, Iterable<org.apache.hadoop.hive.metastore.api.Partition> partitions, ReplicationSpec replicationSpec) {
            this.db = db;
            this.table = table;
            this.partitions = partitions;
            this.replicationSpec = replicationSpec;
        }

        public Database getDatabase() {
            return this.db;
        }

        public org.apache.hadoop.hive.metastore.api.Table getTable() {
            return this.table;
        }

        public Iterable<org.apache.hadoop.hive.metastore.api.Partition> getPartitions() {
            return this.partitions;
        }

        public ReplicationSpec getReplicationSpec() {
            return this.replicationSpec;
        }
    }

    public static class SemanticAnalyzerWrapperContext {
        private HiveConf conf;
        private Hive db;
        private HashSet<ReadEntity> inputs;
        private HashSet<WriteEntity> outputs;
        private List<Task<? extends Serializable>> tasks;
        private Logger LOG;
        private Context ctx;

        public HiveConf getConf() {
            return this.conf;
        }

        public Hive getHive() {
            return this.db;
        }

        public HashSet<ReadEntity> getInputs() {
            return this.inputs;
        }

        public HashSet<WriteEntity> getOutputs() {
            return this.outputs;
        }

        public List<Task<? extends Serializable>> getTasks() {
            return this.tasks;
        }

        public Logger getLOG() {
            return this.LOG;
        }

        public Context getCtx() {
            return this.ctx;
        }

        public SemanticAnalyzerWrapperContext(HiveConf conf, Hive db, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs, List<Task<? extends Serializable>> tasks, Logger LOG, Context ctx) {
            this.conf = conf;
            this.db = db;
            this.inputs = inputs;
            this.outputs = outputs;
            this.tasks = tasks;
            this.LOG = LOG;
            this.ctx = ctx;
        }
    }
}

