/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.timestamp;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import jodd.datetime.JDateTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;

public class NanoTimeUtils {
    static final long NANOS_PER_HOUR = TimeUnit.HOURS.toNanos(1L);
    static final long NANOS_PER_MINUTE = TimeUnit.MINUTES.toNanos(1L);
    static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    static final long NANOS_PER_DAY = TimeUnit.DAYS.toNanos(1L);
    private static final ThreadLocal<Calendar> parquetGMTCalendar = new ThreadLocal();
    private static final ThreadLocal<Calendar> parquetLocalCalendar = new ThreadLocal();

    private static Calendar getGMTCalendar() {
        if (parquetGMTCalendar.get() == null) {
            parquetGMTCalendar.set(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        }
        return parquetGMTCalendar.get();
    }

    private static Calendar getLocalCalendar() {
        if (parquetLocalCalendar.get() == null) {
            parquetLocalCalendar.set(Calendar.getInstance());
        }
        return parquetLocalCalendar.get();
    }

    public static Calendar getCalendar(boolean skipConversion) {
        Calendar calendar = skipConversion ? NanoTimeUtils.getLocalCalendar() : NanoTimeUtils.getGMTCalendar();
        calendar.clear();
        return calendar;
    }

    public static NanoTime getNanoTime(Timestamp ts, boolean skipConversion) {
        Calendar calendar = NanoTimeUtils.getCalendar(skipConversion);
        calendar.setTime(ts);
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            year = 1 - year;
        }
        JDateTime jDateTime = new JDateTime(year, calendar.get(2) + 1, calendar.get(5));
        int days = jDateTime.getJulianDayNumber();
        long hour = calendar.get(11);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        long nanos = ts.getNanos();
        long nanosOfDay = nanos + NANOS_PER_SECOND * second + NANOS_PER_MINUTE * minute + NANOS_PER_HOUR * hour;
        return new NanoTime(days, nanosOfDay);
    }

    public static Timestamp getTimestamp(NanoTime nt, boolean skipConversion) {
        long nanosOfDay;
        int julianDay = nt.getJulianDay();
        long remainder = nanosOfDay = nt.getTimeOfDayNanos();
        julianDay = (int)((long)julianDay + remainder / NANOS_PER_DAY);
        if ((remainder %= NANOS_PER_DAY) < 0L) {
            remainder += NANOS_PER_DAY;
            --julianDay;
        }
        JDateTime jDateTime = new JDateTime((double)julianDay);
        Calendar calendar = NanoTimeUtils.getCalendar(skipConversion);
        calendar.set(1, jDateTime.getYear());
        calendar.set(2, jDateTime.getMonth() - 1);
        calendar.set(5, jDateTime.getDay());
        int hour = (int)(remainder / NANOS_PER_HOUR);
        int minutes = (int)((remainder %= NANOS_PER_HOUR) / NANOS_PER_MINUTE);
        int seconds = (int)((remainder %= NANOS_PER_MINUTE) / NANOS_PER_SECOND);
        long nanos = remainder % NANOS_PER_SECOND;
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        Timestamp ts = new Timestamp(calendar.getTimeInMillis());
        ts.setNanos((int)nanos);
        return ts;
    }
}

