/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Date;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class IntervalYearMonthScalarAddDateColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private HiveIntervalYearMonth value;
    private int outputColumn;
    private Date scratchDate2;
    private Date outputDate;
    private DateTimeMath dtm = new DateTimeMath();

    public IntervalYearMonthScalarAddDateColumn(long value, int colNum, int outputColumn) {
        this.colNum = colNum;
        this.value = new HiveIntervalYearMonth((int)value);
        this.outputColumn = outputColumn;
        this.scratchDate2 = new Date(0L);
        this.outputDate = new Date(0L);
    }

    public IntervalYearMonthScalarAddDateColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector2.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector2.noNulls;
        outputColVector.isRepeating = inputColVector2.isRepeating;
        int n = batch.size;
        long[] vector2 = inputColVector2.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector2.isRepeating) {
            this.scratchDate2.setTime(DateWritable.daysToMillis((int)vector2[0]));
            this.dtm.add(this.value, this.scratchDate2, this.outputDate);
            outputVector[0] = DateWritable.dateToDays(this.outputDate);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColVector2.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchDate2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                    this.dtm.add(this.value, this.scratchDate2, this.outputDate);
                    outputVector[i] = DateWritable.dateToDays(this.outputDate);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchDate2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                    this.dtm.add(this.value, this.scratchDate2, this.outputDate);
                    outputVector[i] = DateWritable.dateToDays(this.outputDate);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.scratchDate2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                this.dtm.add(this.value, this.scratchDate2, this.outputDate);
                outputVector[i] = DateWritable.dateToDays(this.outputDate);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.scratchDate2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                this.dtm.add(this.value, this.scratchDate2, this.outputDate);
                outputVector[i] = DateWritable.dateToDays(this.outputDate);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
        NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.value.toString() + ", col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_year_month"), VectorExpressionDescriptor.ArgumentType.getType("date")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

