/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HiveParserTypeInfoUtils {
    public static List<PrimitiveObjectInspector.PrimitiveCategory> numericTypeList = new ArrayList<PrimitiveObjectInspector.PrimitiveCategory>();
    public static EnumMap<PrimitiveObjectInspector.PrimitiveCategory, Integer> numericTypes = new EnumMap(PrimitiveObjectInspector.PrimitiveCategory.class);

    public static synchronized void registerNumericType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, int level) {
        numericTypeList.add(primitiveCategory);
        numericTypes.put(primitiveCategory, level);
    }

    public static boolean implicitConvertible(TypeInfo from, TypeInfo to) {
        if (from.equals(to)) {
            return true;
        }
        if (from.getCategory() == ObjectInspector.Category.PRIMITIVE && to.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return HiveParserTypeInfoUtils.implicitConvertible(((PrimitiveTypeInfo)from).getPrimitiveCategory(), ((PrimitiveTypeInfo)to).getPrimitiveCategory());
        }
        return false;
    }

    public static boolean implicitConvertible(PrimitiveObjectInspector.PrimitiveCategory from, PrimitiveObjectInspector.PrimitiveCategory to) {
        if (from == to) {
            return true;
        }
        PrimitiveObjectInspectorUtils.PrimitiveGrouping fromPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(from);
        PrimitiveObjectInspectorUtils.PrimitiveGrouping toPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(to);
        if (fromPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && to == PrimitiveObjectInspector.PrimitiveCategory.DOUBLE) {
            return true;
        }
        if (from == PrimitiveObjectInspector.PrimitiveCategory.VOID) {
            return true;
        }
        if (fromPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP && toPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return true;
        }
        if (fromPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP && toPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return true;
        }
        if (fromPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && toPg == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return true;
        }
        Integer f = numericTypes.get((Object)from);
        Integer t = numericTypes.get((Object)to);
        if (f == null || t == null) {
            return false;
        }
        return f <= t;
    }

    static {
        HiveParserTypeInfoUtils.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.BYTE, 1);
        HiveParserTypeInfoUtils.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.SHORT, 2);
        HiveParserTypeInfoUtils.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.INT, 3);
        HiveParserTypeInfoUtils.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.LONG, 4);
        HiveParserTypeInfoUtils.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.DECIMAL, 5);
        HiveParserTypeInfoUtils.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, 6);
        HiveParserTypeInfoUtils.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, 7);
        HiveParserTypeInfoUtils.registerNumericType(PrimitiveObjectInspector.PrimitiveCategory.STRING, 8);
    }
}

