/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.flink.table.planner.delegation.hive.SqlFunctionConverter;

public class TableFunctionConverter
extends SqlFunctionConverter {
    private final RelNode leftRel;

    public TableFunctionConverter(RelOptCluster cluster, RelNode leftRel, SqlOperatorTable opTable, SqlNameMatcher nameMatcher) {
        super(cluster, opTable, nameMatcher);
        this.leftRel = leftRel;
    }

    @Override
    public RexNode visitCall(RexCall call) {
        SqlOperator operator = call.getOperator();
        if (this.isHiveCalciteSqlFn(operator)) {
            SqlOperator convertedOperator = this.convertOperator(operator, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
            ArrayList<Object> convertedOperands = new ArrayList<Object>();
            RelDataTypeFactory.FieldInfoBuilder dataTypeBuilder = this.cluster.getTypeFactory().builder();
            dataTypeBuilder.addAll((Iterable)this.leftRel.getRowType().getFieldList());
            dataTypeBuilder.addAll((Iterable)call.getType().getFieldList());
            RelDataType correlType = dataTypeBuilder.uniquify().build();
            InputRefConverter inputRefConverter = new InputRefConverter(correlType, this.cluster);
            for (RexNode operand : call.getOperands()) {
                convertedOperands.add(operand.accept((RexVisitor)inputRefConverter));
            }
            return this.builder.makeCall(call.getType(), convertedOperator, convertedOperands);
        }
        return super.visitCall(call);
    }

    private static class InputRefConverter
    extends RexShuttle {
        private final RelDataType correlType;
        private final RelOptCluster cluster;
        private final RexBuilder builder;

        private InputRefConverter(RelDataType correlType, RelOptCluster cluster) {
            this.correlType = correlType;
            this.cluster = cluster;
            this.builder = cluster.getRexBuilder();
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            CorrelationId correlId = this.cluster.createCorrel();
            RexNode correlRex = this.builder.makeCorrel(this.correlType, correlId);
            return this.builder.makeFieldAccess(correlRex, inputRef.getIndex());
        }
    }
}

