/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.hadoop.metadata;

import java.util.Locale;
import org.apache.flink.hive.shaded.parquet.format.CompressionCodec;
import org.apache.flink.hive.shaded.parquet.hadoop.codec.CompressionCodecNotSupportedException;

public enum CompressionCodecName {
    UNCOMPRESSED(null, CompressionCodec.UNCOMPRESSED, ""),
    SNAPPY("org.apache.flink.hive.shaded.parquet.hadoop.codec.SnappyCodec", CompressionCodec.SNAPPY, ".snappy"),
    GZIP("org.apache.hadoop.io.compress.GzipCodec", CompressionCodec.GZIP, ".gz"),
    LZO("com.hadoop.compression.lzo.LzoCodec", CompressionCodec.LZO, ".lzo"),
    BROTLI("org.apache.hadoop.io.compress.BrotliCodec", CompressionCodec.BROTLI, ".br"),
    LZ4("org.apache.hadoop.io.compress.Lz4Codec", CompressionCodec.LZ4, ".lz4"),
    ZSTD("org.apache.hadoop.io.compress.ZStandardCodec", CompressionCodec.ZSTD, ".zstd");

    private final String hadoopCompressionCodecClass;
    private final CompressionCodec parquetCompressionCodec;
    private final String extension;

    public static CompressionCodecName fromConf(String name) {
        if (name == null) {
            return UNCOMPRESSED;
        }
        return CompressionCodecName.valueOf(name.toUpperCase(Locale.ENGLISH));
    }

    public static CompressionCodecName fromCompressionCodec(Class<?> clazz) {
        if (clazz == null) {
            return UNCOMPRESSED;
        }
        String name = clazz.getName();
        for (CompressionCodecName codec : CompressionCodecName.values()) {
            if (!name.equals(codec.getHadoopCompressionCodecClassName())) continue;
            return codec;
        }
        throw new CompressionCodecNotSupportedException(clazz);
    }

    public static CompressionCodecName fromParquet(CompressionCodec codec) {
        for (CompressionCodecName codecName : CompressionCodecName.values()) {
            if (!codec.equals(codecName.parquetCompressionCodec)) continue;
            return codecName;
        }
        throw new IllegalArgumentException("Unknown compression codec " + codec);
    }

    private CompressionCodecName(String hadoopCompressionCodecClass, CompressionCodec parquetCompressionCodec, String extension) {
        this.hadoopCompressionCodecClass = hadoopCompressionCodecClass;
        this.parquetCompressionCodec = parquetCompressionCodec;
        this.extension = extension;
    }

    public String getHadoopCompressionCodecClassName() {
        return this.hadoopCompressionCodecClass;
    }

    public Class getHadoopCompressionCodecClass() {
        String codecClassName = this.getHadoopCompressionCodecClassName();
        if (codecClassName == null) {
            return null;
        }
        try {
            return Class.forName(codecClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public CompressionCodec getParquetCompressionCodec() {
        return this.parquetCompressionCodec;
    }

    public String getExtension() {
        return this.extension;
    }
}

