/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.hadoop;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.hive.shaded.parquet.Preconditions;
import org.apache.flink.hive.shaded.parquet.column.ParquetProperties;
import org.apache.flink.hive.shaded.parquet.hadoop.CodecFactory;
import org.apache.flink.hive.shaded.parquet.hadoop.InternalParquetRecordWriter;
import org.apache.flink.hive.shaded.parquet.hadoop.MemoryManager;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetFileWriter;
import org.apache.flink.hive.shaded.parquet.hadoop.api.WriteSupport;
import org.apache.flink.hive.shaded.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.flink.hive.shaded.parquet.schema.MessageType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ParquetRecordWriter<T>
extends RecordWriter<Void, T> {
    private final InternalParquetRecordWriter<T> internalWriter;
    private final MemoryManager memoryManager;
    private final CodecFactory codecFactory;

    @Deprecated
    public ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, int blockSize, int pageSize, CodecFactory.BytesCompressor compressor, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion) {
        ParquetProperties props = ParquetProperties.builder().withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).withDictionaryEncoding(enableDictionary).withWriterVersion(writerVersion).build();
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, compressor, validating, props);
        this.memoryManager = null;
        this.codecFactory = null;
    }

    @Deprecated
    public ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, long blockSize, int pageSize, CodecFactory.BytesCompressor compressor, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, MemoryManager memoryManager) {
        ParquetProperties props = ParquetProperties.builder().withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).withDictionaryEncoding(enableDictionary).withWriterVersion(writerVersion).build();
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, compressor, validating, props);
        this.memoryManager = Preconditions.checkNotNull(memoryManager, "memoryManager");
        memoryManager.addWriter(this.internalWriter, blockSize);
        this.codecFactory = null;
    }

    ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, long blockSize, CompressionCodecName codec, boolean validating, ParquetProperties props, MemoryManager memoryManager, Configuration conf) {
        this.codecFactory = new CodecFactory(conf, props.getPageSizeThreshold());
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, this.codecFactory.getCompressor(codec), validating, props);
        this.memoryManager = Preconditions.checkNotNull(memoryManager, "memoryManager");
        memoryManager.addWriter(this.internalWriter, blockSize);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            this.internalWriter.close();
        }
        finally {
            if (this.codecFactory != null) {
                this.codecFactory.release();
            }
            if (this.memoryManager != null) {
                this.memoryManager.removeWriter(this.internalWriter);
            }
        }
    }

    public void write(Void key, T value) throws IOException, InterruptedException {
        this.internalWriter.write(value);
    }
}

