/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.column.impl;

import java.io.IOException;
import org.apache.flink.hive.shaded.parquet.bytes.BytesInput;
import org.apache.flink.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.flink.hive.shaded.parquet.column.ParquetProperties;
import org.apache.flink.hive.shaded.parquet.column.impl.ColumnWriterBase;
import org.apache.flink.hive.shaded.parquet.column.page.PageWriter;
import org.apache.flink.hive.shaded.parquet.column.statistics.Statistics;
import org.apache.flink.hive.shaded.parquet.column.values.ValuesWriter;

final class ColumnWriterV1
extends ColumnWriterBase {
    ColumnWriterV1(ColumnDescriptor path, PageWriter pageWriter, ParquetProperties props) {
        super(path, pageWriter, props);
    }

    @Override
    ValuesWriter createRLWriter(ParquetProperties props, ColumnDescriptor path) {
        return props.newRepetitionLevelWriter(path);
    }

    @Override
    ValuesWriter createDLWriter(ParquetProperties props, ColumnDescriptor path) {
        return props.newDefinitionLevelWriter(path);
    }

    @Override
    void writePage(int rowCount, int valueCount, Statistics<?> statistics, ValuesWriter repetitionLevels, ValuesWriter definitionLevels, ValuesWriter values) throws IOException {
        this.pageWriter.writePage(BytesInput.concat(repetitionLevels.getBytes(), definitionLevels.getBytes(), values.getBytes()), valueCount, rowCount, statistics, repetitionLevels.getEncoding(), definitionLevels.getEncoding(), values.getEncoding());
    }
}

