/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet.vector.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.hive.shaded.formats.parquet.vector.reader.AbstractColumnReader;
import org.apache.flink.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.flink.hive.shaded.parquet.column.page.PageReader;
import org.apache.flink.hive.shaded.parquet.schema.PrimitiveType;
import org.apache.flink.table.data.vector.writable.WritableDoubleVector;
import org.apache.flink.table.data.vector.writable.WritableIntVector;

public class DoubleColumnReader
extends AbstractColumnReader<WritableDoubleVector> {
    public DoubleColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        super(descriptor, pageReader);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.DOUBLE);
    }

    @Override
    protected void readBatch(int rowId, int num, WritableDoubleVector column) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    if (this.runLenDecoder.currentValue == this.maxDefLevel) {
                        this.readDoubles(n, column, rowId);
                        break;
                    }
                    column.setNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] == this.maxDefLevel) {
                            column.setDouble(rowId + i, this.readDouble());
                            continue;
                        }
                        column.setNullAt(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableDoubleVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            column.setDouble(i, this.dictionary.decodeToDouble(dictionaryIds.getInt(i)));
        }
    }

    private double readDouble() {
        return this.readDataBuffer(8).getDouble();
    }

    private void readDoubles(int total, WritableDoubleVector c, int rowId) {
        int requiredBytes = total * 8;
        ByteBuffer buffer = this.readDataBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.setDoublesFromBinary(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.setDouble(rowId + i, buffer.getDouble());
            }
        }
    }
}

