/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connectors.hive.CachedSerializedValue;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;

@PublicEvolving
public class HiveTablePartition
implements Serializable {
    private static final long serialVersionUID = 4145470177119940673L;
    private final CachedSerializedValue<StorageDescriptor> storageDescriptor;
    private final Map<String, String> partitionSpec;
    private final Properties tableProps;

    public HiveTablePartition(StorageDescriptor storageDescriptor, Properties tableProps) {
        this(storageDescriptor, new LinkedHashMap<String, String>(), tableProps);
    }

    public HiveTablePartition(StorageDescriptor storageDescriptor, Map<String, String> partitionSpec, Properties tableProps) {
        try {
            this.storageDescriptor = new CachedSerializedValue<Object>(Preconditions.checkNotNull((Object)storageDescriptor, (String)"storageDescriptor can not be null"));
        }
        catch (IOException e) {
            throw new FlinkHiveException("Failed to serialize StorageDescriptor", e);
        }
        this.partitionSpec = (Map)Preconditions.checkNotNull(partitionSpec, (String)"partitionSpec can not be null");
        this.tableProps = (Properties)Preconditions.checkNotNull((Object)tableProps, (String)"tableProps can not be null");
    }

    public StorageDescriptor getStorageDescriptor() {
        try {
            return this.storageDescriptor.deserializeValue();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new FlinkHiveException("Failed to deserialize StorageDescriptor", e);
        }
    }

    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    public Properties getTableProps() {
        return this.tableProps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTablePartition that = (HiveTablePartition)o;
        return Objects.equals(this.getStorageDescriptor(), that.getStorageDescriptor()) && Objects.equals(this.partitionSpec, that.partitionSpec) && Objects.equals(this.tableProps, that.tableProps);
    }

    public int hashCode() {
        return Objects.hash(this.getStorageDescriptor(), this.partitionSpec, this.tableProps);
    }

    public String toString() {
        StorageDescriptor sd = this.getStorageDescriptor();
        return "HiveTablePartition{" + String.format("PartitionSpec=%s, ", this.partitionSpec) + String.format("Location=%s, ", sd.getLocation()) + String.format("InputFormat=%s", sd.getInputFormat()) + "}";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HiveTablePartition ofTable(HiveConf hiveConf, @Nullable String hiveVersion, String dbName, String tableName) {
        HiveShim hiveShim = HiveTablePartition.getHiveShim(hiveVersion);
        try (HiveMetastoreClientWrapper client = new HiveMetastoreClientWrapper(hiveConf, hiveShim);){
            Table hiveTable = client.getTable(dbName, tableName);
            HiveTablePartition hiveTablePartition = new HiveTablePartition(hiveTable.getSd(), HiveReflectionUtils.getTableMetadata(hiveShim, hiveTable));
            return hiveTablePartition;
        }
        catch (TException e) {
            throw new FlinkHiveException(String.format("Failed to create HiveTablePartition for hive table %s.%s", dbName, tableName), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HiveTablePartition ofPartition(HiveConf hiveConf, @Nullable String hiveVersion, String dbName, String tableName, LinkedHashMap<String, String> partitionSpec) {
        HiveShim hiveShim = HiveTablePartition.getHiveShim(hiveVersion);
        try (HiveMetastoreClientWrapper client = new HiveMetastoreClientWrapper(hiveConf, hiveShim);){
            Table hiveTable = client.getTable(dbName, tableName);
            Partition hivePartition = client.getPartition(dbName, tableName, new ArrayList<String>(partitionSpec.values()));
            HiveTablePartition hiveTablePartition = new HiveTablePartition(hivePartition.getSd(), partitionSpec, HiveReflectionUtils.getTableMetadata(hiveShim, hiveTable));
            return hiveTablePartition;
        }
        catch (TException e) {
            throw new FlinkHiveException(String.format("Failed to create HiveTablePartition for partition %s of hive table %s.%s", partitionSpec, dbName, tableName), e);
        }
    }

    private static HiveShim getHiveShim(String hiveVersion) {
        hiveVersion = hiveVersion != null ? hiveVersion : HiveShimLoader.getHiveVersion();
        return HiveShimLoader.loadHiveShim(hiveVersion);
    }
}

