/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.ContinuousEnumerationSettings;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.connector.file.src.assigners.SimpleSplitAssigner;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.connectors.hive.HiveOptions;
import org.apache.flink.connectors.hive.HiveSource;
import org.apache.flink.connectors.hive.HiveSourceFileEnumerator;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.HiveTableSource;
import org.apache.flink.connectors.hive.JobConfWrapper;
import org.apache.flink.connectors.hive.read.HiveBulkFormatAdapter;
import org.apache.flink.connectors.hive.read.HiveContinuousPartitionFetcher;
import org.apache.flink.connectors.hive.read.HiveSourceSplit;
import org.apache.flink.connectors.hive.util.HiveConfUtils;
import org.apache.flink.connectors.hive.util.HivePartitionUtils;
import org.apache.flink.connectors.hive.util.JobConfUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.filesystem.FileSystemConnectorOptions;
import org.apache.flink.table.filesystem.LimitableBulkFormat;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.JobConf;
import org.apache.thrift.TException;

@PublicEvolving
public class HiveSourceBuilder {
    private static final Duration DEFAULT_SCAN_MONITOR_INTERVAL = Duration.ofMinutes(1L);
    private final JobConf jobConf;
    private final ReadableConfig flinkConf;
    private final ObjectPath tablePath;
    private final Map<String, String> tableOptions;
    private final TableSchema fullSchema;
    private final List<String> partitionKeys;
    private final String hiveVersion;
    private int[] projectedFields;
    private Long limit;
    private List<HiveTablePartition> partitions;

    public HiveSourceBuilder(@Nonnull JobConf jobConf, @Nonnull ReadableConfig flinkConf, @Nullable String hiveVersion, @Nonnull String dbName, @Nonnull String tableName, @Nonnull Map<String, String> tableOptions) {
        this.jobConf = jobConf;
        this.flinkConf = flinkConf;
        this.tablePath = new ObjectPath(dbName, tableName);
        this.hiveVersion = hiveVersion == null ? HiveShimLoader.getHiveVersion() : hiveVersion;
        HiveConf hiveConf = HiveConfUtils.create((org.apache.hadoop.conf.Configuration)jobConf);
        HiveShim hiveShim = HiveShimLoader.loadHiveShim(this.hiveVersion);
        try (HiveMetastoreClientWrapper client = new HiveMetastoreClientWrapper(hiveConf, hiveShim);){
            Table hiveTable = client.getTable(dbName, tableName);
            this.fullSchema = HiveTableUtil.createTableSchema(hiveConf, hiveTable, client, hiveShim);
            this.partitionKeys = HiveCatalog.getFieldNames(hiveTable.getPartitionKeys());
            this.tableOptions = new HashMap<String, String>(hiveTable.getParameters());
            this.tableOptions.putAll(tableOptions);
        }
        catch (TException e) {
            throw new FlinkHiveException("Failed to get hive table", e);
        }
        HiveSourceBuilder.validateScanConfigurations(this.tableOptions);
        HiveTableUtil.checkAcidTable(this.tableOptions, this.tablePath);
    }

    public HiveSourceBuilder(@Nonnull JobConf jobConf, @Nonnull ReadableConfig flinkConf, @Nonnull ObjectPath tablePath, @Nullable String hiveVersion, @Nonnull CatalogTable catalogTable) {
        this.jobConf = jobConf;
        this.flinkConf = flinkConf;
        this.tablePath = tablePath;
        this.hiveVersion = hiveVersion == null ? HiveShimLoader.getHiveVersion() : hiveVersion;
        this.fullSchema = catalogTable.getSchema();
        this.partitionKeys = catalogTable.getPartitionKeys();
        this.tableOptions = catalogTable.getOptions();
        HiveSourceBuilder.validateScanConfigurations(this.tableOptions);
        HiveTableUtil.checkAcidTable(this.tableOptions, tablePath);
    }

    public HiveSource<RowData> buildWithDefaultBulkFormat() {
        return this.buildWithBulkFormat(this.createDefaultBulkFormat());
    }

    public <T> HiveSource<T> buildWithBulkFormat(BulkFormat<T, HiveSourceSplit> bulkFormat) {
        Configuration configuration = Configuration.fromMap(this.tableOptions);
        ContinuousEnumerationSettings continuousSourceSettings = null;
        HiveContinuousPartitionFetcher fetcher = null;
        HiveTableSource.HiveContinuousPartitionFetcherContext fetcherContext = null;
        if (this.isStreamingSource()) {
            Preconditions.checkState((this.partitions == null ? 1 : 0) != 0, (Object)"setPartitions shouldn't be called in streaming mode");
            if (this.partitionKeys.isEmpty()) {
                FileSystemConnectorOptions.PartitionOrder partitionOrder = (FileSystemConnectorOptions.PartitionOrder)configuration.get(FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_ORDER);
                if (partitionOrder != FileSystemConnectorOptions.PartitionOrder.CREATE_TIME) {
                    throw new UnsupportedOperationException("Only '" + FileSystemConnectorOptions.PartitionOrder.CREATE_TIME + "' is supported for non partitioned table.");
                }
                this.partitions = Collections.singletonList(HiveTablePartition.ofTable(HiveConfUtils.create((org.apache.hadoop.conf.Configuration)this.jobConf), this.hiveVersion, this.tablePath.getDatabaseName(), this.tablePath.getObjectName()));
            }
            Duration monitorInterval = configuration.get(FileSystemConnectorOptions.STREAMING_SOURCE_MONITOR_INTERVAL) == null ? DEFAULT_SCAN_MONITOR_INTERVAL : (Duration)configuration.get(FileSystemConnectorOptions.STREAMING_SOURCE_MONITOR_INTERVAL);
            Preconditions.checkArgument((!monitorInterval.isNegative() && !monitorInterval.isZero() ? 1 : 0) != 0, (Object)"monitorInterval must be > 0");
            continuousSourceSettings = new ContinuousEnumerationSettings(monitorInterval);
            if (!this.partitionKeys.isEmpty()) {
                fetcher = new HiveContinuousPartitionFetcher();
                String defaultPartitionName = JobConfUtils.getDefaultPartitionName(this.jobConf);
                fetcherContext = new HiveTableSource.HiveContinuousPartitionFetcherContext(this.tablePath, HiveShimLoader.loadHiveShim(this.hiveVersion), new JobConfWrapper(this.jobConf), this.partitionKeys, this.fullSchema.getFieldDataTypes(), this.fullSchema.getFieldNames(), configuration, defaultPartitionName);
            }
        } else if (this.partitions == null) {
            this.partitions = HivePartitionUtils.getAllPartitions(this.jobConf, this.hiveVersion, this.tablePath, this.partitionKeys, null);
        }
        FileSplitAssigner.Provider & Serializable splitAssigner = continuousSourceSettings == null || this.partitionKeys.isEmpty() ? FileSource.DEFAULT_SPLIT_ASSIGNER : SimpleSplitAssigner::new;
        return new HiveSource<T>(new Path[1], new HiveSourceFileEnumerator.Provider(this.partitions != null ? this.partitions : Collections.emptyList(), new JobConfWrapper(this.jobConf)), splitAssigner, bulkFormat, continuousSourceSettings, this.jobConf, this.tablePath, this.partitionKeys, fetcher, fetcherContext);
    }

    public HiveSourceBuilder setPartitions(List<HiveTablePartition> partitions) {
        this.partitions = partitions;
        return this;
    }

    public HiveSourceBuilder setLimit(Long limit) {
        this.limit = limit;
        return this;
    }

    public HiveSourceBuilder setProjectedFields(int[] projectedFields) {
        this.projectedFields = projectedFields;
        return this;
    }

    private static void validateScanConfigurations(Map<String, String> configurations) {
        String partitionInclude = configurations.getOrDefault(FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_INCLUDE.key(), (String)FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_INCLUDE.defaultValue());
        Preconditions.checkArgument((boolean)"all".equals(partitionInclude), (Object)String.format("The only supported '%s' is 'all' in hive table scan, but is '%s'", FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_INCLUDE.key(), partitionInclude));
    }

    private boolean isStreamingSource() {
        return Boolean.parseBoolean(this.tableOptions.getOrDefault(FileSystemConnectorOptions.STREAMING_SOURCE_ENABLE.key(), ((Boolean)FileSystemConnectorOptions.STREAMING_SOURCE_ENABLE.defaultValue()).toString()));
    }

    private RowType getProducedRowType() {
        TableSchema producedSchema;
        if (this.projectedFields == null) {
            producedSchema = this.fullSchema;
        } else {
            String[] fullNames = this.fullSchema.getFieldNames();
            DataType[] fullTypes = this.fullSchema.getFieldDataTypes();
            producedSchema = TableSchema.builder().fields((String[])Arrays.stream(this.projectedFields).mapToObj(i -> fullNames[i]).toArray(String[]::new), (DataType[])Arrays.stream(this.projectedFields).mapToObj(i -> fullTypes[i]).toArray(DataType[]::new)).build();
        }
        return (RowType)((DataType)producedSchema.toRowDataType().bridgedTo(RowData.class)).getLogicalType();
    }

    private BulkFormat<RowData, HiveSourceSplit> createDefaultBulkFormat() {
        return LimitableBulkFormat.create((BulkFormat)new HiveBulkFormatAdapter(new JobConfWrapper(this.jobConf), this.partitionKeys, this.fullSchema.getFieldNames(), this.fullSchema.getFieldDataTypes(), this.hiveVersion, this.getProducedRowType(), (Boolean)this.flinkConf.get(HiveOptions.TABLE_EXEC_HIVE_FALLBACK_MAPRED_READER)), (Long)this.limit);
    }
}

